define pe_install::stop_service(
  String $service,
  Array[Type[Resource]] $before_reference = [Class['Puppet_enterprise::Packages']],
  Array[Type[Resource]] $after_reference = [],
  Boolean $disable_service = true,
  Optional[String] $stop_command = undef,
) {
  $stop_parameter = empty($stop_command) ? {
    true  => {},
    false => {
      stop => $stop_command,
    }
  }
  $enable_parameter = $disable_service ? {
    false => {},
    true => {
      enable => false,
    }
  }
  $additional_parameters = $stop_parameter + $enable_parameter
  service { "Shutdown ${service} before ${before_reference}":
    name    => $service,
    ensure  => stopped,
    before  => $before_reference,
    require => $after_reference,
    *       => $additional_parameters
  }
}

