require 'puppet_x/puppetlabs/meep/infra/lookup'
require 'puppet'

module PuppetX
  module Puppetlabs
    module Meep
      module Infra
        module FeatureFlags
          include PuppetX::Puppetlabs::Meep::Infra::Lookup
          include PuppetX::Puppetlabs::Meep::Caching

          # @param flag [String] flag keyword.
          # @return [Boolean] the boolean value of the requested element of
          #   the feature_flags hash from pe.conf.
          def feature_flag(flag)
            !!feature_flags[flag]
          end

          # @return [Hash] performs a hiera lookup for the 'feature_flags' hash
          #   and returns it or an empty hash if not found or not a hash.
          def feature_flags
            begin
              flags = puppet_lookup('feature_flags')
              case flags
              when Hash then flags
              else {}
              end
            rescue Puppet::Error => e
              Puppet.debug(_("Received error while attempting to look up feature_flags: %{msg}") % { msg: e.full_message })
              {}
            end
          end

        end
      end
    end
  end
end
