require 'puppet/util/command_line'
require 'puppet/application/apply'

module PuppetX
  module Util
    class Apply

      def self.run_puppet_apply(manifest, acceptable_codes=[0, 2])
        begin
          command_line = Puppet::Util::CommandLine.new('puppet', ['--execute', manifest, '--detailed-exitcodes'])
          apply = Puppet::Application::Apply.new(command_line)
          apply.parse_options
          apply.run_command
        rescue SystemExit => e
          raise e unless e.status && acceptable_codes.include?(e.status)
          case e.status
          when 0 then :unchanged
          when 1 then :failure
          when 2 then :changed
          when 4 then :failure
          when 6 then :failure
          else :unknown
          end
        end
      end

      def self.quoted_or_undef(param)
        # Quotes the param for use in a puppet manifest or returns undef if the
        # param is nil
        if param
          "'#{param}'"
        else
          'undef'
        end
      end

    end
  end
end
