class pe_manager::reinitialize_replication (
  Array[String] $databases      = [],
) inherits puppet_enterprise {

  # We don't currently necessarily need to set all of these globals
  # settings, but we've run into enough bugs due to missing settings
  # over the years that it's easier to just to lift this from
  # puppet_enterprise::profile::database and ensure
  # the pe_postgresql module has everything it needs.
  $pgsqldir = "${puppet_enterprise::server_data_dir}/postgresql"
  $version = $puppet_enterprise::params::postgres_version
  $datadir = "${pgsqldir}/${version}/data"

  class { '::pe_postgresql::globals':
    user                 => $puppet_enterprise::pg_user,
    group                => $puppet_enterprise::pg_group,
    client_package_name  => $puppet_enterprise::params::postgresql_client_package_name,
    server_package_name  => $puppet_enterprise::params::postgresql_server_package_name,
    contrib_package_name => $puppet_enterprise::params::postgresql_contrib_package_name,
    service_name         => 'pe-postgresql',
    default_database     => $puppet_enterprise::params::postgresql_default_database,
    version              => $version,
    bindir               => $puppet_enterprise::server_bin_dir,
    datadir              => $datadir,
    confdir              => $datadir,
    psql_path            => $puppet_enterprise::pg_psql_path,
  }

  include pe_postgresql::params

  # This will get turned back on with the puppet run
  # that recreates the databases.
  service { 'pe-console-services':
    ensure => stopped,
  }

  # reinitialize all the databases, or just the target database if specified

  $subscription_name = sprintf('s%.14s', sha1($trusted['certname']))

  $databases.map |$database_name| {
    # remove pglogical subscriptions and then pglogical itself
    puppet_enterprise::pg::pglogical::subscription { "${database_name}/${subscription_name}":
      ensure            => absent,
      subscription_name => $subscription_name,
      database          => $database_name
    } ->

    puppet_enterprise::psql { "drop pglogical extension for ${database_name} sql":
      db      => $database_name,
      command => "drop extension pglogical cascade",
    } ->

    # kill potentially leftover connections
    puppet_enterprise::psql { "kill pglogical connections for ${database_name} sql":
      db      => 'pe-postgres',
      command => "SELECT pg_terminate_backend(pg_stat_activity.pid)
                         FROM pg_stat_activity
                         WHERE pg_stat_activity.datname = '${database_name}'"
    } ->

    # drop the database
    puppet_enterprise::psql { "drop ${database_name} sql":
      db      => 'pe-postgres',
      command => "DROP DATABASE IF EXISTS \"${database_name}\""
    }
  }

}
