# Convert 1048576k or 1024m or 1g to 1024
# KMG365 ... Station 51!

function puppet_enterprise::memorysize_to_megabytes (
  Optional[Pattern[/^\d+[kmgKMG]$/]] $ms
) {
  if ($ms) {
    if ($ms =~ /^(\d+)([kmgKMG])$/) {
      $ms_integer = Integer($1)
      $ms_unit = $2
      $megabytes = $ms_unit ? {
        /[kK]/ => Integer($ms_integer / 1024),
        /[mM]/ => $ms_integer,
        /[gG]/ => $ms_integer * 1024,
      }
    } else {
      0
    }
  } else {
    0
  }
}
