# Node Classifier Activity Reporting

The Node Classifier integrates with the PE Activity Service in order to report changes made by users to groups.
As node groups are the only thing for which the Node Classifier service is the source of truth, this is the only sort of activity that is reported.
In particular, nothing is reported when a server asks for the classification of a node.

## Node Group Activity

Node group activity is reported to the activity service whenever a node group is:

  * created;
  * deleted;
  * edited.
  * nodes are pinned
  * nodes are unpinned

All reports contain a commit map with the following keys and values:

  * `service`, which always has the value `"classifier"`.
  * `subject`, whose value is the rbac subject corresponding to the API user.
  * `objects`, whose value is an array of maps.  Each entry has one entry with three keys: `type`, which always has the value `"node_groups"`; `id`, whose value is the UUID of the group; and `name`, whose value is the (human-oriented) name of the group. For node pinning/unpinning operations, the objects will also contain an entry for each node where `type` is `node` and `id` and `name` are set to the certname.
  * `events`, whose value is an array of event maps.

Every event map has the following keys and values:

  * `type`, whose value is one of `"create", `"delete"`, or `"edit"`.
  * `what`, whose value always begins with `"node_group"`, and may further specify the field that changed (for events in an edit report).
  * `description`, whose value is a string that varies by event.
  * `message`, whose value is a human-readable string describing the event, and varies by event.

### Creation Reports

When a node group is created, the commit sent to the Activity Service contains one event.
The event's `description` is always `"create_node_group"`.
The event's `message` states the name and UUID that the group was created with.

### Deletion Reports

When a node group is deleted, the commit sent to the Activity Service contains one event.
The event's `description` is always `"delete_node_group"`.
The event's `message` states the name and UUID of the deleted group.

### Edit Reports

When a group is edited, the commit will contain one event for each individual primitive field of the group that was changed, an event for any classes that were added to or deleted from the group, and an event for each particular class parameter or top-level variable that was added, deleted, or edited (except in the case where class parameters are deleted as a byproduct of an entire class being deleted from the group; in this case, there is only a single event indicating the deletion of the entire class from the group, regardless of the presence or number of parameters that the group may have defined for the class).

The primitive group fields are:

  * `name`
  * `environment`
  * `description`
  * `parent`
  * `rule`

Whenever the value of a primitive group field changes, the edit report will contain one event describing that change.
The event's `what` key will have the value `"node_group_<field>"` and the `description` key will have the value `"edit_node_group_<field>"`, where `<field>` is simply the field's name (e.g. `environment`).
The `message` key of the event will state the field changed and the value it was changed to.

Whenever a group is edited such that it contains a class that was not associated with the group before the edit, then the edit report will contain an event describing each such addition, regardless of whether or not any parameter values were defined for that class.
The `what` key of the event will be `"node_group_class"`, and the `description` will be `"add_node_group_class_<class>"`, where `<class>` is the name of the class.
The `message` key of the event will contain the same information as the `description`, just in a more human-friendly format.

Similarly, whenever a group is edited such that it does not contain a class that was associated with the group before the edit, then the edit report will contain an event describing each such deletion, regardless of whether or not any parameter values were defined for that class.
The `what` key of the event will be `"node_group_class"`, and the `description` will be `"delete_node_group_class_<class>"`, where `<class>` is the name of the class.
The `message` key of the event will contain the same information as the `description`, just in a more human-friendly format.

Whenever a group is edited such that a class parameter value is added, changed, or deleted, and the group still contains that class after the edit, then the edit report will contain an event describing each such addition, change, or deletion.
The `what` key of the event will be `"node_group_class_parameter"`, and the description will be `"{add,edit,delete}_node_group_class_parameter_<class>_<parameter>"`, where `<class>` is the name of the class, `<parameter>` is the name of the specific parameter, and one of `add`, `edit`, or `delete` is selected as appropriate.
The `message` key of the event will contain the same information as the `description` key, just in a more human-friendly format.

When a group is edited such that class parameter values are removed due to the class being removed from the group, the report will only contain an event describing the removal of the group.
It will not contain events describing the removal of the individual parameters of that class.

Whenever a group is edited such that a top-level variable value is added, changed, or deleted, then the edit report will contain an event describing each such addition, change, or deletion.
The `what` key of the event will be `"node_group_variable"`, and the description will be `"{add,edit,delete}_node_group_variable_<variable>"`, where `<variable>` is the name of the variable, and `add`, `edit`, or `delete` is selected as appropriate.
The `message` key of the event will contain the same information as the `description` key, just in a more human-friendly format.
