require 'cgi'
require 'json'

require 'pe_license'

class PELicense::Status
  def self.metric
    CGI.escape('puppetlabs.puppetdb.population:name=num-nodes')
  end

  def self.retrieve(conn)
    begin
      response = conn.get('/pdb/query/v4/nodes?query=["extract",[["function","count","certname"]]]')
      code = response.code.to_i
      raise response.body unless (200...300).include?(code)

      result = JSON.parse(response.body)

      nodes = result.first['count']

      new(nodes)
    rescue => e
      raise "Unable to retrieve number of licensed nodes from PuppetDB: #{e}"
    end
  end

  attr_reader :nodes

  def initialize(nodes)
    @nodes = nodes
  end
end
