# Reference

<!-- DO NOT EDIT: This document was generated by Puppet Strings -->

## Table of Contents

### Tasks

* [`init`](#init): Manage and inspect the state of services
* [`linux`](#linux): Manage and inspect the state of services (without a puppet agent)
* [`windows`](#windows): Manage the state of Windows services (without a puppet agent)

## Tasks

### <a name="init"></a>`init`

Manage and inspect the state of services

**Supports noop?** false

#### Parameters

##### `action`

Data type: `Enum[start, stop, restart, enable, disable, status]`

The operation (start, stop, restart, enable, disable, status) to perform on the service.

##### `name`

Data type: `String[1]`

The name of the service to operate on.

##### `force`

Data type: `Optional[Boolean]`

Force a Windows service to restart even if it has dependent services. This parameter is passed for Windows services only.

##### `provider`

Data type: `Optional[String[1]]`

The provider to use to manage or inspect the service, defaults to the system service manager. Only used when the 'puppet-agent' feature is available on the target so we can leverage Puppet.

### <a name="linux"></a>`linux`

Manage and inspect the state of services (without a puppet agent)

**Supports noop?** false

#### Parameters

##### `action`

Data type: `Enum[start, stop, restart, status, enable, disable]`

The operation (start, stop, restart, status, enable, disable) to perform on the service.

##### `name`

Data type: `String[1]`

The name of the service to operate on.

### <a name="windows"></a>`windows`

Manage the state of Windows services (without a puppet agent)

**Supports noop?** false

#### Parameters

##### `action`

Data type: `Enum[start, stop, restart, status]`

The operation (start, stop, restart, status) to perform on the service

##### `name`

Data type: `String[1]`

The short name of the Windows service to operate on.

##### `force`

Data type: `Optional[Boolean]`

Force the service to stop or restart, even if other services depend on it

