# PE's bootstrap module accepts strings for custom_atribute and extension_request
# that are comma separated strings of key=value pairs that ultimately pe_repo
# install scripts will convert and place into csr.yaml. (or into puppet.conf once
# we wire bootstrap to pass agent:certname=foo type parameters)
#
# For convenience, the enterprise_task plans allow these args to be passed
# around as hashes and converted at the last moment before we call bootstrap.
function enterprise_tasks::convert_agent_installer_arg(
  Variant[Hash,Array[Pattern[/\w+=\w+/]]] $arg,
) {
  case $arg {
    Hash:    { $arg.map |$key, $value| { "${key}=${value}" } }
    default: { $arg }
  }
}
