#!/opt/puppetlabs/puppet/bin/ruby
# frozen_string_literal: true

require_relative '../files/enterprise_task_helper.rb' if __FILE__ == $PROGRAM_NAME
require_relative '../lib/enterprise_tasks/network'
require_relative '../lib/enterprise_tasks/rbac'

class CreateEnterpriseTasksRBACUser < EnterpriseTaskHelper
  include EnterpriseTasks::Network
  include EnterpriseTasks::RBAC

  def base_role
    role_description = [
      "This role is auto-generated and managed by the pe-installer's",
      'enterprise_tasks module. It is used internally by Puppet Enterprise',
      'management tasks and should not be modified.',
    ].join(' ')

    permissions = [
      permission('environment', 'deploy_code'),
      permission('nodes', 'view_data'),
      permission('puppet_agent', 'run'),
      permission('orchestrator', 'view'),
      permission('tasks', 'run'),
    ]

    {
      'display_name' => EnterpriseTasks::RBAC::ENTERPRISE_TASKS_ROLE_NAME,
      'description'  => role_description,
      'permissions'  => permissions,
    }
  end

  def base_user
    {
      'login'        => EnterpriseTasks::RBAC::ENTERPRISE_TASKS_USER_LOGIN,
      'email'        => '',
      'display_name' => 'Puppet Enterprise Tasks User (managed by PE)',
    }
  end

  def task(password:, **_kwargs)
    # Cleanup existing user/role if present
    delete_enterprise_tasks_user_and_role

    # Generate fresh user and role
    role = add_role(base_role)
    user = add_user(base_user.merge(
      'password' => password,
      'role_ids' => [role['id']],
    ))

    {
      success: true,
      user: user,
      role: role,
    }.to_json
  end
end

CreateEnterpriseTasksRBACUser.run if __FILE__ == $PROGRAM_NAME
