#!/opt/puppetlabs/puppet/bin/ruby
# frozen_string_literal: true

require_relative '../files/enterprise_task_helper.rb'
require 'open3'

class GetBootstrapMetadata < EnterpriseTaskHelper
  def task(pe_dir:, **_kwargs)
    bootstrap_file = "#{pe_dir}/packages/bootstrap-metadata"
    contents = File.read(bootstrap_file)
    results = contents.split.each_with_object({}) do |line, collector|
      key, value = line.split('=')
      collector[key.downcase] = value
    end
    results['bootstrap_file'] = bootstrap_file
    results
  end
end

GetBootstrapMetadata.run if __FILE__ == $PROGRAM_NAME
