# frozen_string_literal: true

require_relative '../files/enterprise_task_helper.rb'
require 'open3'

class InstallerFacter < EnterpriseTaskHelper
  def task(**_kwargs)
    facter_path = '/opt/puppetlabs/installer/bin/facter'
    cmd = [facter_path, '--json']
    facts, stderr, status = Open3.capture3(*cmd)
    if !status.success?
      raise EnterpriseTaskHelper::Error.new(
        "Failed calling #{facter_path}.",
        'pe.enterprise-tasks/installer-facter',
        {
          command: cmd.join(' '),
          stdout: facts,
          stderr: stderr,
          exitcode: status.exitstatus,
        }
      )
    end

    facts
  end
end

InstallerFacter.run if __FILE__ == $PROGRAM_NAME
