#!/opt/puppetlabs/puppet/bin/ruby
# frozen_string_literal: true

require_relative '../files/enterprise_task_helper.rb' if __FILE__ == $PROGRAM_NAME
require 'open3'

class PuppetAccess < EnterpriseTaskHelper
  def task(account:, password:, lifetime:, token_file: nil, **_kwargs)
    puppet_access = '/opt/puppetlabs/bin/puppet-access'
    command = [puppet_access, 'login', account, '--lifetime', lifetime]
    command += ['--token-file', token_file] if !token_file.nil?
    output, status = Open3.capture2e(*command, stdin_data: password)

    if !status.success?
      raise EnterpriseTaskHelper::Error.new(
        "Failed puppet-access login for #{account}.",
        'puppetlabs.puppet-access/failed-login',
        {
          account:  account,
          lifetime: lifetime,
          output:   output,
          status:   status.exitstatus,
        },
      )
    else
      command = [puppet_access, 'show']
      command += ['--token-file', token_file] if !token_file.nil?
      output2, status2 = Open3.capture2e(*command)
      if !status2.success?
        raise EnterpriseTaskHelper::Error.new(
          'Failed puppet-access show.',
          'puppetlabs.puppet-access/failed-show',
          {
            output:   output2,
            status:   status2.exitstatus,
          },
        )
      end
      token = output2.chomp
    end

    {
      success: true,
      token: token,
      token_file: token_file || "#{ENV['HOME']}/.puppetlabs/token",
    }.to_json
  end
end

PuppetAccess.run if __FILE__ == $PROGRAM_NAME
