#!/opt/puppetlabs/puppet/bin/ruby
# frozen_string_literal: true

require_relative '../lib/enterprise_tasks/node_groups'
require_relative '../files/enterprise_task_helper.rb'

class UpdateNodeGroup < EnterpriseTaskHelper
  include EnterpriseTasks::NodeGroups

  def task(group_name:, class_parameters:, **_kwargs)
    initialize_pe_modules
    group = get_group(group_name)

    update_group({
      id: group['id'],
      classes: class_parameters,
    })

    group = get_group(group_name, refresh: true)

    {
      success: true,
      group: group,
    }
  end
end

UpdateNodeGroup.run if __FILE__ == $PROGRAM_NAME
