# Reference

<!-- DO NOT EDIT: This document was generated by Puppet Strings -->

## Table of Contents

### Resource types

* [`reboot`](#reboot)

### Tasks

* [`init`](#init): Reboots a machine
* [`last_boot_time`](#last_boot_time): Gets the last boot time of a Linux or Windows system
* [`last_boot_time_nix`](#last_boot_time_nix): Gets the last boot time of a Linux system
* [`last_boot_time_win`](#last_boot_time_win): Gets the last boot time of a Windows system
* [`nix`](#nix): Reboots a machine
* [`win`](#win): Reboots a machine

### Plans

* [`reboot`](#reboot): Reboots targets and waits for them to be available again.

## Resource types

### <a name="reboot"></a>`reboot`

The reboot type.

#### Properties

The following properties are available in the `reboot` type.

##### `when`

Valid values: `refreshed`, `pending`

When to check for, and if needed, perform a reboot. If `pending`,
then the provider will check if a reboot is pending, and only
if needed, reboot the system.  If `refreshed` then the reboot
will only be performed in response to a refresh event from
another resource, e.g. `package`.

Default value: `refreshed`

#### Parameters

The following parameters are available in the `reboot` type.

* [`apply`](#apply)
* [`message`](#message)
* [`name`](#name)
* [`onlyif`](#onlyif)
* [`provider`](#provider)
* [`timeout`](#timeout)
* [`unless`](#unless)

##### <a name="apply"></a>`apply`

Valid values: `immediately`, `finished`

When to apply the reboot. If `immediately`, then the provider
will stop applying additional resources and apply the reboot once
puppet has finished syncing. If `finished`, it will continue
applying resources and then perform a reboot at the end of the
run. The default is `immediately`.

Default value: `immediately`

##### <a name="message"></a>`message`


Default value: `Puppet is rebooting the computer`

##### <a name="name"></a>`name`

namevar


##### <a name="onlyif"></a>`onlyif`

For pending reboots, only reboot if the reboot is pending
for one of the supplied reasons.

##### <a name="provider"></a>`provider`

The specific backend to use for this `reboot` resource. You will seldom need to specify this --- Puppet will usually
discover the appropriate provider for your platform.

##### <a name="timeout"></a>`timeout`

The amount of time in seconds to wait between the time the reboot
is requested and when the reboot is performed.  The default timeout
is 60 seconds.  Note that this time starts once puppet has exited the
current run.

Default value: `60`

##### <a name="unless"></a>`unless`

For pending reboots, ignore the supplied reasons when checking pennding reboot

## Tasks

### <a name="init"></a>`init`

Reboots a machine

**Supports noop?** false

#### Parameters

##### `timeout`

Data type: `Optional[Variant[Pattern[/^[0-9]*$/],Integer]]`

Timeout before shutdown (seconds); enforces a minimum of 3s

##### `message`

Data type: `Optional[Pattern[/^[^|&]*$/]]`

Shutdown message for systems that support it

##### `shutdown_only`

Data type: `Optional[Boolean]`

Only shut the machine down, do not reboot

### <a name="last_boot_time"></a>`last_boot_time`

Gets the last boot time of a Linux or Windows system

**Supports noop?** false

### <a name="last_boot_time_nix"></a>`last_boot_time_nix`

Gets the last boot time of a Linux system

**Supports noop?** false

### <a name="last_boot_time_win"></a>`last_boot_time_win`

Gets the last boot time of a Windows system

**Supports noop?** false

### <a name="nix"></a>`nix`

Reboots a machine

**Supports noop?** false

#### Parameters

##### `timeout`

Data type: `Optional[Integer[3]]`

Timeout before shutdown (seconds)

##### `message`

Data type: `Optional[Pattern[/^[^|&]*$/]]`

Shutdown message for systems that support it

##### `shutdown_only`

Data type: `Optional[Boolean]`

Only shut the machine down, do not reboot

### <a name="win"></a>`win`

Reboots a machine

**Supports noop?** false

#### Parameters

##### `timeout`

Data type: `Optional[Integer[3]]`

Timeout before shutdown (seconds)

##### `message`

Data type: `Optional[Pattern[/^[^|&]*$/]]`

Shutdown message for systems that support it

##### `shutdown_only`

Data type: `Optional[Boolean]`

Only shut the machine down, do not reboot

## Plans

### <a name="reboot"></a>`reboot`

Reboots targets and waits for them to be available again.

#### Parameters

The following parameters are available in the `reboot` plan:

* [`targets`](#targets)
* [`message`](#message)
* [`reboot_delay`](#reboot_delay)
* [`disconnect_wait`](#disconnect_wait)
* [`reconnect_timeout`](#reconnect_timeout)
* [`retry_interval`](#retry_interval)
* [`fail_plan_on_errors`](#fail_plan_on_errors)

##### <a name="targets"></a>`targets`

Data type: `TargetSpec`

Targets to reboot.

##### <a name="message"></a>`message`

Data type: `Optional[String]`

Message to log with the reboot (for platforms that support it).

Default value: ``undef``

##### <a name="reboot_delay"></a>`reboot_delay`

Data type: `Integer[1]`

How long (in seconds) to wait before rebooting. Defaults to 1.

Default value: `1`

##### <a name="disconnect_wait"></a>`disconnect_wait`

Data type: `Integer[0]`

How long (in seconds) to wait before checking whether the server has rebooted. Defaults to 10.

Default value: `10`

##### <a name="reconnect_timeout"></a>`reconnect_timeout`

Data type: `Integer[0]`

How long (in seconds) to attempt to reconnect before giving up. Defaults to 180.

Default value: `180`

##### <a name="retry_interval"></a>`retry_interval`

Data type: `Integer[0]`

How long (in seconds) to wait between retries. Defaults to 1.

Default value: `1`

##### <a name="fail_plan_on_errors"></a>`fail_plan_on_errors`

Data type: `Boolean`

Raise an error if any targets do not successfully reboot. Defaults to true.

Default value: ``true``

