# frozen_string_literal: true

# THIS IS A PE SPECIFIC IMPLEMENTATION OF get_resources: THIS IMPLEMENTATION WILL OVERRIDE THE ONE
# THAT COMES WITH A BOLT INSTALLATION
#
# Open-source bolt implementation:
# https://github.com/puppetlabs/bolt/blob/master/bolt-modules/boltlib/lib/puppet/functions/get_resources.rb
#
# get_resources for plans-in-PE will return an error since it is not needed in the current iteration
# of plans in PE.
Puppet::Functions.create_function(:get_resources) do
  # @param targets A pattern or array of patterns identifying a set of targets.
  # @param resources A resource type or instance, or an array of such.
  # @return A result set with a list of hashes representing each resource.
  # @example Collect resource states for packages and a file
  #   get_resources('target1,target2', [Package, File[/etc/puppetlabs]])
  dispatch :get_resources do
    param 'Boltlib::TargetSpec', :targets
    param 'Variant[String, Type[Resource], Array[Variant[String, Type[Resource]]]]', :resources
    return_type 'ResultSet'
  end

  def get_resources(target_spec, resources)
    unless Puppet[:tasks]
      raise Puppet::ParseErrorWithIssue
        .from_issue_and_stack(Bolt::PAL::Issues::PLAN_OPERATION_NOT_SUPPORTED_WHEN_COMPILING, action: 'get_resources')
    end

    raise Puppet::Error, "get_resources is currently not supported in PE plans"
  end
end
