# Puppet Enterprise Management Tools

This repository is one of several that comprise the tooling used to manage
installations of Puppet Enterprise.

* Repositories
  * Source Code
    * [puppetlabs/pe_installer](https://github.com/puppetlabs/pe_installer).
    * [puppetlabs/puppet-enterprise-modules](https://github.com/puppetlabs/puppet-enterprise-modules)
    * [puppetlabs/enterprise_tasks](https://github.com/puppetlabs/enterprise_tasks)
    * [puppetlabs/pe-installer-shim](https://github.com/puppetlabs/pe-installer-shim)

  * Vanagon Packaging Repositories
    * [puppetlabs/pe-modules-vanagon](https://github.com/puppetlabs/pe-modules-vanagon)
    * [puppetlabs/pe-installer-vanagon](https://github.com/puppetlabs/pe-installer-vanagon)
* Documentation
  * [pe-admin Design](https://github.com/puppetlabs/pe_installer/blob/master/docs/pe-admin-design.md)
  * [Overview of puppet-enterprise-installer tooling](https://github.com/puppetlabs/pe-installer-shim/blob/master/PUPPET_ENTERPRISE_INSTALLER.md) - this is the older puppet-enterprise-installer script and the puppet-infra configure tool.
    * [Walkthrough of `puppet-infra configure` install catalog generation](https://github.com/puppetlabs/pe-installer-shim/blob/master/docs/how-meep-builds-the-pe-catalog-for-installation.md)
  * [Annotated 2018.1.4 install log](https://github.com/puppetlabs/pe-installer-shim/blob/master/docs/annotated-logs/install-2018.1.4.log.annotated.md)
  * [Outline of the classification problems in PE management](https://github.com/puppetlabs/pe-installer-shim/blob/master/docs/pe-modules-next-discussion-outline.txt)
  * puppet-infrastructure
    * [configure](https://github.com/puppetlabs/puppet-enterprise-modules/tree/master/modules/pe_manager)
    * run - tbd
    * [status](https://github.com/puppetlabs/puppet-enterprise-modules/blob/master/modules/pe_manager/doc/infrastructure_status.md)
    * [tune](https://github.com/puppetlabs/puppet-enterprise-modules/blob/master/modules/pe_manager/doc/infrastructure_tune.md)
    * provision - tbd
    * upgrade - tbd
    * [HA Overview](https://github.com/puppetlabs/puppet-enterprise-modules/tree/master/modules/pe_manager/doc/high_availability)
      * [provision replica](https://github.com/puppetlabs/puppet-enterprise-modules/blob/master/modules/pe_manager/doc/high_availability/infrastructure_provision_replica.md)
      * [enable](https://github.com/puppetlabs/puppet-enterprise-modules/blob/master/modules/pe_manager/doc/high_availability/infrastructure_enable_replica.md)
      * [forget](https://github.com/puppetlabs/puppet-enterprise-modules/blob/master/modules/pe_manager/doc/high_availability/infrastructure_forget_replica.md)
      * [reinitialize](https://github.com/puppetlabs/puppet-enterprise-modules/blob/master/modules/pe_manager/doc/high_availability/infrastructure_reinitialize_replication.md)
      * [upgrade replica](https://github.com/puppetlabs/puppet-enterprise-modules/blob/master/modules/pe_manager/doc/high_availability/infrastructure_upgrade_replica.md)
  * [Overview of puppet-enterprise-modules](https://github.com/puppetlabs/puppet-enterprise-modules)
    * [puppet_enterprise](https://github.com/puppetlabs/puppet-enterprise-modules/tree/master/modules/puppet_enterprise)
    * [pe_install](https://github.com/puppetlabs/puppet-enterprise-modules/tree/master/modules/pe_install)
  * [enterprise_tasks](https://github.com/puppetlabs/enterprise_tasks)

# pe_installer: The Ruby Installer

This gem provides installation and management support for Puppet Enterprise
using Bolt.

The principle tool that it provides is 'pe-admin'.

This repo is also used to store various Ruby scripts under the exe dir which in
older versions of PE were called by the puppet-enterprise-installer script to
perform more complex operations in Ruby.

## Installation

The gem is packaged as a component of the pe-installer package, managed by the
[pe-installer-vanagon](https://github.com/puppetlabs/pe-installer-vanagon)
project.

In addition to the gems listed in the Gemfile, the pe-admin tool has
dependencies on a puppet-runtime,
[enterprise_tasks](https://github.com/puppetlabs/enterprise_tasks), and
[puppet-enterprise-modules](https://github.com/puppetlabs/puppet-enterprise-modules)
which are provided by the package.

## Usage

### pe-admin

The pe-admin tool is a Ruby CLI built with
[Thor](https://github.com/erikhuda/thor). It provides UI for interacting with
PE tarballs and executing management plans via Bolt. The plans are currently in
[enterprise_tasks/plans/testing](https://github.com/pupptlabs/enterprise_tasks).

The simplest way to work with the tool is probably to install the pe-installer
package from a PE tarball
([master/ci-ready](https://artifactory.delivery.puppetlabs.net/artifactory/generic_enterprise__local/master/ci-ready/)
for example), or otherwise obtain the package directly from artifactory
([master el7
rpms](https://artifactory.delivery.puppetlabs.net/artifactory/list/rpm_enterprise__local/master/repos/el-7-x86_64/)
for example).

To install the tool from a PE tarball, unpack the tarball and then run the
bootstrap-installer script that is part of the tarball.

The package installs into /opt/puppetlabs/installer, and the tool is runable
from /opt/puppetlabs/installer/bin/pe-admin.

For commandline help:

    /opt/puppetlabs/installer/bin/pe-admin help

#### Transport

The pe-admin tool is built on top of Bolt and makes use of the Bolt runtime
that is part of the pe-installer package. The install command uses ssh
transport to interact with the target nodes, unless you are running the
command on the master that you are installing to, in which case local
transport is used. The local-install command always runs over local transport
on the same node.

#### Commands

##### install

    /opt/puppetlabs/installer/bin/pe-admin install --master master.net --tarball /some/pe-tarball.tar

Handles first time installation of Puppet Enterprise from the given tarball to
some set of PE nodes. This command can be used to orchestrate an entire PE
installation regardless of architecture (master, database, compilers, replica,
see [Installing Pe](#installing-pe) below).

##### local-install

    /opt/puppetlabs/installer/bin/pe-admin local-install --pe-tarball-dir /some/unpacked/pe/tarball --pe-conf /some/pe.conf

This is an internal command (better names openly solicited).

Applies a puppet catalog on the local node to install packages and metadata
from the given PE tarball dir, and apply the correct puppet_enterprise profiles
based on the given pe.conf hiera configuration.

The command is only used to setup the core infrastructure nodes (master, and
potentially database in the case of extra large architecture).

This command is used internally during `pe-admin install` orchestration. It
only needs to be run manually in the case of an extra large install where ssh
is not available as transport.

##### upgrade

Upgrade an existing PE installation.

TBD

##### repair

Repair configuration of an existing PE installation.

TBD

##### validate

Validate that a given PE installation is in working order.

TBD

#### Installing PE

##### SSH (remote)

These cases assume you can use Bolt with SSH for transport to each of the
infrastructure nodes you're installing to.

We're also assuming that the workstation that we're installing from is not
itself the master node. However, they can be the same node so long as the
master can reach the rest of the infrastructure via SSH.

I expect it is more likely, though, that a customer will have a separate
workstation host that will have credentials to reach the infrastructure.

###### Standard

[(master, no compilers)](https://puppet.com/docs/pe/2019.8/choosing_an_architecture.html#standard-installation)

 1. Download the desired PE tarball onto your workstation
 2. Unpack it
 3. Run the bootstrap-installer script
 4. `/opt/puppetlabs/installer/bin/pe-admin install --master master.net --tarball /some/pe-tarball.tar`

This could/should be further automated if we make pe-installer available via
yum/apt.puppetlabs.com, just like puppet or bolt. Then the installer itself can
be installed/upgraded using yum or apt, and, if we implement a 'fetch' function,
it could pull down whatever PE tarball you wanted from pm.puppetlabs.com.

A customer then only needs a hole in their firewall to \*.puppetlabs.com to
make best use of the tool.

###### Large

[(master and compilers)](https://puppet.com/docs/pe/2019.8/choosing_an_architecture.html#large-installation)

 * add `--compilers compiler1.net,compiler2.net` to the pe-admin command

To properly configure a large installation, you need load balancers, which the
tool does not yet help you set up. If you already have load balancers, they can
be configured as documented
[here](https://puppet.com/docs/pe/2019.8/installing_compilers.html#using_load_balancers_with_compilers).

###### With HA

For the initial standard or large installation to include a replica:

 * add `--replicas replica.net` to the pe-admin command

The caveat here is that this assumes you first [set up code
manager](https://puppet.com/docs/pe/2019.8/code_mgr_config.html#configuring_code_manager).
The current plans install git and generate a local control-repository to manage
this for testing cases. Whether we want to make that an option for customers is
an open question.

The plans do have parameters for providing a control repo url
and private key, but they are not yet plumbed through in pe-admin, though you
could have them set in a pe.conf that you supply to pe-admin.

###### Extra Large

An extra-large installation splits the core PE services between a master and a
database node. This is the successor to the old legacy master/puppetdb/console
split installation.

[(master and database with or without compilers)](https://puppet.com/docs/pe/2019.8/choosing_an_architecture.html#extra-large-installation)

 * add `--database database.net` to the pe-admin command

To install with compilers, add --compilers as mentioned in Large, above.

###### Extra Large HA

TBD

For an extra large with ha, you need to be using the
[peadm module](https://github.com/puppetlabs/puppetlabs-peadm) which hasn't
been incorporated into pe-admin yet.

This relies on a change to the structure of an extra-large installation such
that both the master and the database node have running pe-postgresql services;
the former with pglogical managed databases, and the later with just the
puppetdb database. This must be set up from scratch, or you need to manually
move the console/orchestrator databases back to the master.

The peadm module also has support for setting up haproxy load balancers.

##### Local (no remote transport)

If the customer has made themselves so 'secure' that Bolt can't reach their
infrastructure, then they have to fall back to the older, more manual workflow
where they somehow get all the necessary files onto the node(s) and run the
local version of the install commands.

###### Standard

The steps are the same, just performed on the prospective master node itself.

###### Large

You would then need to manually generate agent nodes and provision them as
compilers.

###### Extra Large

As mentioned, an extra-large installation splits out the database onto a
separate node. In this installation, the core PE infrastructure is now split
across both a master and a database node and installation requires three
passes, once on the master to set up the CA, once on the database to set up
postgresql, then again on the master to finish configuring database dependent
services.

For this case, they have to place PE tarballs and pe.conf manually on both the
master and the database node, just as they do with the current installation
process, and then run the local-install commands themselves since we can't
orchestrate the installation for them with Bolt.

 1. Place the tarball and a configured pe.conf file on the master node
 2. Run `/opt/puppetlabs/installer/bin/pe-admin local-install --pe-installer-dir /some/pe-tarball --profile ca` on the master
 3. Place the tarball and a configured pe.conf on the database node.
 4. Run `/opt/puppetlabs/installer/bin/pe-admin local-install --pe-installer-dir /some/pe-tarball` on the database
 5. Run `/opt/puppetlabs/installer/bin/pe-admin local-install --pe-installer-dir /some/pe-tarball` again on the master
 6. Run puppet on the master
 7. Run puppet on the database
 8. Run puppet again on the master

These are the same basic steps that a user currently has to take for the
extra-large case, although with pe-admin, at least they aren't waiting for the
first install pass on the master to fail.

Because they are running the local-install manually on both nodes, they are
also not getting the validation that the fully orchestrated `pe-admin install`
would normally provide customers.

## Development

The various scriptlets used by the old puppet-enterprise-installer script that
lives in [pe-installer-shim](https://github.com/puppetlabs/pe-installer-shim)
are found in the [exe](./exe) directory. The pe-admin executable is here as
well. All of these are installed into the gem executable path when the
pe_installer module is installed into the pe-installer package.

The pe-admin executable kickstarts the main codebase which is under
lib/pe_installer. Details of that are in the [pe-admin-design.md
doc](./docs/pe-admin-design.md)

## Testing

To run specs and lint checks:

```
bundle install
bundle exec rake
```

## Releasing

At the moment we're not releasing pe_installer as a gem. It is just a component
of the pe-installer package.

## Contributing

Pull requests are welcome on GitHub at https://github.com/puppetlabs/pe_installer.

Tickets should be filed in Jira under the 'Puppet Enterprise [Internal]' project.

This project is intended to be a safe, welcoming space for collaboration, and
contributors are expected to adhere to the [Contributor
Covenant](http://contributor-covenant.org) code of conduct.

## Code of Conduct

Everyone interacting in the PeInstaller project’s codebases, issue trackers,
chat rooms and mailing lists is expected to follow the [code of
conduct](https://github.com/puppetlabs/pe_installer/blob/master/CODE_OF_CONDUCT.md).
