# Reference

<!-- DO NOT EDIT: This document was generated by Puppet Strings -->

## Table of Contents

### Classes

* [`puppet_agent`](#puppet_agent): == Class: puppet_agent  Upgrades Puppet 4 and newer to the requested version.  === Parameters  [arch]   The package architecture. Defaults to
* [`puppet_agent::configure`](#puppet_agentconfigure)
* [`puppet_agent::install`](#puppet_agentinstall): == Class puppet_agent::install  This class is called from puppet_agent for install.  === Parameters  [version]   The puppet-agent version to 
* [`puppet_agent::install::darwin`](#puppet_agentinstalldarwin): == Class puppet_agent::install::darwin  Private class called from puppet_agent class  Manage the install process for Darwin OSes specifically
* [`puppet_agent::install::solaris`](#puppet_agentinstallsolaris): == Class puppet_agent::install::solaris  Private class called from puppet_agent class  Manage the install process for solaris specifically
* [`puppet_agent::install::suse`](#puppet_agentinstallsuse): == Class puppet_agent::install::suse  Private class called from puppet_agent class  Manage the install process for SUSE OSes specifically
* [`puppet_agent::install::windows`](#puppet_agentinstallwindows): == Class puppet_agent::install::windows  Private class called from puppet_agent class  Manage the install process for windows specifically
* [`puppet_agent::osfamily::aix`](#puppet_agentosfamilyaix)
* [`puppet_agent::osfamily::darwin`](#puppet_agentosfamilydarwin)
* [`puppet_agent::osfamily::debian`](#puppet_agentosfamilydebian)
* [`puppet_agent::osfamily::redhat`](#puppet_agentosfamilyredhat)
* [`puppet_agent::osfamily::solaris`](#puppet_agentosfamilysolaris)
* [`puppet_agent::osfamily::suse`](#puppet_agentosfamilysuse)
* [`puppet_agent::osfamily::windows`](#puppet_agentosfamilywindows)
* [`puppet_agent::params`](#puppet_agentparams): == Class puppet_agent::params  This class is meant to be called from puppet_agent It sets variables according to platform.
* [`puppet_agent::prepare`](#puppet_agentprepare): == Class puppet_agent::prepare  This class is called from puppet_agent to prepare for the upgrade.  === Parameters  [version]   The puppet-ag
* [`puppet_agent::prepare::package`](#puppet_agentpreparepackage): == Class puppet_agent::prepare::package  The only job this class has is to ensure that the correct puppet-agent package is downloaded locally
* [`puppet_agent::prepare::puppet_config`](#puppet_agentpreparepuppet_config): == Class puppet_agent::prepare::puppet_config  Private class called from puppet_agent::prepare class
* [`puppet_agent::service`](#puppet_agentservice): == Class puppet_agent::service  This class is meant to be called from puppet_agent. It ensures that managed services are running.

### Resource types

* [`puppet_agent_end_run`](#puppet_agent_end_run): Stops the current Puppet run if a puppet-agent upgrade was performed. Used on platforms that manage the Puppet Agent upgrade with a package r
* [`puppet_agent_upgrade_error`](#puppet_agent_upgrade_error): Fails when a previous background installation failed. The type will check for the existance of an installation failure log and raise an error

### Functions

* [`any_resources_of_type`](#any_resources_of_type)
* [`uri_host_from_string`](#uri_host_from_string): Return a uri host from a string
* [`windows_msi_installargs`](#windows_msi_installargs): Return the $install_options parameter as a string usable in an msiexec command
* [`windows_native_path`](#windows_native_path): Return a windows native path

### Data types

* [`Puppet_agent::Arch`](#puppet_agentarch)
* [`Puppet_agent::Config`](#puppet_agentconfig)
* [`Puppet_agent::Config_setting`](#puppet_agentconfig_setting): An enumerated list of settings which are permitted to be managed by this module.

### Tasks

* [`delete_local_filebucket`](#delete_local_filebucket): Removes the local filebucket
* [`facts_diff`](#facts_diff): Run the Puppet agent facts diff action
* [`install`](#install): Install the Puppet agent package
* [`install_powershell`](#install_powershell): Install the Puppet agent package
* [`install_shell`](#install_shell): Install the Puppet agent package
* [`run`](#run): Run the Puppet agent. This task may cause problems if run in Puppet Enterprise.
* [`version`](#version): Get the version of the Puppet agent package installed. Returns nothing if none present.
* [`version_powershell`](#version_powershell): Get the version of the Puppet agent package installed. Returns nothing if none present.
* [`version_shell`](#version_shell): Get the version of the Puppet agent package installed. Returns nothing if none present.

### Plans

* [`puppet_agent::run`](#puppet_agentrun): Starts a Puppet agent run on the specified targets. Note: This plan may cause issues when run in Puppet Enterprise.

## Classes

### <a name="puppet_agent"></a>`puppet_agent`

== Class: puppet_agent

Upgrades Puppet 4 and newer to the requested version.

=== Parameters

[arch]
  The package architecture. Defaults to the architecture fact.
[collection]
  The Puppet Collection to track. Defaults to 'PC1'.
[is_pe]
  Install from Puppet Enterprise repos. Enabled if communicating with a PE master.
[manage_pki_dir]
  Whether or not to manage the /etc/pki directory.  Defaults to true.
  Managing the /etc/pki directory inside the puppet_agent module can be problematic for
  organizations that manage gpg keys and settings in other modules.
[manage_repo]
  Boolean to determine whether to configure repositories
  This is intended to provide the ability to disable configuring a local repo
  in support of systems that manage external repositories (i.e. spacewalk/satellite)
  to enable users to add the proper packages to their internal repos
  and to utilize default package providers for the install
[package_name]
  The package to upgrade to, i.e. `puppet-agent`.
[package_version]
  The package version to upgrade to. Explicitly specify the version to upgrade to,
  or set to 'auto' to specify the version of the compiling master.
[service_names]
  An array of services to start, normally `puppet` and `mcollective`.
  None will be started if the array is empty.
[source]
  **INCLUDED FOR COMPATIBILITY WITH MODULE VERSIONS 1.0/2.0. PREFER USE OF "absolute_source",
  "apt_source", "deb_source" etc. OVER USE OF "source".**

  The location to find packages. Replaces base URL for unix/MacOS agents, used as fully
  qualified path in windows
[absolute_source]
  The exact location of the package to install. The entire path to the package must be
  provided with this parameter.
[yum_source]
  Base URL of the location of mirrors of yum.puppet.com downloads sites. Directories under
  the URL "yum_source" should match the structure of the yum.puppet.com
[apt_source]
  Base URL of the location of mirrors of apt.puppet.com downloads sites. Directories under
  the URL "apt_source" should match the structure of the apt.puppet.com
[mac_source]
  Base URL of the location of mirrors of downloads.puppet.com downloads site that serves
  MacOS packages. Directories under the URL "mac_source" should match the structure of the
  downloads.puppet.com site
[windows_source]
  Base URL of the location of mirrors of downloads.puppet.com downloads site that serves
  Windows packages. Directories under the URL "windows_source" should match the structure of
  the downloads.puppet.com site
[solaris_source]
  Base URL of the location of a mirror for Solaris packages. Currently, solaris packages can
  only be made available by using puppetlabs-pe_repo. This means the mirror must be of a
  PE master package serve.
[aix_source]
  Base URL of the location of a mirror for AIX packages. Currently, AIX packages can
  only be made available by using puppetlabs-pe_repo. This means the mirror must be of a
  PE master package serve.
[use_alternate_sources]
  **ONLY APPLICABLE WHEN WORKING WITH PE INSTALLTIONS**
  When set to true will force downloads to come from the values of $apt_source, $deb_source
  $mac_source etc. rather than from the default PE master package serve. Note that this will
  also force downloads to ignore alternate_pe_source
[alternate_pe_source]
  Base URL of the location where packages are located in the same structure that's served
  by a PE master (the directory structure in PE for serving packages is created by the
  puppetlabs-pe_repo module). The general structure served by PE is:
  /packages/${pe_server_version}/${platform_tag}/${package_name}
[install_dir]
  The directory the puppet agent should be installed to. This is only applicable for
  windows operating systems. This only applies when upgrading the agent to a new
  version; it will not cause re-installation of the same version to a new location.
[install_options]
  An array of additional options to pass when installing puppet-agent. Each option in
  the array can either be a string or a hash. Each option will automatically be quoted
  when passed to the install command. With Windows packages, note that file paths in an
  install option must use backslashes. (Since install options are passed directly to
  the installation command, forward slashes won't be automatically converted like they
  are in `file` resources.) Note also that backslashes in double-quoted strings _must_
  be escaped and backslashes in single-quoted strings _can_ be escaped.
[msi_move_locked_files]
  This is only applicable for Windows operating systems. There may be instances where
  file locks cause unncessary service restarts.  By setting to true, the module
  will move files prior to installation that are known to cause file locks.
[wait_for_pxp_agent_exit]
  This parameter is only applicable for Windows operating systems and pertains to the
  /files/install_agent.ps1 script. This parameterizes the module to define the wait time
  for the PXP agent to end successfully. The default value is set 2 minutes.
[wait_for_puppet_run]
  This parameter is only applicable for Windows operating systems and pertains to the
  /files/install_agent.ps1 script. This parameterizes the module to define the wait time
  for the current puppet agent run to end successfully. The default value is set 2 minutes.
[config]
  An array of configuration data to enforce. Each configuration data item must be a
  Puppet_agent::Config hash, which has keys for puppet.conf section, setting, and value.
  This parameter is constrained to managing only a predetermined set of configuration
  settings, e.g. runinterval.

#### Parameters

The following parameters are available in the `puppet_agent` class:

* [`arch`](#arch)
* [`collection`](#collection)
* [`is_pe`](#is_pe)
* [`manage_pki_dir`](#manage_pki_dir)
* [`manage_repo`](#manage_repo)
* [`package_name`](#package_name)
* [`package_version`](#package_version)
* [`service_names`](#service_names)
* [`source`](#source)
* [`absolute_source`](#absolute_source)
* [`yum_source`](#yum_source)
* [`apt_source`](#apt_source)
* [`mac_source`](#mac_source)
* [`windows_source`](#windows_source)
* [`solaris_source`](#solaris_source)
* [`aix_source`](#aix_source)
* [`use_alternate_sources`](#use_alternate_sources)
* [`alternate_pe_source`](#alternate_pe_source)
* [`install_dir`](#install_dir)
* [`disable_proxy`](#disable_proxy)
* [`proxy`](#proxy)
* [`install_options`](#install_options)
* [`skip_if_unavailable`](#skip_if_unavailable)
* [`msi_move_locked_files`](#msi_move_locked_files)
* [`wait_for_pxp_agent_exit`](#wait_for_pxp_agent_exit)
* [`wait_for_puppet_run`](#wait_for_puppet_run)
* [`config`](#config)

##### <a name="arch"></a>`arch`

Data type: `Any`



Default value: `$::architecture`

##### <a name="collection"></a>`collection`

Data type: `Any`



Default value: `$::puppet_agent::params::collection`

##### <a name="is_pe"></a>`is_pe`

Data type: `Any`



Default value: `$::puppet_agent::params::_is_pe`

##### <a name="manage_pki_dir"></a>`manage_pki_dir`

Data type: `Any`



Default value: ``true``

##### <a name="manage_repo"></a>`manage_repo`

Data type: `Any`



Default value: ``true``

##### <a name="package_name"></a>`package_name`

Data type: `Any`



Default value: `'puppet-agent'`

##### <a name="package_version"></a>`package_version`

Data type: `Any`



Default value: ``undef``

##### <a name="service_names"></a>`service_names`

Data type: `Any`



Default value: `$::puppet_agent::params::service_names`

##### <a name="source"></a>`source`

Data type: `Any`



Default value: ``undef``

##### <a name="absolute_source"></a>`absolute_source`

Data type: `Any`



Default value: ``undef``

##### <a name="yum_source"></a>`yum_source`

Data type: `Any`



Default value: `'http://yum.puppet.com'`

##### <a name="apt_source"></a>`apt_source`

Data type: `Any`



Default value: `'https://apt.puppet.com'`

##### <a name="mac_source"></a>`mac_source`

Data type: `Any`



Default value: `'https://downloads.puppet.com'`

##### <a name="windows_source"></a>`windows_source`

Data type: `Any`



Default value: `'https://downloads.puppet.com'`

##### <a name="solaris_source"></a>`solaris_source`

Data type: `Any`



Default value: `'puppet:///pe_packages'`

##### <a name="aix_source"></a>`aix_source`

Data type: `Any`



Default value: `'puppet:///pe_packages'`

##### <a name="use_alternate_sources"></a>`use_alternate_sources`

Data type: `Any`



Default value: ``false``

##### <a name="alternate_pe_source"></a>`alternate_pe_source`

Data type: `Any`



Default value: ``undef``

##### <a name="install_dir"></a>`install_dir`

Data type: `Any`



Default value: ``undef``

##### <a name="disable_proxy"></a>`disable_proxy`

Data type: `Any`



Default value: ``false``

##### <a name="proxy"></a>`proxy`

Data type: `Any`



Default value: ``undef``

##### <a name="install_options"></a>`install_options`

Data type: `Any`



Default value: `[]`

##### <a name="skip_if_unavailable"></a>`skip_if_unavailable`

Data type: `Any`



Default value: `'absent'`

##### <a name="msi_move_locked_files"></a>`msi_move_locked_files`

Data type: `Any`



Default value: ``false``

##### <a name="wait_for_pxp_agent_exit"></a>`wait_for_pxp_agent_exit`

Data type: `Any`



Default value: ``undef``

##### <a name="wait_for_puppet_run"></a>`wait_for_puppet_run`

Data type: `Any`



Default value: ``undef``

##### <a name="config"></a>`config`

Data type: `Array[Puppet_agent::Config]`



Default value: `[]`

### <a name="puppet_agentconfigure"></a>`puppet_agent::configure`

The puppet_agent::configure class.

### <a name="puppet_agentinstall"></a>`puppet_agent::install`

== Class puppet_agent::install

This class is called from puppet_agent for install.

=== Parameters

[version]
  The puppet-agent version to install.

#### Parameters

The following parameters are available in the `puppet_agent::install` class:

* [`package_version`](#package_version)
* [`install_dir`](#install_dir)
* [`install_options`](#install_options)

##### <a name="package_version"></a>`package_version`

Data type: `Any`



Default value: `'present'`

##### <a name="install_dir"></a>`install_dir`

Data type: `Any`



Default value: ``undef``

##### <a name="install_options"></a>`install_options`

Data type: `Any`



Default value: `[]`

### <a name="puppet_agentinstalldarwin"></a>`puppet_agent::install::darwin`

== Class puppet_agent::install::darwin

Private class called from puppet_agent class

Manage the install process for Darwin OSes specifically

#### Parameters

The following parameters are available in the `puppet_agent::install::darwin` class:

* [`package_version`](#package_version)
* [`install_options`](#install_options)

##### <a name="package_version"></a>`package_version`

Data type: `Any`



##### <a name="install_options"></a>`install_options`

Data type: `Any`



Default value: `[]`

### <a name="puppet_agentinstallsolaris"></a>`puppet_agent::install::solaris`

== Class puppet_agent::install::solaris

Private class called from puppet_agent class

Manage the install process for solaris specifically

#### Parameters

The following parameters are available in the `puppet_agent::install::solaris` class:

* [`package_version`](#package_version)
* [`install_options`](#install_options)

##### <a name="package_version"></a>`package_version`

Data type: `Any`



##### <a name="install_options"></a>`install_options`

Data type: `Any`



Default value: `[]`

### <a name="puppet_agentinstallsuse"></a>`puppet_agent::install::suse`

== Class puppet_agent::install::suse

Private class called from puppet_agent class

Manage the install process for SUSE OSes specifically

#### Parameters

The following parameters are available in the `puppet_agent::install::suse` class:

* [`package_version`](#package_version)
* [`install_options`](#install_options)

##### <a name="package_version"></a>`package_version`

Data type: `Any`



##### <a name="install_options"></a>`install_options`

Data type: `Any`



Default value: `[]`

### <a name="puppet_agentinstallwindows"></a>`puppet_agent::install::windows`

== Class puppet_agent::install::windows

Private class called from puppet_agent class

Manage the install process for windows specifically

#### Parameters

The following parameters are available in the `puppet_agent::install::windows` class:

* [`install_dir`](#install_dir)
* [`install_options`](#install_options)

##### <a name="install_dir"></a>`install_dir`

Data type: `Any`



Default value: ``undef``

##### <a name="install_options"></a>`install_options`

Data type: `Any`



Default value: `[]`

### <a name="puppet_agentosfamilyaix"></a>`puppet_agent::osfamily::aix`

The puppet_agent::osfamily::aix class.

### <a name="puppet_agentosfamilydarwin"></a>`puppet_agent::osfamily::darwin`

The puppet_agent::osfamily::darwin class.

### <a name="puppet_agentosfamilydebian"></a>`puppet_agent::osfamily::debian`

The puppet_agent::osfamily::debian class.

### <a name="puppet_agentosfamilyredhat"></a>`puppet_agent::osfamily::redhat`

The puppet_agent::osfamily::redhat class.

### <a name="puppet_agentosfamilysolaris"></a>`puppet_agent::osfamily::solaris`

The puppet_agent::osfamily::solaris class.

### <a name="puppet_agentosfamilysuse"></a>`puppet_agent::osfamily::suse`

The puppet_agent::osfamily::suse class.

### <a name="puppet_agentosfamilywindows"></a>`puppet_agent::osfamily::windows`

The puppet_agent::osfamily::windows class.

### <a name="puppet_agentparams"></a>`puppet_agent::params`

== Class puppet_agent::params

This class is meant to be called from puppet_agent
It sets variables according to platform.

### <a name="puppet_agentprepare"></a>`puppet_agent::prepare`

== Class puppet_agent::prepare

This class is called from puppet_agent to prepare for the upgrade.

=== Parameters

[version]
  The puppet-agent version to install.

#### Parameters

The following parameters are available in the `puppet_agent::prepare` class:

* [`package_version`](#package_version)

##### <a name="package_version"></a>`package_version`

Data type: `Any`



Default value: ``undef``

### <a name="puppet_agentpreparepackage"></a>`puppet_agent::prepare::package`

== Class puppet_agent::prepare::package

The only job this class has is to ensure that the correct puppet-agent
package is downloaded locally for installation.  This is used on platforms
without package managers capable of working with a remote https repository.

[package_file_name]
  The puppet-agent package file to retrieve from the master.

#### Parameters

The following parameters are available in the `puppet_agent::prepare::package` class:

* [`source`](#source)

##### <a name="source"></a>`source`

Data type: `Any`



### <a name="puppet_agentpreparepuppet_config"></a>`puppet_agent::prepare::puppet_config`

== Class puppet_agent::prepare::puppet_config

Private class called from puppet_agent::prepare class

#### Parameters

The following parameters are available in the `puppet_agent::prepare::puppet_config` class:

* [`package_version`](#package_version)

##### <a name="package_version"></a>`package_version`

Data type: `Any`



### <a name="puppet_agentservice"></a>`puppet_agent::service`

== Class puppet_agent::service

This class is meant to be called from puppet_agent.
It ensures that managed services are running.

## Resource types

### <a name="puppet_agent_end_run"></a>`puppet_agent_end_run`

Stops the current Puppet run if a puppet-agent upgrade was
performed. Used on platforms that manage the Puppet Agent upgrade with
a package resource, as resources evaluated after an upgrade might
cause unexpected behavior due to a mix of old and new Ruby code being
loaded in memory.

Platforms that shell out to external scripts for upgrading (Windows,
macOS, and Solaris 10) do not need to use this type.

#### Properties

The following properties are available in the `puppet_agent_end_run` type.

##### `end_run`

Stops the current puppet run

#### Parameters

The following parameters are available in the `puppet_agent_end_run` type.

* [`name`](#name)
* [`provider`](#provider)

##### <a name="name"></a>`name`

namevar

The desired puppet-agent version

##### <a name="provider"></a>`provider`

The specific backend to use for this `puppet_agent_end_run` resource. You will seldom need to specify this --- Puppet
will usually discover the appropriate provider for your platform.

### <a name="puppet_agent_upgrade_error"></a>`puppet_agent_upgrade_error`

Fails when a previous background installation failed. The type
will check for the existance of an installation failure log
and raise an error with the contents of the log if it exists

#### Properties

The following properties are available in the `puppet_agent_upgrade_error` type.

##### `ensure_notexist`

whether or not the error log exists

#### Parameters

The following parameters are available in the `puppet_agent_upgrade_error` type.

* [`name`](#name)
* [`provider`](#provider)

##### <a name="name"></a>`name`

namevar

The name of the failure log to check for in puppet's $statedir. If this log exists the resource will fail.

##### <a name="provider"></a>`provider`

The specific backend to use for this `puppet_agent_upgrade_error` resource. You will seldom need to specify this ---
Puppet will usually discover the appropriate provider for your platform.

## Functions

### <a name="any_resources_of_type"></a>`any_resources_of_type`

Type: Ruby 4.x API

The any_resources_of_type function.

#### `any_resources_of_type(String $resource_type, Optional[Hash[Any, Any]] $parameters)`

The any_resources_of_type function.

Returns: `Any`

##### `resource_type`

Data type: `String`



##### `parameters`

Data type: `Optional[Hash[Any, Any]]`



### <a name="uri_host_from_string"></a>`uri_host_from_string`

Type: Ruby 3.x API

Return a uri host from a string

#### `uri_host_from_string()`

Return a uri host from a string

Returns: `Any`

### <a name="windows_msi_installargs"></a>`windows_msi_installargs`

Type: Ruby 3.x API

Return the $install_options parameter as a string usable in an msiexec command

#### `windows_msi_installargs()`

Return the $install_options parameter as a string usable in an msiexec command

Returns: `Any`

### <a name="windows_native_path"></a>`windows_native_path`

Type: Ruby 3.x API

Return a windows native path

#### `windows_native_path()`

Return a windows native path

Returns: `Any`

## Data types

### <a name="puppet_agentarch"></a>`Puppet_agent::Arch`

The Puppet_agent::Arch data type.

Alias of

```puppet
Pattern[/^x86$/, /^x64$/, /^i386$/, /^i86pc$/, /^amd64$/, /^x86_64$/, /^power$/, /^sun4[uv]$/, /^ppc64le$/, /^aarch64$/, /PowerPC_POWER/]
```

### <a name="puppet_agentconfig"></a>`Puppet_agent::Config`

The Puppet_agent::Config data type.

Alias of

```puppet
Variant[Struct[{section          => Enum[main, server, agent, user, master],
                                            setting          => Puppet_agent::Config_setting,
                                            value            => String,
                                            Optional[ensure] => Enum[present, absent]}], Struct[{section          => Enum[main, server, agent, user, master],
                                            setting          => Puppet_agent::Config_setting,
                                            Optional[ensure] => Enum[absent]}]]
```

### <a name="puppet_agentconfig_setting"></a>`Puppet_agent::Config_setting`

An enumerated list of settings which are permitted to be managed by this
module.

Alias of

```puppet
Enum[agent_catalog_run_lockfile, agent_disabled_lockfile, allow_duplicate_certs, always_retry_plugins, autoflush, autosign, basemodulepath, binder_config, bucketdir, ca_fingerprint, ca_name, ca_port, ca_server, ca_ttl, cacert, cacrl, cadir, cakey, capub, catalog_cache_terminus, catalog_terminus, cert_inventory, certdir, certificate_revocation, certname, ciphers, classfile, client_datadir, clientbucketdir, clientyamldir, code, codedir, color, confdir, config, config_file_name, config_version, configprint, crl_refresh_interval, csr_attributes, csrdir, daemonize, data_binding_terminus, default_file_terminus, default_manifest, default_schedules, deviceconfdir, deviceconfig, devicedir, diff, diff_args, digest_algorithm, disable_i18n, disable_per_environment_manifest, disable_warnings, dns_alt_names, document_all, environment, environment_data_provider, environment_timeout, environment_timeout_mode, environmentpath, evaltrace, external_nodes, fact_name_length_soft_limit, fact_value_length_soft_limit, facterng, factpath, facts_terminus, fileserverconfig, filetimeout, forge_authorization, freeze_main, func3x_check, future_features, genconfig, genmanifest, graph, graphdir, group, hiera_config, hostcert, hostcrl, hostcsr, hostprivkey, hostpubkey, http_connect_timeout, http_debug, http_extra_headers, http_keepalive_timeout, http_proxy_host, http_proxy_password, http_proxy_port, http_proxy_user, http_read_timeout, http_user_agent, ignore_plugin_errors, ignoremissingtypes, ignoreschedules, key_type, keylength, lastrunfile, lastrunreport, ldapattrs, ldapbase, ldapclassattrs, ldapparentattr, ldappassword, ldapport, ldapserver, ldapssl, ldapstackedattrs, ldapstring, ldaptls, ldapuser, libdir, localcacert, localedest, localesource, log_level, logdest, logdir, manage_internal_file_permissions, manifest, masterport, max_deprecations, max_errors, max_warnings, maximum_uid, maxwaitforcert, maxwaitforlock, merge_dependency_warnings, mkusers, module_groups, module_repository, module_working_dir, modulepath, name, named_curve, no_proxy, node_cache_terminus, node_name, node_name_fact, node_name_value, node_terminus, noop, number_of_facts_soft_limit, onetime, passfile, path, payload_soft_limit, pidfile, plugindest, pluginfactdest, pluginfactsource, pluginsignore, pluginsource, pluginsync, postrun_command, preferred_serialization_format, prerun_command, preview_outputdir, priority, privatedir, privatekeydir, profile, publickeydir, puppet_trace, puppetdlog, report, report_include_system_store, report_port, report_server, reportdir, reports, reporturl, requestdir, resourcefile, rest_authconfig, resubmit_facts, rich_data, route_file, rundir, runinterval, runtimeout, serial, server, server_datadir, server_list, serverport, show_diff, signeddir, skip_tags, sourceaddress, splay, splaylimit, srv_domain, ssl_client_ca_auth, ssl_client_header, ssl_client_verify_header, ssl_lockfile, ssl_server_ca_auth, ssl_trust_store, ssldir, statedir, statefile, statettl, static_catalogs, storeconfigs, storeconfigs_backend, strict, strict_environment_mode, strict_hostname_checking, strict_variables, summarize, supported_checksum_types, syslogfacility, tags, tasks, top_level_facts_soft_limit, trace, transactionstorefile, trusted_external_command, trusted_oid_mapping_file, use_cached_catalog, use_srv_records, usecacheonfailure, user, vardir, vendormoduledir, versioned_environment_dirs, waitforcert, waitforlock, yamldir]
```

## Tasks

### <a name="delete_local_filebucket"></a>`delete_local_filebucket`

Removes the local filebucket

**Supports noop?** false

#### Parameters

##### `force`

Data type: `Optional[Boolean]`

ignore nonexistent files and errors

### <a name="facts_diff"></a>`facts_diff`

Run the Puppet agent facts diff action

**Supports noop?** false

#### Parameters

##### `exclude`

Data type: `Optional[String]`

Regex used to exclude specific facts from diff

### <a name="install"></a>`install`

Install the Puppet agent package

**Supports noop?** true

#### Parameters

##### `version`

Data type: `Optional[String]`

The version of puppet-agent to install (defaults to latest when no agent is installed)

##### `collection`

Data type: `Optional[Enum[puppet6, puppet7, puppet, puppet6-nightly, puppet7-nightly, puppet-nightly]]`

The Puppet collection to install from (defaults to puppet, which maps to the latest collection released)

##### `yum_source`

Data type: `Optional[String]`

The source location to find yum repos (defaults to yum.puppet.com)

##### `apt_source`

Data type: `Optional[String]`

The source location to find apt repos (defaults to apt.puppet.com)

##### `mac_source`

Data type: `Optional[String]`

The source location to find mac packages (defaults to downloads.puppet.com)

##### `windows_source`

Data type: `Optional[String]`

The source location to find windows packages (defaults to downloads.puppet.com)

##### `install_options`

Data type: `Optional[String]`

optional install arguments to the windows installer (defaults to REINSTALLMODE="amus")

##### `stop_service`

Data type: `Optional[Boolean]`

Whether to stop the puppet agent service after install

##### `retry`

Data type: `Optional[Integer]`

The number of retries in case of network connectivity failures

### <a name="install_powershell"></a>`install_powershell`

Install the Puppet agent package

**Supports noop?** true

#### Parameters

##### `version`

Data type: `Optional[String]`

The version of puppet-agent to install

##### `collection`

Data type: `Optional[Enum[puppet6, puppet7, puppet, puppet6-nightly, puppet7-nightly, puppet-nightly]]`

The Puppet collection to install from (defaults to puppet, which maps to the latest collection released)

##### `yum_source`

Data type: `Optional[String]`

The source location to find yum repos (defaults to yum.puppet.com)

##### `apt_source`

Data type: `Optional[String]`

The source location to find apt repos (defaults to apt.puppet.com)

##### `mac_source`

Data type: `Optional[String]`

The source location to find mac packages (defaults to downloads.puppet.com)

##### `windows_source`

Data type: `Optional[String]`

The source location to find windows packages (defaults to downloads.puppet.com)

##### `install_options`

Data type: `Optional[String]`

optional install arguments to the windows installer (defaults to REINSTALLMODE="amus")

##### `stop_service`

Data type: `Optional[Boolean]`

Whether to stop the puppet agent service after install

##### `retry`

Data type: `Optional[Integer]`

The number of retries in case of network connectivity failures

### <a name="install_shell"></a>`install_shell`

Install the Puppet agent package

**Supports noop?** true

#### Parameters

##### `version`

Data type: `Optional[String]`

The version of puppet-agent to install

##### `collection`

Data type: `Optional[Enum[puppet6, puppet7, puppet, puppet6-nightly, puppet7-nightly, puppet-nightly]]`

The Puppet collection to install from (defaults to puppet, which maps to the latest collection released)

##### `yum_source`

Data type: `Optional[String]`

The source location to find yum repos (defaults to yum.puppet.com)

##### `apt_source`

Data type: `Optional[String]`

The source location to find apt repos (defaults to apt.puppet.com)

##### `mac_source`

Data type: `Optional[String]`

The source location to find mac packages (defaults to downloads.puppet.com)

##### `windows_source`

Data type: `Optional[String]`

The source location to find windows packages (defaults to downloads.puppet.com)

##### `install_options`

Data type: `Optional[String]`

optional install arguments to the windows installer (defaults to REINSTALLMODE="amus")

##### `stop_service`

Data type: `Optional[Boolean]`

Whether to stop the puppet agent service after install

##### `retry`

Data type: `Optional[Integer]`

The number of retries in case of network connectivity failures

### <a name="run"></a>`run`

Run the Puppet agent. This task may cause problems if run in Puppet Enterprise.

**Supports noop?** false

### <a name="version"></a>`version`

Get the version of the Puppet agent package installed. Returns nothing if none present.

**Supports noop?** false

### <a name="version_powershell"></a>`version_powershell`

Get the version of the Puppet agent package installed. Returns nothing if none present.

**Supports noop?** false

### <a name="version_shell"></a>`version_shell`

Get the version of the Puppet agent package installed. Returns nothing if none present.

**Supports noop?** false

## Plans

### <a name="puppet_agentrun"></a>`puppet_agent::run`

Starts a Puppet agent run on the specified targets.
Note: This plan may cause issues when run in Puppet Enterprise.

#### Parameters

The following parameters are available in the `puppet_agent::run` plan:

* [`targets`](#targets)

##### <a name="targets"></a>`targets`

Data type: `TargetSpec`

The targets to start a Puppet agent run on.

