# Recover configuration on the primary and then synchronize the primary's enterprise data
# to all other primary infrastructure nodes.
#
# Synchronizing is only relevent if +infrastructure+ contains more than +puppetserver+.
#
# @param $primary [TargetSpec] the primary node.
# @param $infrastructure [TargetSpec] all infrastructure nodes (primary will be
#   filtered from it).
plan enterprise_tasks::sync_enterprise_data(
  TargetSpec $primary,
  TargetSpec $infrastructure,
) {
  $primary_target = get_targets($primary)[0]
  $remaining_infrastructure_targets = get_targets($infrastructure) - $primary_target

  enterprise_tasks::message('sync_enterprise_data', 'Running puppet infra recover_configuration on primary node.')
  run_task(enterprise_tasks::puppet_infra_recover_configuration, $primary)

  if !empty($remaining_infrastructure_targets) {
    enterprise_tasks::message('sync_enterprise_data', 'Retrieving enterprise data from primary node.')
    $results = run_task('enterprise_tasks::get_enterprise_data', $primary)
    $enterprise_data = $results.first()['enterprise_data']
    $user_data_conf = $enterprise_data
    $etc_puppetlabs_dir = '/etc/puppetlabs'

    enterprise_tasks::message('sync_enterprise_data', 'Pushing enterprise data onto remaining infrastructure nodes.')
    get_targets($remaining_infrastructure_targets).each |$node| {
      apply($node) {
        $common = {
          owner => 'root',
          group => 'root',
          mode  => '0600',
        }

        file { $etc_puppetlabs_dir:
          ensure => 'directory',
          *      => $common + {
            mode   => '0755',
          }
        }

        file { [
          "${etc_puppetlabs_dir}/enterprise",
          "${etc_puppetlabs_dir}/enterprise/conf.d",
          "${etc_puppetlabs_dir}/enterprise/conf.d/nodes",
        ]:
          ensure => 'directory',
          *      => $common,
        }

        $user_data_conf.each |$name,$contents| {
          file { $name:
            ensure  => 'present',
            content => Sensitive($contents),
            *       => $common,
          }
        }
      }
    }
  }
}
