# Install compilers
#
# Assumes PE is installed.
#
# Will first install the agent.
#
# @param $compilers [TargetSpec] the nodes to install compilers on.
# @param $primary [Variant[Target,String]] the primary node.
# @param $subject_alt_names [Optional[String]] SANs for the compiler certificates.
plan enterprise_tasks::testing::install_compilers(
  TargetSpec $compilers,
  Variant[Target,String] $primary,
  Optional[String] $subject_alt_names = undef,
) {

  $compiler_targets = get_targets($compilers)
  $primary_target = get_targets($primary)[0]

  enterprise_tasks::message('install_compilers', 'Checking connectivity to infrastructure nodes.')
  enterprise_tasks::test_connection($primary_target)
  enterprise_tasks::test_connection($compiler_targets)

  run_plan('enterprise_tasks::testing::install_agents',
    'agents'            => $compiler_targets,
    'primary'           => $primary_target,
    'subject_alt_names' => $subject_alt_names,
  )

  $compiler_targets.each |$compiler| {
    enterprise_tasks::message('install_compilers', "Pin compiler ${compiler.name()} to PE Master group")
    run_command("${constants()['puppet_bin']} resource pe_node_group 'PE Master' pinned='${compiler.name()}'", $primary)
  }

  enterprise_tasks::message('install_compilers', 'Run puppet on the compilers')
  run_task(enterprise_tasks::run_puppet, $compiler_targets)

  enterprise_tasks::message('install_compilers', 'Run puppet on the primary to allow compiler connections ')
  run_task(enterprise_tasks::run_puppet, $primary)
}
