#!/opt/puppetlabs/puppet/bin/ruby
# frozen_string_literal: true

require_relative '../lib/enterprise_tasks/network'
require_relative '../lib/enterprise_tasks/rbac'
require_relative '../files/enterprise_task_helper.rb' if __FILE__ == $PROGRAM_NAME
require 'open3'

class BootstrapConsoleAdminPassword < EnterpriseTaskHelper
  include EnterpriseTasks::Network
  include EnterpriseTasks::RBAC

  def task(password:, **_kwargs)
    admin = find_user(login: 'admin', is_superuser: true)
    if admin.nil? || !admin['is_revoked']
      raise EnterpriseTaskHelper::Error.new(
        'The admin account must exist and be in a revoked state.',
        'puppetlabs.bootstrap-console-admin-password/admin-not-revoked',
        {
          admin_account: admin,
        },
      )
    end

    command = [
      '/opt/puppetlabs/bin/puppet-infra',
      'console_password',
      '--password',
      password,
    ]
    output, status = Open3.capture2e(*command)
    if !status.success?
      raise EnterpriseTaskHelper::Error.new(
        'Problem calling puppet-infra console_password',
        'puppetlabs.bootstrap-console-admin-password/puppet-infra-failed',
        {
          command: command,
          output: output,
          status: status.exitstatus,
        },
      )
    end

    {
      success: true,
    }.to_json
  end
end

BootstrapConsoleAdminPassword.run if __FILE__ == $PROGRAM_NAME
