# Outputs the pertinent log information from an apply report.
# Then fail the plan if the apply failed.
function enterprise_tasks::apply_report(
  String $label,
  Variant[Result,ApplyResult,ResultSet] $result,
  Boolean $fail = true
) {
  # Bolt gives us a Result if compilation fails, as apposed to an
  # ApplyResult after the catalog is applied and there's an expectation of
  # a Puppet report being returned.
  #
  # Newer Bolt may give a ResultSet instead of a single Result if compilation
  # fails. Since we're only doing this on one node, just pop the first and only
  # value out of it.
  case $result {
    ApplyResult: {
      $report = $result.report()
      if $report =~ NotUndef and $report['logs'] =~ NotUndef {
        $logs = $report['logs']
      } else {
        $logs = []
        warning("The apply on '${result.target()}' did not return a report with logs")
      }
      $_result = $result
    }
    ResultSet: {
      $_result = $result.first
      $logs = []
    }
    default: {
      $_result = $result
      $logs = []
    }
  }

  if !$_result.ok() {
    $logs.each |$l| {
      if $l['message'] !~ /Skipping because of failed dependencies/ {
        $timestamp = $l['time'].split('.')[0]
        enterprise_tasks::message($label, "${timestamp} ${l['level']}: ${l['source']} - ${l['message']}")
      }
    }

    if $fail {
      fail_plan($_result.error())
    } else {
      enterprise_tasks::message($label, "${_result.error()}")
    }
  }
}
