Puppet::Functions.create_function('enterprise_tasks::with_agent_disabled') do
  dispatch :with_disable do
    param 'Variant[String,Array[String],Target,Array[TargetSpec]]', :nodes
    block_param 'Callable', :_block
  end

  def with_disable(nodes, &_block)
    disabled_key = 'agent_disabled_by_with_agent_disable_function'
    targets = call_function('get_targets', nodes)
    targets_to_disable = targets.select { |t| !t.vars[disabled_key] }
    call_function('run_task', 'enterprise_tasks::disable_agent', targets_to_disable)
    targets_to_disable.each { |t| call_function('set_var', t, disabled_key, true) }
    yield
  ensure
    call_function('run_task', 'enterprise_tasks::enable_agent', targets_to_disable)
    targets_to_disable.each { |t| call_function('set_var', t, disabled_key, false) }
  end
end
