# This plan checks if allow-subject-alt-names is set to true in the CA
# server configuration file.
plan enterprise_tasks::is_subject_alt_names_allowed(
  Optional[TargetSpec] $primary          = 'localhost',
  Optional[Boolean] $fail_if_not_allowed = true,
  Optional[Boolean] $force               = false,
) {
  enterprise_tasks::verify_node($primary, 'primary', $force)

  $puppetserver_conf_dir = '/etc/puppetlabs/puppetserver/conf.d'
  $conf_check = run_task(enterprise_tasks::get_conf_values, $primary,
    path => $puppetserver_conf_dir,
    keys => 'certificate-authority',
  )
  $dns_setting = $conf_check.first.value['certificate-authority']
  $allowed = $dns_setting and $dns_setting['allow-subject-alt-names']

  if !$allowed and $fail_if_not_allowed {
    enterprise_tasks::message('is_subject_alt_names_allowed', "ERROR: allow-subject-alt-names parameter is not set in ${puppetserver_conf_dir}/ca.conf.")
    enterprise_tasks::message('is_subject_alt_names_allowed', 'After setting allow-subject-alt-names to true, restart pe-puppetserver and run this plan again')
    fail_plan('ERROR: allow-subject-alt-names parameter is not set')
  } else {
    return $allowed
  }
}
