#!/opt/puppetlabs/puppet/bin/ruby
# frozen_string_literal: true

require_relative '../files/enterprise_task_helper.rb'
require_relative '../lib/enterprise_tasks/puppet_helper.rb'
require 'open3'
require 'fileutils'

class PuppetSSLClean < EnterpriseTaskHelper
  include EnterpriseTasks::PuppetHelper

  def task(certname:, localca: false, **_kwargs)
    localca_opt = localca ? '--localca' : ''
    cmd = [puppet_bin, 'ssl', 'clean', localca_opt, certname]
    output, status = Open3.capture2e(*cmd)
    raise EnterpriseTaskHelper::Error.new("Unable to clean SSL information for #{certname}", 'puppetlabs.puppet-ssl-clean/puppet-ssl-clean-failed', 'output' => output) if !status.exitstatus.zero?

    catalog = "#{catalog_path}/#{certname}.json"
    FileUtils.rm_f(catalog)
    if File.exist?(catalog)
      raise EnterpriseTaskHelper::Error.new("Unable to remove cached catalog on host with certname #{certname}", 'puppetlabs.puppet-ssl-clean/remove-cached-catalog-failed', 'output' => output) if !status.exitstatus.zero?
    end

    result = { _output: output }
    result.to_json
  end
end

PuppetSSLClean.run if __FILE__ == $PROGRAM_NAME
