#!/opt/puppetlabs/puppet/bin/ruby
# frozen_string_literal: true

require_relative '../files/enterprise_task_helper.rb'
require 'json'
require 'puppet'
require 'open3'

class PuppetserverCAClean < EnterpriseTaskHelper
  def task(host: nil, **_kwargs)
    certname_cmd = ['/opt/puppetlabs/bin/puppet', 'config', 'print', 'certname']
    certname, = Open3.capture2e(*certname_cmd)[0].strip
    host = certname if host == 'localhost'
    ca_dir = '/etc/puppetlabs/puppet/ssl/ca'

    test_cert_cmd = ['test', '-e', "#{ca_dir}/signed/#{host}.pem"]
    _output, cert_status = Open3.capture2e(*test_cert_cmd)
    test_csr_cmd = ['test', '-e', "#{ca_dir}/requests/#{host}.pem"]
    output, csr_status = Open3.capture2e(*test_csr_cmd)
    cmd = ['/opt/puppetlabs/bin/puppetserver', 'ca', 'clean', "--certname=#{host}"]
    output, status = Open3.capture2e(*cmd) if cert_status.exitstatus.zero? || csr_status.exitstatus.zero?
    # 'puppetserver ca clean' returns 0 if a signed cert was cleaned up or returns 24 if a CSR was cleaned up
    if status && !status.exitstatus.zero? && status.exitstatus != 24
      raise EnterpriseTaskHelper::Error.new("Unable to clean host certificate for #{host} from CA #{certname}", 'puppetlabs.puppetserver-ca-clean/puppetserver-ca-clean-failed', 'output' => output)
    end

    result = { _output: output }
    result.to_json
  end
end

PuppetserverCAClean.run if __FILE__ == $PROGRAM_NAME
