# Reference

<!-- DO NOT EDIT: This document was generated by Puppet Strings -->

## Table of Contents

### Classes

* [`puppet_metrics_collector`](#puppet_metrics_collector): Collect Metrics
* [`puppet_metrics_collector::service::ace`](#puppet_metrics_collectorserviceace): Collect Service Metrics
* [`puppet_metrics_collector::service::bolt`](#puppet_metrics_collectorservicebolt): Collect Service Metrics
* [`puppet_metrics_collector::service::orchestrator`](#puppet_metrics_collectorserviceorchestrator): Collect Service Metrics
* [`puppet_metrics_collector::service::puppetdb`](#puppet_metrics_collectorservicepuppetdb): Collect Service Metrics
* [`puppet_metrics_collector::service::puppetserver`](#puppet_metrics_collectorservicepuppetserver): Collect Service Metrics
* [`puppet_metrics_collector::system`](#puppet_metrics_collectorsystem): Collect System Metrics
* [`puppet_metrics_collector::system::cpu`](#puppet_metrics_collectorsystemcpu): Collect System CPU Metrics
* [`puppet_metrics_collector::system::memory`](#puppet_metrics_collectorsystemmemory): Collect System Memory Metrics
* [`puppet_metrics_collector::system::postgres`](#puppet_metrics_collectorsystempostgres): Collect PostgreSQL metrics  This class manages a cron job that uses `/opt/puppetlabs/server/bin/psql` to collect metrics from a locally-runni
* [`puppet_metrics_collector::system::processes`](#puppet_metrics_collectorsystemprocesses): Collect System Processes Metrics
* [`puppet_metrics_collector::system::vmware`](#puppet_metrics_collectorsystemvmware): Collect VMware metrics  This class manages a cron job that collects metrics from:      vmware-toolbox-cmd stat  This class should not be incl

### Defined types

* [`puppet_metrics_collector::collect`](#puppet_metrics_collectorcollect): Create systemd units for collecting a given metric
* [`puppet_metrics_collector::pe_metric`](#puppet_metrics_collectorpe_metric): Collect Puma or TrapperKeeper Metrics
* [`puppet_metrics_collector::sar_metric`](#puppet_metrics_collectorsar_metric): Collect System Metrics

### Functions

* [`puppet_metrics_collector::generate_metrics_server_command`](#puppet_metrics_collectorgenerate_metrics_server_command): Generate the metrics shipping command for the cron job including remote metrics
* [`puppet_metrics_collector::hosts_with_pe_profile`](#puppet_metrics_collectorhosts_with_pe_profile)
* [`puppet_metrics_collector::to_yaml`](#puppet_metrics_collectorto_yaml)
* [`puppet_metrics_collector::version_based_excludes`](#puppet_metrics_collectorversion_based_excludes)

## Classes

### <a name="puppet_metrics_collector"></a>`puppet_metrics_collector`

Collect Metrics

#### Parameters

The following parameters are available in the `puppet_metrics_collector` class:

* [`puppetserver_metrics_ensure`](#puppetserver_metrics_ensure)
* [`output_dir`](#output_dir)
* [`collection_frequency`](#collection_frequency)
* [`retention_days`](#retention_days)
* [`puppetserver_hosts`](#puppetserver_hosts)
* [`puppetserver_port`](#puppetserver_port)
* [`puppetdb_metrics_ensure`](#puppetdb_metrics_ensure)
* [`puppetdb_hosts`](#puppetdb_hosts)
* [`puppetdb_port`](#puppetdb_port)
* [`orchestrator_metrics_ensure`](#orchestrator_metrics_ensure)
* [`orchestrator_hosts`](#orchestrator_hosts)
* [`orchestrator_port`](#orchestrator_port)
* [`ace_metrics_ensure`](#ace_metrics_ensure)
* [`ace_hosts`](#ace_hosts)
* [`ace_port`](#ace_port)
* [`bolt_metrics_ensure`](#bolt_metrics_ensure)
* [`bolt_hosts`](#bolt_hosts)
* [`bolt_port`](#bolt_port)
* [`activemq_metrics_ensure`](#activemq_metrics_ensure)
* [`activemq_hosts`](#activemq_hosts)
* [`activemq_port`](#activemq_port)
* [`override_metrics_command`](#override_metrics_command)
* [`puppetserver_excludes`](#puppetserver_excludes)
* [`puppetdb_excludes`](#puppetdb_excludes)
* [`orchestrator_excludes`](#orchestrator_excludes)
* [`ace_excludes`](#ace_excludes)
* [`bolt_excludes`](#bolt_excludes)
* [`activemq_excludes`](#activemq_excludes)
* [`metrics_server_type`](#metrics_server_type)
* [`metrics_server_hostname`](#metrics_server_hostname)
* [`metrics_server_port`](#metrics_server_port)
* [`metrics_server_db_name`](#metrics_server_db_name)

##### <a name="puppetserver_metrics_ensure"></a>`puppetserver_metrics_ensure`

Data type: `String`



Default value: `'present'`

##### <a name="output_dir"></a>`output_dir`

Data type: `String`



Default value: `'/opt/puppetlabs/puppet-metrics-collector'`

##### <a name="collection_frequency"></a>`collection_frequency`

Data type: `Integer`



Default value: `5`

##### <a name="retention_days"></a>`retention_days`

Data type: `Integer`



Default value: `90`

##### <a name="puppetserver_hosts"></a>`puppetserver_hosts`

Data type: `Array[String]`



Default value: `puppet_metrics_collector::hosts_with_pe_profile('master')`

##### <a name="puppetserver_port"></a>`puppetserver_port`

Data type: `Integer`



Default value: `8140`

##### <a name="puppetdb_metrics_ensure"></a>`puppetdb_metrics_ensure`

Data type: `String`



Default value: `'present'`

##### <a name="puppetdb_hosts"></a>`puppetdb_hosts`

Data type: `Array[String]`



Default value: `puppet_metrics_collector::hosts_with_pe_profile('puppetdb')`

##### <a name="puppetdb_port"></a>`puppetdb_port`

Data type: `Integer`



Default value: `8081`

##### <a name="orchestrator_metrics_ensure"></a>`orchestrator_metrics_ensure`

Data type: `String`



Default value: `'present'`

##### <a name="orchestrator_hosts"></a>`orchestrator_hosts`

Data type: `Array[String]`



Default value: `puppet_metrics_collector::hosts_with_pe_profile('orchestrator')`

##### <a name="orchestrator_port"></a>`orchestrator_port`

Data type: `Integer`



Default value: `8143`

##### <a name="ace_metrics_ensure"></a>`ace_metrics_ensure`

Data type: `String`



Default value: `'present'`

##### <a name="ace_hosts"></a>`ace_hosts`

Data type: `Array[String]`



Default value: `puppet_metrics_collector::hosts_with_pe_profile('ace_server')`

##### <a name="ace_port"></a>`ace_port`

Data type: `Integer`



Default value: `44633`

##### <a name="bolt_metrics_ensure"></a>`bolt_metrics_ensure`

Data type: `String`



Default value: `'present'`

##### <a name="bolt_hosts"></a>`bolt_hosts`

Data type: `Array[String]`



Default value: `puppet_metrics_collector::hosts_with_pe_profile('bolt_server')`

##### <a name="bolt_port"></a>`bolt_port`

Data type: `Integer`



Default value: `62658`

##### <a name="activemq_metrics_ensure"></a>`activemq_metrics_ensure`

Data type: `String`



Default value: `'absent'`

##### <a name="activemq_hosts"></a>`activemq_hosts`

Data type: `Array[String]`



Default value: `[]`

##### <a name="activemq_port"></a>`activemq_port`

Data type: `Integer`



Default value: `8161`

##### <a name="override_metrics_command"></a>`override_metrics_command`

Data type: `Optional[String]`



Default value: ``undef``

##### <a name="puppetserver_excludes"></a>`puppetserver_excludes`

Data type: `Optional[Array[String]]`



Default value: ``undef``

##### <a name="puppetdb_excludes"></a>`puppetdb_excludes`

Data type: `Optional[Array[String]]`



Default value: ``undef``

##### <a name="orchestrator_excludes"></a>`orchestrator_excludes`

Data type: `Optional[Array[String]]`



Default value: ``undef``

##### <a name="ace_excludes"></a>`ace_excludes`

Data type: `Optional[Array[String]]`



Default value: ``undef``

##### <a name="bolt_excludes"></a>`bolt_excludes`

Data type: `Optional[Array[String]]`



Default value: ``undef``

##### <a name="activemq_excludes"></a>`activemq_excludes`

Data type: `Optional[Array[String]]`



Default value: ``undef``

##### <a name="metrics_server_type"></a>`metrics_server_type`

Data type: `Optional[Enum['influxdb', 'graphite', 'splunk_hec']]`



Default value: ``undef``

##### <a name="metrics_server_hostname"></a>`metrics_server_hostname`

Data type: `Optional[String]`



Default value: ``undef``

##### <a name="metrics_server_port"></a>`metrics_server_port`

Data type: `Optional[Integer]`



Default value: ``undef``

##### <a name="metrics_server_db_name"></a>`metrics_server_db_name`

Data type: `Optional[String]`



Default value: ``undef``

### <a name="puppet_metrics_collectorserviceace"></a>`puppet_metrics_collector::service::ace`

Collect Service Metrics

#### Parameters

The following parameters are available in the `puppet_metrics_collector::service::ace` class:

* [`metrics_ensure`](#metrics_ensure)
* [`collection_frequency`](#collection_frequency)
* [`retention_days`](#retention_days)
* [`hosts`](#hosts)
* [`port`](#port)
* [`extra_metrics`](#extra_metrics)
* [`override_metrics_command`](#override_metrics_command)
* [`excludes`](#excludes)
* [`metrics_server_type`](#metrics_server_type)
* [`metrics_server_hostname`](#metrics_server_hostname)
* [`metrics_server_port`](#metrics_server_port)
* [`metrics_server_db_name`](#metrics_server_db_name)

##### <a name="metrics_ensure"></a>`metrics_ensure`

Data type: `String`



Default value: `$puppet_metrics_collector::ace_metrics_ensure`

##### <a name="collection_frequency"></a>`collection_frequency`

Data type: `Integer`



Default value: `$puppet_metrics_collector::collection_frequency`

##### <a name="retention_days"></a>`retention_days`

Data type: `Integer`



Default value: `$puppet_metrics_collector::retention_days`

##### <a name="hosts"></a>`hosts`

Data type: `Array[String]`



Default value: `$puppet_metrics_collector::ace_hosts`

##### <a name="port"></a>`port`

Data type: `Integer`



Default value: `$puppet_metrics_collector::ace_port`

##### <a name="extra_metrics"></a>`extra_metrics`

Data type: `Array[Hash]`



Default value: `[]`

##### <a name="override_metrics_command"></a>`override_metrics_command`

Data type: `Optional[String]`



Default value: `$puppet_metrics_collector::override_metrics_command`

##### <a name="excludes"></a>`excludes`

Data type: `Optional[Array[String]]`



Default value: `$puppet_metrics_collector::ace_excludes`

##### <a name="metrics_server_type"></a>`metrics_server_type`

Data type: `Optional[Enum['influxdb', 'graphite', 'splunk_hec']]`



Default value: `$puppet_metrics_collector::metrics_server_type`

##### <a name="metrics_server_hostname"></a>`metrics_server_hostname`

Data type: `Optional[String]`



Default value: `$puppet_metrics_collector::metrics_server_hostname`

##### <a name="metrics_server_port"></a>`metrics_server_port`

Data type: `Optional[Integer]`



Default value: `$puppet_metrics_collector::metrics_server_port`

##### <a name="metrics_server_db_name"></a>`metrics_server_db_name`

Data type: `Optional[String]`



Default value: `$puppet_metrics_collector::metrics_server_db_name`

### <a name="puppet_metrics_collectorservicebolt"></a>`puppet_metrics_collector::service::bolt`

Collect Service Metrics

#### Parameters

The following parameters are available in the `puppet_metrics_collector::service::bolt` class:

* [`metrics_ensure`](#metrics_ensure)
* [`collection_frequency`](#collection_frequency)
* [`retention_days`](#retention_days)
* [`hosts`](#hosts)
* [`port`](#port)
* [`extra_metrics`](#extra_metrics)
* [`override_metrics_command`](#override_metrics_command)
* [`excludes`](#excludes)
* [`metrics_server_type`](#metrics_server_type)
* [`metrics_server_hostname`](#metrics_server_hostname)
* [`metrics_server_port`](#metrics_server_port)
* [`metrics_server_db_name`](#metrics_server_db_name)

##### <a name="metrics_ensure"></a>`metrics_ensure`

Data type: `String`



Default value: `$puppet_metrics_collector::bolt_metrics_ensure`

##### <a name="collection_frequency"></a>`collection_frequency`

Data type: `Integer`



Default value: `$puppet_metrics_collector::collection_frequency`

##### <a name="retention_days"></a>`retention_days`

Data type: `Integer`



Default value: `$puppet_metrics_collector::retention_days`

##### <a name="hosts"></a>`hosts`

Data type: `Array[String]`



Default value: `$puppet_metrics_collector::bolt_hosts`

##### <a name="port"></a>`port`

Data type: `Integer`



Default value: `$puppet_metrics_collector::bolt_port`

##### <a name="extra_metrics"></a>`extra_metrics`

Data type: `Array[Hash]`



Default value: `[]`

##### <a name="override_metrics_command"></a>`override_metrics_command`

Data type: `Optional[String]`



Default value: `$puppet_metrics_collector::override_metrics_command`

##### <a name="excludes"></a>`excludes`

Data type: `Optional[Array[String]]`



Default value: `$puppet_metrics_collector::bolt_excludes`

##### <a name="metrics_server_type"></a>`metrics_server_type`

Data type: `Optional[Enum['influxdb', 'graphite', 'splunk_hec']]`



Default value: `$puppet_metrics_collector::metrics_server_type`

##### <a name="metrics_server_hostname"></a>`metrics_server_hostname`

Data type: `Optional[String]`



Default value: `$puppet_metrics_collector::metrics_server_hostname`

##### <a name="metrics_server_port"></a>`metrics_server_port`

Data type: `Optional[Integer]`



Default value: `$puppet_metrics_collector::metrics_server_port`

##### <a name="metrics_server_db_name"></a>`metrics_server_db_name`

Data type: `Optional[String]`



Default value: `$puppet_metrics_collector::metrics_server_db_name`

### <a name="puppet_metrics_collectorserviceorchestrator"></a>`puppet_metrics_collector::service::orchestrator`

Collect Service Metrics

#### Parameters

The following parameters are available in the `puppet_metrics_collector::service::orchestrator` class:

* [`metrics_ensure`](#metrics_ensure)
* [`collection_frequency`](#collection_frequency)
* [`retention_days`](#retention_days)
* [`hosts`](#hosts)
* [`port`](#port)
* [`extra_metrics`](#extra_metrics)
* [`override_metrics_command`](#override_metrics_command)
* [`excludes`](#excludes)
* [`metrics_server_type`](#metrics_server_type)
* [`metrics_server_hostname`](#metrics_server_hostname)
* [`metrics_server_port`](#metrics_server_port)
* [`metrics_server_db_name`](#metrics_server_db_name)

##### <a name="metrics_ensure"></a>`metrics_ensure`

Data type: `String`



Default value: `$puppet_metrics_collector::orchestrator_metrics_ensure`

##### <a name="collection_frequency"></a>`collection_frequency`

Data type: `Integer`



Default value: `$puppet_metrics_collector::collection_frequency`

##### <a name="retention_days"></a>`retention_days`

Data type: `Integer`



Default value: `$puppet_metrics_collector::retention_days`

##### <a name="hosts"></a>`hosts`

Data type: `Array[String]`



Default value: `$puppet_metrics_collector::orchestrator_hosts`

##### <a name="port"></a>`port`

Data type: `Integer`



Default value: `$puppet_metrics_collector::orchestrator_port`

##### <a name="extra_metrics"></a>`extra_metrics`

Data type: `Array[Hash]`



Default value: `[]`

##### <a name="override_metrics_command"></a>`override_metrics_command`

Data type: `Optional[String]`



Default value: `$puppet_metrics_collector::override_metrics_command`

##### <a name="excludes"></a>`excludes`

Data type: `Optional[Array[String]]`



Default value: `$puppet_metrics_collector::orchestrator_excludes`

##### <a name="metrics_server_type"></a>`metrics_server_type`

Data type: `Optional[Enum['influxdb', 'graphite', 'splunk_hec']]`



Default value: `$puppet_metrics_collector::metrics_server_type`

##### <a name="metrics_server_hostname"></a>`metrics_server_hostname`

Data type: `Optional[String]`



Default value: `$puppet_metrics_collector::metrics_server_hostname`

##### <a name="metrics_server_port"></a>`metrics_server_port`

Data type: `Optional[Integer]`



Default value: `$puppet_metrics_collector::metrics_server_port`

##### <a name="metrics_server_db_name"></a>`metrics_server_db_name`

Data type: `Optional[String]`



Default value: `$puppet_metrics_collector::metrics_server_db_name`

### <a name="puppet_metrics_collectorservicepuppetdb"></a>`puppet_metrics_collector::service::puppetdb`

Collect Service Metrics

#### Parameters

The following parameters are available in the `puppet_metrics_collector::service::puppetdb` class:

* [`metrics_ensure`](#metrics_ensure)
* [`collection_frequency`](#collection_frequency)
* [`retention_days`](#retention_days)
* [`hosts`](#hosts)
* [`port`](#port)
* [`extra_metrics`](#extra_metrics)
* [`override_metrics_command`](#override_metrics_command)
* [`excludes`](#excludes)
* [`metrics_server_type`](#metrics_server_type)
* [`metrics_server_hostname`](#metrics_server_hostname)
* [`metrics_server_port`](#metrics_server_port)
* [`metrics_server_db_name`](#metrics_server_db_name)

##### <a name="metrics_ensure"></a>`metrics_ensure`

Data type: `String`



Default value: `$puppet_metrics_collector::puppetdb_metrics_ensure`

##### <a name="collection_frequency"></a>`collection_frequency`

Data type: `Integer`



Default value: `$puppet_metrics_collector::collection_frequency`

##### <a name="retention_days"></a>`retention_days`

Data type: `Integer`



Default value: `$puppet_metrics_collector::retention_days`

##### <a name="hosts"></a>`hosts`

Data type: `Array[String]`



Default value: `$puppet_metrics_collector::puppetdb_hosts`

##### <a name="port"></a>`port`

Data type: `Integer`



Default value: `$puppet_metrics_collector::puppetdb_port`

##### <a name="extra_metrics"></a>`extra_metrics`

Data type: `Array[Hash]`



Default value: `[]`

##### <a name="override_metrics_command"></a>`override_metrics_command`

Data type: `Optional[String]`



Default value: `$puppet_metrics_collector::override_metrics_command`

##### <a name="excludes"></a>`excludes`

Data type: `Optional[Array[String]]`



Default value: `$puppet_metrics_collector::puppetdb_excludes`

##### <a name="metrics_server_type"></a>`metrics_server_type`

Data type: `Optional[Enum['influxdb', 'graphite', 'splunk_hec']]`



Default value: `$puppet_metrics_collector::metrics_server_type`

##### <a name="metrics_server_hostname"></a>`metrics_server_hostname`

Data type: `Optional[String]`



Default value: `$puppet_metrics_collector::metrics_server_hostname`

##### <a name="metrics_server_port"></a>`metrics_server_port`

Data type: `Optional[Integer]`



Default value: `$puppet_metrics_collector::metrics_server_port`

##### <a name="metrics_server_db_name"></a>`metrics_server_db_name`

Data type: `Optional[String]`



Default value: `$puppet_metrics_collector::metrics_server_db_name`

### <a name="puppet_metrics_collectorservicepuppetserver"></a>`puppet_metrics_collector::service::puppetserver`

Collect Service Metrics

#### Parameters

The following parameters are available in the `puppet_metrics_collector::service::puppetserver` class:

* [`metrics_ensure`](#metrics_ensure)
* [`collection_frequency`](#collection_frequency)
* [`retention_days`](#retention_days)
* [`hosts`](#hosts)
* [`port`](#port)
* [`extra_metrics`](#extra_metrics)
* [`override_metrics_command`](#override_metrics_command)
* [`excludes`](#excludes)
* [`metrics_server_type`](#metrics_server_type)
* [`metrics_server_hostname`](#metrics_server_hostname)
* [`metrics_server_port`](#metrics_server_port)
* [`metrics_server_db_name`](#metrics_server_db_name)

##### <a name="metrics_ensure"></a>`metrics_ensure`

Data type: `String`



Default value: `$puppet_metrics_collector::puppetserver_metrics_ensure`

##### <a name="collection_frequency"></a>`collection_frequency`

Data type: `Integer`



Default value: `$puppet_metrics_collector::collection_frequency`

##### <a name="retention_days"></a>`retention_days`

Data type: `Integer`



Default value: `$puppet_metrics_collector::retention_days`

##### <a name="hosts"></a>`hosts`

Data type: `Array[String]`



Default value: `$puppet_metrics_collector::puppetserver_hosts`

##### <a name="port"></a>`port`

Data type: `Integer`



Default value: `$puppet_metrics_collector::puppetserver_port`

##### <a name="extra_metrics"></a>`extra_metrics`

Data type: `Array[Hash]`



Default value: `[]`

##### <a name="override_metrics_command"></a>`override_metrics_command`

Data type: `Optional[String]`



Default value: `$puppet_metrics_collector::override_metrics_command`

##### <a name="excludes"></a>`excludes`

Data type: `Optional[Array[String]]`



Default value: `$puppet_metrics_collector::puppetserver_excludes`

##### <a name="metrics_server_type"></a>`metrics_server_type`

Data type: `Optional[Enum['influxdb', 'graphite', 'splunk_hec']]`



Default value: `$puppet_metrics_collector::metrics_server_type`

##### <a name="metrics_server_hostname"></a>`metrics_server_hostname`

Data type: `Optional[String]`



Default value: `$puppet_metrics_collector::metrics_server_hostname`

##### <a name="metrics_server_port"></a>`metrics_server_port`

Data type: `Optional[Integer]`



Default value: `$puppet_metrics_collector::metrics_server_port`

##### <a name="metrics_server_db_name"></a>`metrics_server_db_name`

Data type: `Optional[String]`



Default value: `$puppet_metrics_collector::metrics_server_db_name`

### <a name="puppet_metrics_collectorsystem"></a>`puppet_metrics_collector::system`

Collect System Metrics

#### Parameters

The following parameters are available in the `puppet_metrics_collector::system` class:

* [`system_metrics_ensure`](#system_metrics_ensure)
* [`output_dir`](#output_dir)
* [`collection_frequency`](#collection_frequency)
* [`retention_days`](#retention_days)
* [`polling_frequency_seconds`](#polling_frequency_seconds)
* [`manage_sysstat`](#manage_sysstat)
* [`manage_vmware_tools`](#manage_vmware_tools)
* [`vmware_tools_pkg`](#vmware_tools_pkg)
* [`metrics_server_type`](#metrics_server_type)
* [`metrics_server_hostname`](#metrics_server_hostname)
* [`metrics_server_port`](#metrics_server_port)
* [`metrics_server_db_name`](#metrics_server_db_name)

##### <a name="system_metrics_ensure"></a>`system_metrics_ensure`

Data type: `String`



Default value: `'present'`

##### <a name="output_dir"></a>`output_dir`

Data type: `String`



Default value: `'/opt/puppetlabs/puppet-metrics-collector'`

##### <a name="collection_frequency"></a>`collection_frequency`

Data type: `Integer`



Default value: `5`

##### <a name="retention_days"></a>`retention_days`

Data type: `Integer`



Default value: `90`

##### <a name="polling_frequency_seconds"></a>`polling_frequency_seconds`

Data type: `Integer`



Default value: `1`

##### <a name="manage_sysstat"></a>`manage_sysstat`

Data type: `Boolean`



Default value: ``false``

##### <a name="manage_vmware_tools"></a>`manage_vmware_tools`

Data type: `Boolean`



Default value: ``false``

##### <a name="vmware_tools_pkg"></a>`vmware_tools_pkg`

Data type: `String`



Default value: `'open-vm-tools'`

##### <a name="metrics_server_type"></a>`metrics_server_type`

Data type: `Optional[Enum['influxdb', 'graphite', 'splunk_hec']]`



Default value: `getvar('puppet_metrics_collector::metrics_server_type')`

##### <a name="metrics_server_hostname"></a>`metrics_server_hostname`

Data type: `Optional[String]`



Default value: `getvar('puppet_metrics_collector::metrics_server_hostname')`

##### <a name="metrics_server_port"></a>`metrics_server_port`

Data type: `Optional[Integer]`



Default value: `getvar('puppet_metrics_collector::metrics_server_port')`

##### <a name="metrics_server_db_name"></a>`metrics_server_db_name`

Data type: `Optional[String]`



Default value: `getvar('puppet_metrics_collector::metrics_server_db_name')`

### <a name="puppet_metrics_collectorsystemcpu"></a>`puppet_metrics_collector::system::cpu`

Collect System CPU Metrics

#### Parameters

The following parameters are available in the `puppet_metrics_collector::system::cpu` class:

* [`metrics_ensure`](#metrics_ensure)
* [`collection_frequency`](#collection_frequency)
* [`retention_days`](#retention_days)
* [`polling_frequency_seconds`](#polling_frequency_seconds)
* [`metrics_shipping_command`](#metrics_shipping_command)

##### <a name="metrics_ensure"></a>`metrics_ensure`

Data type: `String`



Default value: `$puppet_metrics_collector::system::system_metrics_ensure`

##### <a name="collection_frequency"></a>`collection_frequency`

Data type: `Integer`



Default value: `$puppet_metrics_collector::system::collection_frequency`

##### <a name="retention_days"></a>`retention_days`

Data type: `Integer`



Default value: `$puppet_metrics_collector::system::retention_days`

##### <a name="polling_frequency_seconds"></a>`polling_frequency_seconds`

Data type: `Integer`



Default value: `$puppet_metrics_collector::system::polling_frequency_seconds`

##### <a name="metrics_shipping_command"></a>`metrics_shipping_command`

Data type: `Optional[String]`



Default value: ``undef``

### <a name="puppet_metrics_collectorsystemmemory"></a>`puppet_metrics_collector::system::memory`

Collect System Memory Metrics

#### Parameters

The following parameters are available in the `puppet_metrics_collector::system::memory` class:

* [`metrics_ensure`](#metrics_ensure)
* [`collection_frequency`](#collection_frequency)
* [`retention_days`](#retention_days)
* [`polling_frequency_seconds`](#polling_frequency_seconds)
* [`metrics_shipping_command`](#metrics_shipping_command)

##### <a name="metrics_ensure"></a>`metrics_ensure`

Data type: `String`



Default value: `$puppet_metrics_collector::system::system_metrics_ensure`

##### <a name="collection_frequency"></a>`collection_frequency`

Data type: `Integer`



Default value: `$puppet_metrics_collector::system::collection_frequency`

##### <a name="retention_days"></a>`retention_days`

Data type: `Integer`



Default value: `$puppet_metrics_collector::system::retention_days`

##### <a name="polling_frequency_seconds"></a>`polling_frequency_seconds`

Data type: `Integer`



Default value: `$puppet_metrics_collector::system::polling_frequency_seconds`

##### <a name="metrics_shipping_command"></a>`metrics_shipping_command`

Data type: `Optional[String]`



Default value: ``undef``

### <a name="puppet_metrics_collectorsystempostgres"></a>`puppet_metrics_collector::system::postgres`

Collect PostgreSQL metrics

This class manages a cron job that uses `/opt/puppetlabs/server/bin/psql`
to collect metrics from a locally-running `pe-postgresql` service.

This class should not be included directly.
Include {puppet_metrics_collector::system} instead.

#### Parameters

The following parameters are available in the `puppet_metrics_collector::system::postgres` class:

* [`metrics_ensure`](#metrics_ensure)
* [`collection_frequency`](#collection_frequency)
* [`retention_days`](#retention_days)
* [`metrics_shipping_command`](#metrics_shipping_command)

##### <a name="metrics_ensure"></a>`metrics_ensure`

Data type: `String`



Default value: `$puppet_metrics_collector::system::system_metrics_ensure`

##### <a name="collection_frequency"></a>`collection_frequency`

Data type: `Integer`



Default value: `$puppet_metrics_collector::system::collection_frequency`

##### <a name="retention_days"></a>`retention_days`

Data type: `Integer`



Default value: `$puppet_metrics_collector::system::retention_days`

##### <a name="metrics_shipping_command"></a>`metrics_shipping_command`

Data type: `String`



Default value: `$puppet_metrics_collector::system::metrics_shipping_command`

### <a name="puppet_metrics_collectorsystemprocesses"></a>`puppet_metrics_collector::system::processes`

Collect System Processes Metrics

#### Parameters

The following parameters are available in the `puppet_metrics_collector::system::processes` class:

* [`metrics_ensure`](#metrics_ensure)
* [`collection_frequency`](#collection_frequency)
* [`retention_days`](#retention_days)
* [`polling_frequency_seconds`](#polling_frequency_seconds)
* [`metrics_shipping_command`](#metrics_shipping_command)

##### <a name="metrics_ensure"></a>`metrics_ensure`

Data type: `String`



Default value: `$puppet_metrics_collector::system::system_metrics_ensure`

##### <a name="collection_frequency"></a>`collection_frequency`

Data type: `Integer`



Default value: `$puppet_metrics_collector::system::collection_frequency`

##### <a name="retention_days"></a>`retention_days`

Data type: `Integer`



Default value: `$puppet_metrics_collector::system::retention_days`

##### <a name="polling_frequency_seconds"></a>`polling_frequency_seconds`

Data type: `Integer`



Default value: `$puppet_metrics_collector::system::polling_frequency_seconds`

##### <a name="metrics_shipping_command"></a>`metrics_shipping_command`

Data type: `Optional[String]`



Default value: ``undef``

### <a name="puppet_metrics_collectorsystemvmware"></a>`puppet_metrics_collector::system::vmware`

Collect VMware metrics

This class manages a cron job that collects metrics from:

    vmware-toolbox-cmd stat

This class should not be included directly.
Include {puppet_metrics_collector::system} instead.

#### Parameters

The following parameters are available in the `puppet_metrics_collector::system::vmware` class:

* [`metrics_ensure`](#metrics_ensure)
* [`collection_frequency`](#collection_frequency)
* [`retention_days`](#retention_days)
* [`metrics_shipping_command`](#metrics_shipping_command)

##### <a name="metrics_ensure"></a>`metrics_ensure`

Data type: `String`



Default value: `$puppet_metrics_collector::system::system_metrics_ensure`

##### <a name="collection_frequency"></a>`collection_frequency`

Data type: `Integer`



Default value: `$puppet_metrics_collector::system::collection_frequency`

##### <a name="retention_days"></a>`retention_days`

Data type: `Integer`



Default value: `$puppet_metrics_collector::system::retention_days`

##### <a name="metrics_shipping_command"></a>`metrics_shipping_command`

Data type: `String`



Default value: `$puppet_metrics_collector::system::metrics_shipping_command`

## Defined types

### <a name="puppet_metrics_collectorcollect"></a>`puppet_metrics_collector::collect`

Create systemd units for collecting a given metric

#### Parameters

The following parameters are available in the `puppet_metrics_collector::collect` defined type:

* [`metrics_type`](#metrics_type)
* [`metrics_command`](#metrics_command)
* [`tidy_command`](#tidy_command)
* [`metric_ensure`](#metric_ensure)
* [`minute`](#minute)

##### <a name="metrics_type"></a>`metrics_type`

Data type: `String`



Default value: `$title`

##### <a name="metrics_command"></a>`metrics_command`

Data type: `String`



Default value: ``undef``

##### <a name="tidy_command"></a>`tidy_command`

Data type: `String`



Default value: ``undef``

##### <a name="metric_ensure"></a>`metric_ensure`

Data type: `String`



Default value: `'present'`

##### <a name="minute"></a>`minute`

Data type: `String`



Default value: `'5'`

### <a name="puppet_metrics_collectorpe_metric"></a>`puppet_metrics_collector::pe_metric`

Collect Puma or TrapperKeeper Metrics

#### Parameters

The following parameters are available in the `puppet_metrics_collector::pe_metric` defined type:

* [`metrics_type`](#metrics_type)
* [`metric_ensure`](#metric_ensure)
* [`cron_minute`](#cron_minute)
* [`retention_days`](#retention_days)
* [`hosts`](#hosts)
* [`metrics_port`](#metrics_port)
* [`metric_script_file`](#metric_script_file)
* [`ssl`](#ssl)
* [`excludes`](#excludes)
* [`additional_metrics`](#additional_metrics)
* [`remote_metrics_enabled`](#remote_metrics_enabled)
* [`override_metrics_command`](#override_metrics_command)
* [`metrics_server_type`](#metrics_server_type)
* [`metrics_server_hostname`](#metrics_server_hostname)
* [`metrics_server_port`](#metrics_server_port)
* [`metrics_server_db_name`](#metrics_server_db_name)

##### <a name="metrics_type"></a>`metrics_type`

Data type: `String`



Default value: `$title`

##### <a name="metric_ensure"></a>`metric_ensure`

Data type: `Enum['absent', 'present']`



Default value: `'present'`

##### <a name="cron_minute"></a>`cron_minute`

Data type: `String`



Default value: `'0/5'`

##### <a name="retention_days"></a>`retention_days`

Data type: `Integer`



Default value: `90`

##### <a name="hosts"></a>`hosts`

Data type: `Array[String]`



Default value: `['127.0.0.1']`

##### <a name="metrics_port"></a>`metrics_port`

Data type: `Integer`



Default value: ``undef``

##### <a name="metric_script_file"></a>`metric_script_file`

Data type: `String`



Default value: `'tk_metrics'`

##### <a name="ssl"></a>`ssl`

Data type: `Boolean`



Default value: ``true``

##### <a name="excludes"></a>`excludes`

Data type: `Array[String]`



Default value: `puppet_metrics_collector::version_based_excludes($title)`

##### <a name="additional_metrics"></a>`additional_metrics`

Data type: `Array[Hash]`



Default value: `[]`

##### <a name="remote_metrics_enabled"></a>`remote_metrics_enabled`

Data type: `Optional[Boolean]`



Default value: `lookup('puppet_metrics_collector::pe_metric::remote_metrics_enabled', {'default_value' => undef})`

##### <a name="override_metrics_command"></a>`override_metrics_command`

Data type: `Optional[String]`



Default value: ``undef``

##### <a name="metrics_server_type"></a>`metrics_server_type`

Data type: `Optional[Enum['influxdb','graphite','splunk_hec']]`



Default value: ``undef``

##### <a name="metrics_server_hostname"></a>`metrics_server_hostname`

Data type: `Optional[String]`



Default value: ``undef``

##### <a name="metrics_server_port"></a>`metrics_server_port`

Data type: `Optional[Integer]`



Default value: ``undef``

##### <a name="metrics_server_db_name"></a>`metrics_server_db_name`

Data type: `Optional[String]`



Default value: ``undef``

### <a name="puppet_metrics_collectorsar_metric"></a>`puppet_metrics_collector::sar_metric`

Collect System Metrics

#### Parameters

The following parameters are available in the `puppet_metrics_collector::sar_metric` defined type:

* [`metrics_type`](#metrics_type)
* [`metric_ensure`](#metric_ensure)
* [`cron_minute`](#cron_minute)
* [`retention_days`](#retention_days)
* [`collection_frequency`](#collection_frequency)
* [`polling_frequency_seconds`](#polling_frequency_seconds)
* [`metric_script_file`](#metric_script_file)
* [`metrics_shipping_command`](#metrics_shipping_command)

##### <a name="metrics_type"></a>`metrics_type`

Data type: `String`



Default value: `$title`

##### <a name="metric_ensure"></a>`metric_ensure`

Data type: `Enum['absent', 'present']`



Default value: `'present'`

##### <a name="cron_minute"></a>`cron_minute`

Data type: `String`



Default value: `'0/5'`

##### <a name="retention_days"></a>`retention_days`

Data type: `Integer`



Default value: `90`

##### <a name="collection_frequency"></a>`collection_frequency`

Data type: `Integer`



Default value: `5`

##### <a name="polling_frequency_seconds"></a>`polling_frequency_seconds`

Data type: `Integer`



Default value: `1`

##### <a name="metric_script_file"></a>`metric_script_file`

Data type: `String`



Default value: `'system_metrics'`

##### <a name="metrics_shipping_command"></a>`metrics_shipping_command`

Data type: `String`



Default value: `$puppet_metrics_collector::system::metrics_shipping_command`

## Functions

### <a name="puppet_metrics_collectorgenerate_metrics_server_command"></a>`puppet_metrics_collector::generate_metrics_server_command`

Type: Puppet Language

Generate the metrics shipping command for the cron job including remote metrics

#### `puppet_metrics_collector::generate_metrics_server_command(Optional[String] $scripts_dir, Optional[Enum['influxdb','graphite','splunk_hec']] $metrics_server_type = undef, Optional[String] $metrics_server_hostname = undef, Optional[String] $metrics_server_db_name = undef, Optional[Integer] $metrics_server_port = undef)`

The puppet_metrics_collector::generate_metrics_server_command function.

Returns: `String` of the metrics command or undef

##### `scripts_dir`

Data type: `Optional[String]`

the path to the scripts directory

##### `metrics_server_type`

Data type: `Optional[Enum['influxdb','graphite','splunk_hec']]`

the metric server type

##### `metrics_server_hostname`

Data type: `Optional[String]`

the metric server's address

##### `metrics_server_db_name`

Data type: `Optional[String]`

the influxdb database name

##### `metrics_server_port`

Data type: `Optional[Integer]`

the port to connect to

### <a name="puppet_metrics_collectorhosts_with_pe_profile"></a>`puppet_metrics_collector::hosts_with_pe_profile`

Type: Puppet Language

The puppet_metrics_collector::hosts_with_pe_profile function.

#### `puppet_metrics_collector::hosts_with_pe_profile(Any $profile)`

The puppet_metrics_collector::hosts_with_pe_profile function.

Returns: `Any`

##### `profile`

Data type: `Any`



### <a name="puppet_metrics_collectorto_yaml"></a>`puppet_metrics_collector::to_yaml`

Type: Ruby 4.x API

The puppet_metrics_collector::to_yaml function.

#### `puppet_metrics_collector::to_yaml(Hash $hash_or_array)`

The puppet_metrics_collector::to_yaml function.

Returns: `Any`

##### `hash_or_array`

Data type: `Hash`



#### `puppet_metrics_collector::to_yaml(Array $hash_or_array)`

The puppet_metrics_collector::to_yaml function.

Returns: `Any`

##### `hash_or_array`

Data type: `Array`



### <a name="puppet_metrics_collectorversion_based_excludes"></a>`puppet_metrics_collector::version_based_excludes`

Type: Puppet Language

The puppet_metrics_collector::version_based_excludes function.

#### `puppet_metrics_collector::version_based_excludes(String[1] $metrics_type)`

The puppet_metrics_collector::version_based_excludes function.

Returns: `Array[String]`

##### `metrics_type`

Data type: `String[1]`



