# Reference

<!-- DO NOT EDIT: This document was generated by Puppet Strings -->

## Table of Contents

### Classes

* [`pe_databases`](#pe_databases)
* [`pe_databases::backup`](#pe_databasesbackup)
* [`pe_databases::pg_repack`](#pe_databasespg_repack)
* [`pe_databases::postgresql_settings`](#pe_databasespostgresql_settings)
* [`pe_databases::postgresql_settings::table_settings`](#pe_databasespostgresql_settingstable_settings)

### Defined types

* [`pe_databases::collect`](#pe_databasescollect): Create systemd units for repacking a given database type
* [`pe_databases::set_puppetdb_table_autovacuum_cost_delay_zero`](#pe_databasesset_puppetdb_table_autovacuum_cost_delay_zero)
* [`pe_databases::set_table_attribute`](#pe_databasesset_table_attribute)

### Functions

* [`pe_databases::version_based_databases`](#pe_databasesversion_based_databases)

### Tasks

* [`reset_pgrepack_schema`](#reset_pgrepack_schema): This task will remove and recreate the pg_repack extension

## Classes

### <a name="pe_databases"></a>`pe_databases`

The pe_databases class.

#### Parameters

The following parameters are available in the `pe_databases` class:

* [`manage_database_backups`](#manage_database_backups)
* [`manage_database_maintenance`](#manage_database_maintenance)
* [`disable_maintenance`](#disable_maintenance)
* [`manage_postgresql_settings`](#manage_postgresql_settings)
* [`manage_table_settings`](#manage_table_settings)
* [`install_dir`](#install_dir)
* [`scripts_dir`](#scripts_dir)

##### <a name="manage_database_backups"></a>`manage_database_backups`

Data type: `Variant[Boolean,Undef]`



Default value: ``undef``

##### <a name="manage_database_maintenance"></a>`manage_database_maintenance`

Data type: `Boolean`



Default value: ``true``

##### <a name="disable_maintenance"></a>`disable_maintenance`

Data type: `Boolean`



Default value: `lookup('pe_databases::disable_maintenance', {'default_value' => false})`

##### <a name="manage_postgresql_settings"></a>`manage_postgresql_settings`

Data type: `Boolean`



Default value: ``true``

##### <a name="manage_table_settings"></a>`manage_table_settings`

Data type: `Boolean`



Default value: ``false``

##### <a name="install_dir"></a>`install_dir`

Data type: `String`



Default value: `'/opt/puppetlabs/pe_databases'`

##### <a name="scripts_dir"></a>`scripts_dir`

Data type: `String`



Default value: `"${install_dir}/scripts"`

### <a name="pe_databasesbackup"></a>`pe_databases::backup`

The pe_databases::backup class.

#### Parameters

The following parameters are available in the `pe_databases::backup` class:

* [`databases_and_backup_schedule`](#databases_and_backup_schedule)
* [`psql_version`](#psql_version)
* [`backup_directory`](#backup_directory)
* [`backup_script_path`](#backup_script_path)
* [`daily_databases_path`](#daily_databases_path)
* [`backup_logging_directory`](#backup_logging_directory)
* [`retention_policy`](#retention_policy)
* [`disable_maintenance`](#disable_maintenance)

##### <a name="databases_and_backup_schedule"></a>`databases_and_backup_schedule`

Data type: `Array[Hash]`



Default value: `[
    {
      'databases' => pe_databases::version_based_databases(),
      'schedule'  =>
      {
        'minute' => '30',
        'hour'   => '22',
      },
    },
    {
      'databases' => ['pe-puppetdb'],
      'schedule'  =>
      {
        'minute'  => '0',
        'hour'    => '2',
        'weekday' => '7',
      },
    }
  ]`

##### <a name="psql_version"></a>`psql_version`

Data type: `String`



Default value: `$pe_databases::psql_version`

##### <a name="backup_directory"></a>`backup_directory`

Data type: `String`



Default value: `"/opt/puppetlabs/server/data/postgresql/${psql_version}/backups"`

##### <a name="backup_script_path"></a>`backup_script_path`

Data type: `String`



Default value: `"${pe_databases::scripts_dir}/puppet_enterprise_database_backup.sh"`

##### <a name="daily_databases_path"></a>`daily_databases_path`

Data type: `String`



Default value: `"${pe_databases::install_dir}/default_daily_databases.txt"`

##### <a name="backup_logging_directory"></a>`backup_logging_directory`

Data type: `String`



Default value: `'/var/log/puppetlabs/pe_databases_backup'`

##### <a name="retention_policy"></a>`retention_policy`

Data type: `Integer`



Default value: `2`

##### <a name="disable_maintenance"></a>`disable_maintenance`

Data type: `Boolean`



Default value: ``true``

### <a name="pe_databasespg_repack"></a>`pe_databases::pg_repack`

The pe_databases::pg_repack class.

#### Parameters

The following parameters are available in the `pe_databases::pg_repack` class:

* [`disable_maintenance`](#disable_maintenance)
* [`jobs`](#jobs)

##### <a name="disable_maintenance"></a>`disable_maintenance`

Data type: `Boolean`



Default value: ``false``

##### <a name="jobs"></a>`jobs`

Data type: `Integer`



Default value: `/`

### <a name="pe_databasespostgresql_settings"></a>`pe_databases::postgresql_settings`

The pe_databases::postgresql_settings class.

#### Parameters

The following parameters are available in the `pe_databases::postgresql_settings` class:

* [`autovacuum_vacuum_scale_factor`](#autovacuum_vacuum_scale_factor)
* [`autovacuum_analyze_scale_factor`](#autovacuum_analyze_scale_factor)
* [`autovacuum_max_workers`](#autovacuum_max_workers)
* [`log_autovacuum_min_duration`](#log_autovacuum_min_duration)
* [`log_temp_files`](#log_temp_files)
* [`work_mem`](#work_mem)
* [`max_connections`](#max_connections)
* [`arbitrary_postgresql_conf_settings`](#arbitrary_postgresql_conf_settings)
* [`checkpoint_completion_target`](#checkpoint_completion_target)
* [`checkpoint_segments`](#checkpoint_segments)
* [`manage_postgresql_service`](#manage_postgresql_service)
* [`all_in_one_pe_install`](#all_in_one_pe_install)
* [`manage_reports_autovacuum_cost_delay`](#manage_reports_autovacuum_cost_delay)
* [`factsets_autovacuum_vacuum_scale_factor`](#factsets_autovacuum_vacuum_scale_factor)
* [`reports_autovacuum_vacuum_scale_factor`](#reports_autovacuum_vacuum_scale_factor)
* [`maintenance_work_mem`](#maintenance_work_mem)
* [`autovacuum_work_mem`](#autovacuum_work_mem)
* [`psql_version`](#psql_version)

##### <a name="autovacuum_vacuum_scale_factor"></a>`autovacuum_vacuum_scale_factor`

Data type: `Float[0,1]`



Default value: `0.08`

##### <a name="autovacuum_analyze_scale_factor"></a>`autovacuum_analyze_scale_factor`

Data type: `Float[0,1]`



Default value: `0.04`

##### <a name="autovacuum_max_workers"></a>`autovacuum_max_workers`

Data type: `Integer`



Default value: `max(3, min(8, $facts['processors']['count'] / 3))`

##### <a name="log_autovacuum_min_duration"></a>`log_autovacuum_min_duration`

Data type: `Integer`



Default value: `-`

##### <a name="log_temp_files"></a>`log_temp_files`

Data type: `Integer`



Default value: `-`

##### <a name="work_mem"></a>`work_mem`

Data type: `String`



Default value: `'8MB'`

##### <a name="max_connections"></a>`max_connections`

Data type: `Integer`



Default value: `1000`

##### <a name="arbitrary_postgresql_conf_settings"></a>`arbitrary_postgresql_conf_settings`

Data type: `Hash`



Default value: `{}`

##### <a name="checkpoint_completion_target"></a>`checkpoint_completion_target`

Data type: `Float[0,1]`



Default value: `0.9`

##### <a name="checkpoint_segments"></a>`checkpoint_segments`

Data type: `Integer`



Default value: `128`

##### <a name="manage_postgresql_service"></a>`manage_postgresql_service`

Data type: `Boolean`



Default value: ``true``

##### <a name="all_in_one_pe_install"></a>`all_in_one_pe_install`

Data type: `Boolean`



Default value: ``true``

##### <a name="manage_reports_autovacuum_cost_delay"></a>`manage_reports_autovacuum_cost_delay`

Data type: `Boolean`



Default value: ``true``

##### <a name="factsets_autovacuum_vacuum_scale_factor"></a>`factsets_autovacuum_vacuum_scale_factor`

Data type: `Optional[Float[0,1]]`



Default value: `0.80`

##### <a name="reports_autovacuum_vacuum_scale_factor"></a>`reports_autovacuum_vacuum_scale_factor`

Data type: `Optional[Float[0,1]]`



Default value: `0.01`

##### <a name="maintenance_work_mem"></a>`maintenance_work_mem`

Data type: `String`



Default value: `$all_in_one_pe_install`

##### <a name="autovacuum_work_mem"></a>`autovacuum_work_mem`

Data type: `String`



Default value: `$all_in_one_pe_install`

##### <a name="psql_version"></a>`psql_version`

Data type: `String`



Default value: `$pe_databases::psql_version`

### <a name="pe_databasespostgresql_settingstable_settings"></a>`pe_databases::postgresql_settings::table_settings`

The pe_databases::postgresql_settings::table_settings class.

#### Parameters

The following parameters are available in the `pe_databases::postgresql_settings::table_settings` class:

* [`manage_reports_autovacuum_cost_delay`](#manage_reports_autovacuum_cost_delay)
* [`factsets_autovacuum_vacuum_scale_factor`](#factsets_autovacuum_vacuum_scale_factor)
* [`reports_autovacuum_vacuum_scale_factor`](#reports_autovacuum_vacuum_scale_factor)
* [`catalogs_autovacuum_vacuum_scale_factor`](#catalogs_autovacuum_vacuum_scale_factor)
* [`certnames_autovacuum_vacuum_scale_factor`](#certnames_autovacuum_vacuum_scale_factor)

##### <a name="manage_reports_autovacuum_cost_delay"></a>`manage_reports_autovacuum_cost_delay`

Data type: `Boolean`



Default value: `lookup('pe_databases::postgresql_settings::manage_reports_autovacuum_cost_delay',    {'default_value' => true})`

##### <a name="factsets_autovacuum_vacuum_scale_factor"></a>`factsets_autovacuum_vacuum_scale_factor`

Data type: `Optional[Float[0,1]]`



Default value: `lookup('pe_databases::postgresql_settings::factsets_autovacuum_vacuum_scale_factor', {'default_value' => 0.80})`

##### <a name="reports_autovacuum_vacuum_scale_factor"></a>`reports_autovacuum_vacuum_scale_factor`

Data type: `Optional[Float[0,1]]`



Default value: `lookup('pe_databases::postgresql_settings::reports_autovacuum_vacuum_scale_factor',  {'default_value' => 0.01})`

##### <a name="catalogs_autovacuum_vacuum_scale_factor"></a>`catalogs_autovacuum_vacuum_scale_factor`

Data type: `Optional[Float[0,1]]`



Default value: `0.75`

##### <a name="certnames_autovacuum_vacuum_scale_factor"></a>`certnames_autovacuum_vacuum_scale_factor`

Data type: `Optional[Float[0,1]]`



Default value: `0.75`

## Defined types

### <a name="pe_databasescollect"></a>`pe_databases::collect`

Create systemd units for repacking a given database type

#### Parameters

The following parameters are available in the `pe_databases::collect` defined type:

* [`database_type`](#database_type)
* [`command`](#command)
* [`disable_maintenance`](#disable_maintenance)
* [`on_cal`](#on_cal)

##### <a name="database_type"></a>`database_type`

Data type: `String`



Default value: `$title`

##### <a name="command"></a>`command`

Data type: `String`



Default value: ``undef``

##### <a name="disable_maintenance"></a>`disable_maintenance`

Data type: `Boolean`



Default value: ``false``

##### <a name="on_cal"></a>`on_cal`

Data type: `String`



Default value: ``undef``

### <a name="pe_databasesset_puppetdb_table_autovacuum_cost_delay_zero"></a>`pe_databases::set_puppetdb_table_autovacuum_cost_delay_zero`

The pe_databases::set_puppetdb_table_autovacuum_cost_delay_zero class.

#### Parameters

The following parameters are available in the `pe_databases::set_puppetdb_table_autovacuum_cost_delay_zero` defined type:

* [`table_name`](#table_name)

##### <a name="table_name"></a>`table_name`

Data type: `String`



Default value: `$title`

### <a name="pe_databasesset_table_attribute"></a>`pe_databases::set_table_attribute`

The pe_databases::set_table_attribute class.

#### Parameters

The following parameters are available in the `pe_databases::set_table_attribute` defined type:

* [`db`](#db)
* [`table_name`](#table_name)
* [`table_attribute`](#table_attribute)
* [`table_attribute_value`](#table_attribute_value)

##### <a name="db"></a>`db`

Data type: `String`



##### <a name="table_name"></a>`table_name`

Data type: `String`



##### <a name="table_attribute"></a>`table_attribute`

Data type: `String`



##### <a name="table_attribute_value"></a>`table_attribute_value`

Data type: `String`



## Functions

### <a name="pe_databasesversion_based_databases"></a>`pe_databases::version_based_databases`

Type: Puppet Language

The pe_databases::version_based_databases function.

#### `pe_databases::version_based_databases()`

The pe_databases::version_based_databases function.

Returns: `Array[String]`

## Tasks

### <a name="reset_pgrepack_schema"></a>`reset_pgrepack_schema`

This task will remove and recreate the pg_repack extension

**Supports noop?** false

