# puppet infrastructure promote

## MAN PAGE

```
USAGE: puppet infrastructure promote [-y | --yes]
[--print-config]
[--topology TOPOLOGY]
[--skip-agent-config]
[--pcp-brokers URIS]
[--infra-pcp-brokers URIS]
[--puppetdb-termini URIS]
[--classifier-termini URIS]
[--agent-server-urls URIS]
[--infra-agent-server-urls URIS]
replica

Promote a PE node from a replica to a master.

DESCRIPTION:
Permanently promotes a replica to be the new primary master. Run this command
after verifying that the old primary master has been taken offline permanently,
because any requests to the old primary master during the promotion process
could leave your Puppet Enterprise infrastructure in a broken state.

REQUIREMENTS: This command must be invoked on the replica you want to promote.

OPTIONS:
  --agent-server-urls <URIS>        Hostnames and ports of your Puppet masters
                                    to run your Puppet agents against, in the
                                    order they should be tried. Sets the puppet
                                    agent `server_list` setting on all agents.
                                    In a compile master topology, should be the
                                    hostname and port of the load balancer.
                                    Format: --agent-server-urls hostname:port,hostname:port
  --pcp-brokers <URIS>              Hostnames and ports of the PCP brokers
                                    agents should connect to in the order they
                                    should be tried. Used to create the
                                    `broker_ws_uris` on all agents.  In a compile
                                    master topology, should be the hostname and port
                                    of the pcp load balancer.
                                    Format: --pcp-brokers hostname:port,hostname:port
  -—classifier-termini <URIS>       Hostnames and ports of your Node Classifiers
  -—infra-agent-server-urls <URIS>  Hostnames and ports your Puppet Masters to run your
                                    Puppet Infrastructure Agents against
  --infra-pcp-brokers <URIS>        Hostnames and ports of your PCP Brokers for
                                    PE infrastructure
  -—puppetdb-termini <URIS>         Hostnames and ports of your PuppetDBs
  --print-config                    Print the current configuration.
  --topology <TOPOLOGY>             The topology of your Puppet Enterprise
                                    installation: mono or mono-with-compile.
  --skip-agent-config               Do not change agent settings when enabling replica.
                                    Agent failover settings must be configured by the user.
  --yes, -y                         Answer yes to all confirmations.
  --render-as <FORMAT>              The rendering format to use.
  --verbose                         Whether to log verbosely.
  --debug                           Whether to log debug information.
  --trace                           Displays stack traces.
  --help, -h                        Displays man page.
```

## Examples
Promote steps:
```
> puppet infrastructure promote replica HOSTNAME

Back up the current node classifier hierarchy before promoting a primary master replica, because the promotion process modifies the hierarchy.

Make sure that the primary master is offline and can’t be returned to service. Is the primary master offline? [Y, n]
```

If n:

```
Check the primary master to see if it’s working or can be fixed. If the primary master can’t be brought back online, run `puppet infrastructure promote replica HOSTNAME` to replace the primary master with the primary master replica.
```

If Y, then do Step 1.5: MoM reachable (--master-check)? If that succeeds, output:

```
The primary master replica is not reachable.
```

If Step 1.5: MoM reachable? fails, then:
```
The primary master is still online. Remove the primary master from the network so agents can’t check in with it while the primary master replica is being promoted. Then, enter `puppet infrastructure promote replica HOSTNAME`.
Do you want to continue promoting the primary master replica? [y, N]
```

If n:

```
Check the primary master to see if it’s working or can be fixed. If the primary master can’t be brought back online, enter `puppet infrastructure promote replica HOSTNAME —master-check` to replace the primary master with the primary master replica.
```

If Y, do Step 2: Make database writeable with a puppet apply, update NC and bump CA (--config-update). While that’s working, output:

```
Updating the node classifier. (not sure if being more specific is helpful. Use progress indicator if there’s no info to output.)

Updating CA information. (not sure if being more specific is helpful. Use progress indicator if there’s no info to output.)
```

If Step 2 fails because of serial file problem, then:

```
Exiting promotion process.
```
You’ll get error info.

If Step 2 fails because of db-writeable problem, then:

```
Exiting promotion process.
```

You’ll get error info.

If Step 2 succeeds, do Step 3: Run puppet agent on the replica (--agent-run). Show any progress info or progress indicator while that’s going.

If Step 3: Run puppet agent fails, then:

```
Exiting promotion process.
```

Error info. Need to start over.

Once all steps are complete, then:

```
<HOST NAME> is now the primary master.

You no longer have a primary master replica. To provision a new primary master replica, enter `puppet infrastructure provision replica HOSTNAME`

To enforce the new configuration, enter <orchestrator command (tbd)> to run Puppet on all nodes.

Note: You must have an RBAC token to run this command. For more information about how to generate an RBAC token, see <link to documentation>.
<don’t show: Exit code: 0>
```

## Planned, but not implemented
--db-write makes DB write-able so user can restore a previously backed-up Classifier hierarchy

Error2: If something goes wrong during this process and the user tries to restore a previously backed-up classifier hierarchy, they need write access to the database. If it’s in read-only mode:

```
The database is read-only. Enter `puppet infrastructure promote replica HOSTNAME --db-write` to get write access to the database.
```
