# puppet infrastructure status

## MAN PAGE

```
USAGE: puppet infrastructure status [--format json]
[--host HOSTNAME]
[--service SERVICENAME]
[--timeout TIMEOUT_SECONDS]

Check the status of all PE services

DESCRIPTION:

Displays error states or any other alerts from Puppet Enterprise services.
Services in the list are ordered by node. Any alerts are listed below the
corresponding service.
If you expect a node to be listed and it's not shown, or the status command is
trying to contact a node that you've removed, run Puppet on the primary master
again to update the status command's configuration.

OPTIONS:

  --render-as <FORMAT>              The rendering format to use. (takes
                                    precedence over --format)
  --format json                     Outputs in JSON format. Contains more detail.
  --host <NODE NAME>                Displays status and alerts for all services
                                    on a specified host
  --service <SERVICE NAME>          Displays status and alerts for a specified
                                    service. Accepted values: activity,
                                    classifier, code-manager, file-sync-client,
                                    file-sync-storage, master, orchestrator,
                                    pcp-broker, puppetdb, rbac.
  --timeout <TIMEOUT SECONDS>       How long to wait for status response before
                                    timing out, in seconds. Default is 5 seconds.
  --verbose                         Whether to log verbosely.
  --debug                           Whether to log debug information.
  --trace                           Displays stack traces.
  --help, -h                        Displays man page.
```

## From spec
This command displays status and alerts for Puppet services, including the activity, classifier, and RBAC services, Puppet Server, and PuppetDB.

As applicable, the command reports separately on primary master, compile masters, and primary master replicas. If all services are operational, with no alerts, the command returns a status summary only. If there are errors or alerts for any services, these are listed explicitly.

## Examples
The output lists the service, status, and alerts if the service has:
- a status of Error, Unknown, or Unreachable
- an alert of Error or Warning
The final line of the output lists the number of services that are operational out of the total number of services.

If the user wants to see all statuses and alerts, s/he needs use the verbose flag.

If the user uses the —service flag, s/he sees all status and alerts for that service on all hosts where it is present. PuppetDB, for example, may exist on both the primary master and the primary master replica. Both are shown unless the —host flag is also used.

If the user users the —host flag, s/he sees the service, status, and alerts on that host (primary master replica, for example) if the service has:
- a status of Error, Unknown, or Unreachable
- an alert of Error or Warning
If the user also uses the —verbose flag, s/he sees all statuses and alerts for services on that host.

Service name and status, is colorized in the output:
- Red for error, unknown, and unreachable status
- Orange for starting and stopped status
- Green for running status

Service and status are always associated with a particular host: primary master, primary master replica, or compile master. Each is indicated by a URL.

Alerts are listed beneath the status line, indented. Show one alert per line, with colorization: errors first, then warnings, then info alerts.


Sample Output 1, when there are multiple errors and alerts:
```
> puppet infrastructure status 

Notice: Contacting services for status information...
Code Manager: Unreachable on Primary Master, https://foo.bar.blah1:8170/
File Sync Storage Service: Unreachable on Primary Master, https://foo.bar.blah1:8140/
File Sync Client Service: Unreachable on Primary Master, https://foo.bar.blah1:8140/
Puppet Server: Unreachable on Primary Master, https://foo.bar.blah1:8140/
Classifier: Running on Primary Master, https://foo.bar.blah1:4433/classifier-api
RBAC: Running on Primary Master, https://foo.bar.blah1:4433/rbac-api
Activity Service: Running on Primary Master, https://foo.bar.blah1:4433/activity-api
Orchestrator: Unknown on Primary Master, https://foo.bar.blah1:8143/orchestrator
PCP Broker: Running on Primary Master, wss://foo.bar.blah1:8142/pcp
PCP Broker v2: Running on Primary Master, wss://foo.bar.blah1:8142/pcp2
PuppetDB: Running on Primary Master, https://foo.bar.blah1:8081/pdb

<date/timestamp>
6 of 11 services are fully operational.
```

Sample Output 2, when all services have running status and Info alerts only:

```
> puppet infrastructure status

<date/time stamp>
15 of 15 services are fully operational.
```
