require 'puppet/indirector/face'
require 'puppet_x/puppetlabs/meep/enable/action'
require 'puppet_x/puppetlabs/meep/enable/flags'

Puppet::Face.define(:infrastructure, '1.0.0') do

  action :enable do
    summary _('Enables a provisioned replica node to take over from a primary during failover.')
    description PuppetX::Util::String::Formatter.join_and_indent([
        _("After a node has been fully provisioned, it needs to be enabled."),
        "\n",
        "puppet infrastructure enable replica <NODE NAME>",
        "\n",
        "replica role:"],
        PuppetX::Util::String::Formatter.indent_level(1)) + "\n" +
      PuppetX::Util::String::Formatter.join_and_indent([
        _("When provisioning a replica, some data needs to be copied to it before it's ready to serve requests."),
        _("After the data has been copied (which you can verify using `puppet infrastructure status`), enabling it will allow it to serve requests from the rest of your PE infrastructure when the primary is not available.")],
        PuppetX::Util::String::Formatter.indent_level(2))

    arguments "<role> <replica_certname>"

    option("--token-file <token_path>") do
      summary _("Path to a token file")
      description PuppetX::Util::String::Formatter.indent(
        _("Path to an RBAC token to use for authentication."),
        PuppetX::Util::String::Formatter.indent_level(1))
    end

    option('--print-config') do
      summary _("Print the current configuration")
      description PuppetX::Util::String::Formatter.indent(
        _("Shows the current configuration of HA related settings."),
        PuppetX::Util::String::Formatter.indent_level(1))
    end

    option("--force") do
      summary _("Skip all pre-enable validation.")
      default_to {false}
      description <<-EOT
        Skip all pre-enable validation. Skipping checks will mean that
        prerequisite services may not be configured or running and some
        enable steps may fail or need to be manually run.
      EOT
    end

    PuppetX::Puppetlabs::Meep::Enable::Flags.add_flags(self)

    when_invoked do |role, replica_certname, options|
      if role != 'replica'
        raise PuppetX::Util::InfrastructureUnknownRoleError.new(role, ["replica"]) # rubocop:disable GetText/DecorateFunctionMessage
      end

      impl = PuppetX::Puppetlabs::Meep::Enable::Action.new(replica_certname, options)
      impl.run
    end
  end
end
