# This is nearly identical to the :console destination from
# lib/puppet/util/log/destinations.rb:143. Because of how it is written,
# subclassing is not very practical (we'd be replacing def handle() anyway...)
Puppet::Util::Log.newdesttype :timestamped_console do
  require 'puppet/util/colors'
  include Puppet::Util::Colors

  PE_LOG_FORMAT = "%Y-%m-%dT%H:%M:%S.%L%:z"

  def initialize
    # Flush output immediately.
    $stderr.sync = true
    $stdout.sync = true
  end

  def handle(msg)
    levels = {
      :emerg   => { :name => 'Emergency', :color => :hred,     :stream => $stderr },
      :alert   => { :name => 'Alert',     :color => :hred,     :stream => $stderr },
      :crit    => { :name => 'Critical',  :color => :hred,     :stream => $stderr },
      :err     => { :name => 'Error',     :color => :hred,     :stream => $stderr },
      :warning => { :name => 'Warning',   :color => :hyellow,  :stream => $stderr },

      :notice  => { :name => 'Notice',    :color => :reset,    :stream => $stdout },
      :info    => { :name => 'Info',      :color => :green,    :stream => $stdout },
      :debug   => { :name => 'Debug',     :color => :cyan,     :stream => $stdout },
    }

    str = msg.respond_to?(:multiline) ? msg.multiline : msg.to_s
    str = msg.source == "Puppet" ? str : "#{msg.source}: #{str}"

    level = levels[msg.level]
    level[:stream].puts colorize(level[:color], "#{msg.time.strftime(PE_LOG_FORMAT)} - [#{level[:name]}]: #{str}")
  end
end
