module PuppetX
  module Util
    # A mixin for some shared utility functions.
    module Utilities
      def self.symbolize_keys(h)
        if h.kind_of?(Array)
          h.map { |elem| symbolize_keys(elem) }
        elsif h.kind_of?(Hash)
          h.map { |k,v| [k.to_sym, symbolize_keys(v)] }.to_h
        else
          h
        end
      end

      def symbolize_keys(h)
        Utilities.symbolize_keys(h)
      end

      # @return [Hash] default service hash representing a service we failed
      # to conect to.
      def self.unreachable_status_for_service(svc)
        { :service => svc[:status_key],
          :display_name => svc[:display_name],
          :state => :unreachable,
          :status => nil,
          :server => svc[:server],
          :url => svc[:url],
          :status_url => svc[:status_url],
          :type => svc[:type],
          :alerts => [] }
      end

      def unreachable_status_for_service(svc)
        Utilities.unreachable_status_for_service(svc)
      end
    end
  end
end
