function puppet_enterprise::calculate_puppetserver_java_args (
  Optional[Integer] $jruby_max_active_instances = lookup(['puppet_enterprise::master::puppetserver::jruby_max_active_instances',
                                                          'puppet_enterprise::master::jruby_max_active_instances'],
                                   {'default_value' => puppet_enterprise::calculate_puppetserver_jruby_max_active_instances()}),
  Optional[String] $java_stack_size = lookup(['puppet_enterprise::master::puppetserver::java_stack_size'],
                                             {'default_value' => '2m'}),
) >> Hash {
  $memorysize_in_mb = $facts['memory']['system']['total_bytes'] / 1048576

  $ram_puppetserver = puppet_enterprise::calculate_puppetserver_heap_size(
    $jruby_max_active_instances )

  $puppetserver_java_args = {
    'Xmx' => "${ram_puppetserver}m",
    'Xms' => "${ram_puppetserver}m",
    'Xss' => $java_stack_size,
  }
}
