function puppet_enterprise::calculate_puppetserver_reserved_code_cache (
  Optional[Integer] $jruby_max_active_instances,
  Boolean $return_int = false
) >> Optional[Variant[String,Integer]] {
  $memorysize_in_mb = Integer($facts['memory']['system']['total_bytes']) / 1048576

  if $trusted['extensions']['pp_auth_role'] == 'pe_compiler' {
    $ram_reserved_code_cache_per_jruby = 128
    $minimum_ram_reserved_code_cache   = $ram_reserved_code_cache_per_jruby
    $maximum_ram_reserved_code_cache   = 2048

    $ram_reserved_code_cache = pe_clamp($minimum_ram_reserved_code_cache, ($jruby_max_active_instances * $ram_reserved_code_cache_per_jruby), $maximum_ram_reserved_code_cache)
  } else {
    if $memorysize_in_mb <= 1024 {
      $ram_reserved_code_cache = undef
    } elsif $memorysize_in_mb <= 2048 {
      $ram_reserved_code_cache = undef
    } else {
      $ram_reserved_code_cache = 512
    }
  }

  $reserved_code_cache = $ram_reserved_code_cache ? {
    undef   => undef,
    default => "${ram_reserved_code_cache}m"
  }

  if $return_int {
    $return = pe_pick($ram_reserved_code_cache,0)
  } else {
    $return = $reserved_code_cache
  }
}
