require_relative '../../../shared/config_translate'

Puppet::Functions.create_function(:'puppet_enterprise::parse_code_mgmt_forge_config') do
  dispatch :parse do
    param 'Optional[String]', :forge_proxy
    param 'Optional[String]', :forge_baseurl
    param 'Optional[String]', :forge_authorization_token
  end

  def parse(forge_proxy, forge_baseurl, forge_authorization_token)
    user_values = {
      'proxy' => forge_proxy,
      'baseurl' => forge_baseurl,
      'authorization-token' => forge_authorization_token,
    }.select { |_, value| value && !value.empty? }

    cm_config = nil
    r10k_config = nil

    if not user_values.empty?
      cm_config = user_values
      r10k_config = ConfigTranslate.key_dashes_to_underscores(user_values)
    end

    [cm_config, r10k_config]
  end
end
