#!/opt/puppetlabs/puppet/bin/ruby
# frozen_string_literal: true

require_relative '../files/enterprise_task_helper.rb'
require 'open3'

class CheckForPostgres < EnterpriseTaskHelper
  def task(_)
    output, status = Open3.capture2e('/opt/puppetlabs/bin/puppet resource package | grep pe-postgresql')
    pg_present = status.exitstatus == 0
    result = { pg_present: pg_present, output: output }
    result.to_json
  end
end

CheckForPostgres.run if __FILE__ == $PROGRAM_NAME
