# frozen_string_literal: true

# THIS IS A PE SPECIFIC IMPLEMENTATION OF APPLY_PREP: THIS IMPLEMENTATION WILL OVERRIDE THE ONE
# THAT COMES WITH A BOLT INSTALLATION
#
# Open-source bolt implementation:
# https://github.com/puppetlabs/bolt/blob/master/bolt-modules/boltlib/lib/puppet/functions/apply_prep.rb
#
Puppet::Functions.create_function(:apply_prep) do
  dispatch :apply_prep do
    param 'Boltlib::TargetSpec', :targets
  end

  def apply_prep(targets)
    unless Puppet[:tasks]
      raise Puppet::ParseErrorWithIssue
        .from_issue_and_stack(Bolt::PAL::Issues::PLAN_OPERATION_NOT_SUPPORTED_WHEN_COMPILING, action: 'apply_prep')
    end
    executor = Puppet.lookup(:bolt_executor)
    inventory = Puppet.lookup(:bolt_inventory)
    targets = inventory.get_targets(targets)
    fact_results = executor.apply_prep(targets)
    raise Bolt::RunFailure.new(fact_results, 'apply_prep', 'apply_prep') unless fact_results.ok?
    fact_results.each do |result|
      inventory.add_facts(result.target, result.value)
    end
    nil
  end
end
