#!/opt/puppetlabs/installer/bin/ruby

# This utilizes 'puppet lookup' to look up a Hiera value. Note that this will not include
# user_data.conf or classifier data, so you may need to use this in combination with a classifier lookup.

require 'open3'

if ARGV.length != 1
  puts "Script requires one argument: hiera lookup KEY"
  exit
end

key = ARGV[0]
stdout, stderr, status = Open3.capture3("/opt/puppetlabs/bin/puppet lookup #{key} --render-as s --compile --default NotFound")
if status.exitstatus != 0
  # During upgrades from some versions (e.g. 2018.1.x), using the --compile flag will fail since
  # we've already updated pe-modules. So if this fails, try without the flag to at least
  # get some Hiera lookup coverage.
  stdout, stderr, status = Open3.capture3("/opt/puppetlabs/bin/puppet lookup #{key} --render-as s --default NotFound")
end

if status.exitstatus != 0
  # Most likely it's all on stderr, but just in case, print both.
  puts "Error from puppet lookup: #{stdout} #{stderr}"
  exit status.exitstatus
else
  # Remove "NotFound" so the shim gets back a blank string when the param is not set
  puts stdout.split("\n").last.gsub('NotFound','').chomp
end
