# Uninstall agents and purge them from the given primary.
# WARNING: This plan has no safeguards!
plan enterprise_tasks::testing::purge_agents(
  TargetSpec $agents,
  Variant[Target,String] $primary,
) {
  $bin_dir = '/opt/puppetlabs/bin'
  $uninstaller_path = "${bin_dir}/puppet-enterprise-uninstaller"
  $uninstaller_test_results = run_command("test -f ${uninstaller_path}", $agents, '_catch_errors' => true)
  if !$uninstaller_test_results.ok() {
    $failed_targets = $uninstaller_test_results.error_set().map() |$r| { $r.target() }
    enterprise_tasks::message('purge_agents', "Copying puppet-enterprise-uninstaller to the set of targets that did not have it:\n${failed_targets}")

    run_command("mkdir -p ${bin_dir}", $failed_targets)
    $uninstaller_contents = run_command("cat ${uninstaller_path}", $primary).first().value()['stdout']

    # Create a local temp directory so we can create a copy of the uninstaller locally to upload
    $localhost_result_set = run_task(enterprise_tasks::tempdirs, 'localhost', 'purpose' => 'uninstaller')
    $local_tempdir = $localhost_result_set.find('localhost').value()['tempdir']
    $tmp_uninstaller = "${local_tempdir}/puppet-enterprise-uninstaller"
    file::write($tmp_uninstaller, $uninstaller_contents)
    upload_file($tmp_uninstaller, $uninstaller_path, $failed_targets)
    run_command("chmod 750 ${uninstaller_path}", $failed_targets)

    # Clean up.
    run_command("rm ${tmp_uninstaller} && rmdir ${local_tempdir}", localhost)
  }
  run_command('/opt/puppetlabs/bin/puppet-enterprise-uninstaller -ydp', $agents)
  get_targets($agents).each() |$a| {
    run_command("puppet node purge ${a.host()}", $primary)
  }
}
