# Reference

<!-- DO NOT EDIT: This document was generated by Puppet Strings -->

## Table of Contents

### Classes

* [`stdlib`](#stdlib): This module manages stdlib.
* [`stdlib::manage`](#stdlib--manage): A simple place to define trivial resources
* [`stdlib::stages`](#stdlib--stages): This class manages a standard set of run stages for Puppet. It is managed by
the stdlib class, and should not be declared independently.

### Resource types

* [`anchor`](#anchor): A simple resource type intended to be used as an anchor in a composite class.
* [`file_line`](#file_line): Ensures that a given line is contained within a file.

### Functions

* [`any2array`](#any2array): This converts any object to an array containing that object.
* [`any2bool`](#any2bool): Converts 'anything' to a boolean.
* [`assert_private`](#assert_private): Sets the current class or definition as private.
* [`base64`](#base64): Base64 encode or decode a string based on the command and the string submitted
* [`basename`](#basename): Strips directory (and optional suffix) from a filename
* [`batch_escape`](#batch_escape): DEPRECATED.  Use the namespaced function [`stdlib::batch_escape`](#stdlibbatch_escape) instead.
* [`bool2num`](#bool2num): Converts a boolean to a number.
* [`bool2str`](#bool2str): Converts a boolean to a string using optionally supplied arguments.
* [`clamp`](#clamp): Keeps value within the range [Min, X, Max] by sort based on integer value
(parameter order doesn't matter).
* [`concat`](#concat): Appends the contents of multiple arrays into array 1.
* [`convert_base`](#convert_base): Converts a given integer or base 10 string representing an integer to a
specified base, as a string.
* [`count`](#count): Counts the number of elements in array.
* [`deep_merge`](#deep_merge): Recursively merges two or more hashes together and returns the resulting hash.
* [`defined_with_params`](#defined_with_params): Takes a resource reference and an optional hash of attributes.
* [`delete`](#delete): Deletes all instances of a given element from an array, substring from a
string, or key from a hash.
* [`delete_at`](#delete_at): Deletes a determined indexed value from an array.
* [`delete_regex`](#delete_regex): Deletes all instances of a given element that match a regular expression
from an array or key from a hash.
* [`delete_undef_values`](#delete_undef_values): Returns a copy of input hash or array with all undefs deleted.
* [`delete_values`](#delete_values): Deletes all instances of a given value from a hash.
* [`deprecation`](#deprecation): Function to print deprecation warnings, Logs a warning once for a given key.
* [`difference`](#difference): This function returns the difference between two arrays.
* [`dirname`](#dirname): Returns the dirname of a path.
* [`dos2unix`](#dos2unix): Returns the Unix version of the given string.
* [`enclose_ipv6`](#enclose_ipv6): Takes an array of ip addresses and encloses the ipv6 addresses with square brackets.
* [`ensure_packages`](#ensure_packages): DEPRECATED.  Use the namespaced function [`stdlib::ensure_packages`](#stdlibensure_packages) instead.
* [`ensure_resource`](#ensure_resource): Takes a resource type, title, and a list of attributes that describe a
resource.
* [`ensure_resources`](#ensure_resources): Takes a resource type, title (only hash), and a list of attributes that describe a
resource.
* [`fact`](#fact): Digs into the facts hash using dot-notation
* [`fqdn_rand_string`](#fqdn_rand_string): DEPRECATED.  Use the namespaced function [`stdlib::fqdn_rand_string`](#stdlibfqdn_rand_string) instead.
* [`fqdn_rotate`](#fqdn_rotate): DEPRECATED.  Use the namespaced function [`stdlib::fqdn_rotate`](#stdlibfqdn_rotate) instead.
* [`fqdn_uuid`](#fqdn_uuid): Returns a [RFC 4122](https://tools.ietf.org/html/rfc4122) valid version 5 UUID based
on an FQDN string under the DNS namespace
* [`get_module_path`](#get_module_path): Returns the absolute path of the specified module for the current
environment.
* [`getparam`](#getparam): Returns the value of a resource's parameter.
* [`glob`](#glob): Uses same patterns as Dir#glob.
* [`grep`](#grep): This function searches through an array and returns any elements that match
the provided regular expression.
* [`has_interface_with`](#has_interface_with): DEPRECATED.  Use the namespaced function [`stdlib::has_interface_with`](#stdlibhas_interface_with) instead.
* [`has_interface_with`](#has_interface_with): Returns boolean based on kind and value.
* [`has_ip_address`](#has_ip_address): Returns true if the client has the requested IP address on some interface.
* [`has_ip_network`](#has_ip_network): Returns true if the client has an IP address within the requested network.
* [`intersection`](#intersection): This function returns an array of the intersection of two.
* [`is_a`](#is_a): Boolean check to determine whether a variable is of a given data type.
This is equivalent to the `=~` type checks.
* [`join_keys_to_values`](#join_keys_to_values): This function joins each key of a hash to that key's corresponding value with a
separator.
* [`load_module_metadata`](#load_module_metadata): This function loads the metadata of a given module.
* [`loadjson`](#loadjson): Load a JSON file containing an array, string, or hash, and return the data
in the corresponding native data type.
* [`loadyaml`](#loadyaml): Load a YAML file containing an array, string, or hash, and return the data
in the corresponding native data type.
* [`member`](#member): This function determines if a variable is a member of an array.
* [`merge`](#merge): DEPRECATED.  Use the namespaced function [`stdlib::merge`](#stdlibmerge) instead.
* [`merge`](#merge): Merges two or more hashes together and returns the resulting hash.
* [`num2bool`](#num2bool): This function converts a number or a string representation of a number into a
true boolean.
* [`os_version_gte`](#os_version_gte): DEPRECATED.  Use the namespaced function [`stdlib::os_version_gte`](#stdlibos_version_gte) instead.
* [`parsehocon`](#parsehocon): DEPRECATED.  Use the namespaced function [`stdlib::parsehocon`](#stdlibparsehocon) instead.
* [`parsejson`](#parsejson): This function accepts JSON as a string and converts it into the correct
Puppet structure.
* [`parsepson`](#parsepson): **Deprecated:** Starting Puppet 8, we no longer natively support PSON usage. This function should be removed once we stop supporting Puppet 7.

This function accepts PSON, a Puppet variant of JSON, as a string and converts
it into the correct Puppet structure
* [`parseyaml`](#parseyaml): This function accepts YAML as a string and converts it into the correct
Puppet structure.
* [`pick`](#pick): This function will return
the first value in a list of values that is not undefined or an empty string.
* [`pick_default`](#pick_default): This function will return the first value in a list of values that is not undefined or an empty string.
* [`powershell_escape`](#powershell_escape): DEPRECATED.  Use the namespaced function [`stdlib::powershell_escape`](#stdlibpowershell_escape) instead.
* [`prefix`](#prefix): This function applies a prefix to all elements in an array or a hash.
* [`pry`](#pry): This function invokes a pry debugging session in the current scope object.
* [`pw_hash`](#pw_hash): Hashes a password using the crypt function. Provides a hash usable
on most POSIX systems.
* [`range`](#range): When given range in the form of (start, stop) it will extrapolate a range as
an array.
* [`regexpescape`](#regexpescape): Regexp escape a string or array of strings.
Requires either a single string or an array as an input.
* [`reject`](#reject): This function searches through an array and rejects all elements that match
the provided regular expression.
* [`reverse`](#reverse): Reverses the order of a string or array.
* [`seeded_rand`](#seeded_rand): DEPRECATED.  Use the namespaced function [`stdlib::seeded_rand`](#stdlibseeded_rand) instead.
* [`seeded_rand_string`](#seeded_rand_string): DEPRECATED.  Use the namespaced function [`stdlib::seeded_rand_string`](#stdlibseeded_rand_string) instead.
* [`shell_escape`](#shell_escape): DEPRECATED.  Use the namespaced function [`stdlib::shell_escape`](#stdlibshell_escape) instead.
* [`shell_join`](#shell_join): Builds a command line string from the given array of strings. Each array item is escaped for Bourne shell. All items are then joined together
* [`shell_split`](#shell_split): Splits a string into an array of tokens in the same way the Bourne shell does.
* [`shuffle`](#shuffle): @summary  Randomizes the order of a string or array elements.
* [`squeeze`](#squeeze): Returns a new string where runs of the same character that occur in this set are replaced by a single character.
* [`stdlib::batch_escape`](#stdlib--batch_escape): Escapes a string so that it can be safely used in a batch shell command line.
* [`stdlib::crc32`](#stdlib--crc32): Run a CRC32 calculation against a given value.
* [`stdlib::deferrable_epp`](#stdlib--deferrable_epp): This function returns either a rendered template or a deferred function to render at runtime. If any of the values in the variables hash are 
* [`stdlib::end_with`](#stdlib--end_with): Returns true if str ends with one of the prefixes given. Each of the prefixes should be a String.
* [`stdlib::ensure`](#stdlib--ensure): function to cast ensure parameter to resource specific value
* [`stdlib::ensure_packages`](#stdlib--ensure_packages): Takes a list of packages and only installs them if they don't already exist.
* [`stdlib::extname`](#stdlib--extname): Returns the Extension (the Portion of Filename in Path starting from the
last Period).
* [`stdlib::fqdn_rand_string`](#stdlib--fqdn_rand_string): Generates a random alphanumeric string. Combining the `$fqdn` fact and an
optional seed for repeatable randomness.
* [`stdlib::fqdn_rotate`](#stdlib--fqdn_rotate): Rotates an array or string a random number of times, combining the `fqdn` fact and an optional seed for repeatable randomness.
* [`stdlib::has_function`](#stdlib--has_function): Returns whether the Puppet runtime has access to a given function.
* [`stdlib::has_interface_with`](#stdlib--has_interface_with): Returns boolean based on network interfaces present and their attribute values.
* [`stdlib::ip_in_range`](#stdlib--ip_in_range): Returns true if the ipaddress is within the given CIDRs
* [`stdlib::merge`](#stdlib--merge): Merges two or more hashes together or hashes resulting from iteration, and returns
the resulting hash.
* [`stdlib::nested_values`](#stdlib--nested_values): Get list of nested values from given hash
This function will return list of nested Hash values and returns list of values in form of Array
* [`stdlib::os_version_gte`](#stdlib--os_version_gte): Checks if the OS version is at least a certain version.
* [`stdlib::parsehocon`](#stdlib--parsehocon): This function accepts HOCON as a string and converts it into the correct
Puppet structure
* [`stdlib::powershell_escape`](#stdlib--powershell_escape): Escapes a string so that it can be safely used in a PowerShell command line.
* [`stdlib::seeded_rand`](#stdlib--seeded_rand): Generates a random whole number greater than or equal to 0 and less than max, using the value of seed for repeatable randomness.
* [`stdlib::seeded_rand_string`](#stdlib--seeded_rand_string): Generates a consistent random string of specific length based on provided seed.
* [`stdlib::sha256`](#stdlib--sha256): Run a SHA256 calculation against a given value.
* [`stdlib::shell_escape`](#stdlib--shell_escape): Escapes a string so that it can be safely used in a Bourne shell command line.
* [`stdlib::sort_by`](#stdlib--sort_by): Sort an Array, Hash or String by mapping values through a given block.
* [`stdlib::start_with`](#stdlib--start_with): Returns true if str starts with one of the prefixes given. Each of the prefixes should be a String.
* [`stdlib::str2resource`](#stdlib--str2resource): This converts a string to a puppet resource.
* [`stdlib::time`](#stdlib--time): This function is deprecated. It implements the functionality of the original non-namespaced stdlib `time` function.
* [`stdlib::to_json`](#stdlib--to_json): Convert a data structure and output to JSON
* [`stdlib::to_json_pretty`](#stdlib--to_json_pretty): Convert data structure and output to pretty JSON
* [`stdlib::to_python`](#stdlib--to_python): Convert an object into a String containing its Python representation
* [`stdlib::to_ruby`](#stdlib--to_ruby): Convert an object into a String containing its Ruby representation
* [`stdlib::to_toml`](#stdlib--to_toml): Convert a data structure and output to TOML.
* [`stdlib::to_yaml`](#stdlib--to_yaml): Convert a data structure and output it as YAML
* [`stdlib::type_of`](#stdlib--type_of): Returns the type of the passed value.
* [`stdlib::validate_domain_name`](#stdlib--validate_domain_name): Validate that all values passed are syntactically correct domain names.
Fail compilation if any value fails this check.
* [`stdlib::validate_email_address`](#stdlib--validate_email_address): Validate that all values passed are valid email addresses.
Fail compilation if any value fails this check.
* [`stdlib::xml_encode`](#stdlib--xml_encode): Encode strings for XML files
* [`str2bool`](#str2bool): This converts a string to a boolean.
* [`str2saltedpbkdf2`](#str2saltedpbkdf2): Convert a string into a salted SHA512 PBKDF2 password hash like requred for OS X / macOS 10.8+
* [`str2saltedsha512`](#str2saltedsha512): This converts a string to a salted-SHA512 password hash (which is used for
OS X versions >= 10.7).
* [`suffix`](#suffix): This function applies a suffix to all elements in an array, or to the keys
in a hash.
* [`swapcase`](#swapcase): This function will swap the existing case of a string.
* [`time`](#time): DEPRECATED.  Use the native Puppet fuctionality instead of this function. eg `Integer(Timestamp().strftime('%s'))`
* [`to_bytes`](#to_bytes): Converts the argument into bytes, for example 4 kB becomes 4096.
* [`to_json`](#to_json): DEPRECATED.  Use the namespaced function [`stdlib::to_json`](#stdlibto_json) instead.
* [`to_json_pretty`](#to_json_pretty): DEPRECATED.  Use the namespaced function [`stdlib::to_json_pretty`](#stdlibto_json_pretty) instead.
* [`to_python`](#to_python): DEPRECATED.  Use the namespaced function [`stdlib::to_python`](#stdlibto_python) instead.
* [`to_ruby`](#to_ruby): DEPRECATED.  Use the namespaced function [`stdlib::to_ruby`](#stdlibto_ruby) instead.
* [`to_toml`](#to_toml): DEPRECATED.  Use the namespaced function [`stdlib::to_toml`](#stdlibto_toml) instead.
* [`to_yaml`](#to_yaml): DEPRECATED.  Use the namespaced function [`stdlib::to_yaml`](#stdlibto_yaml) instead.
* [`type_of`](#type_of): DEPRECATED.  Use the namespaced function [`stdlib::type_of`](#stdlibtype_of) instead.
* [`union`](#union): This function returns a union of two or more arrays.
* [`unix2dos`](#unix2dos): Returns the DOS version of the given string.
* [`uriescape`](#uriescape): Urlencodes a string or array of strings.
Requires either a single string or an array as an input.
* [`validate_augeas`](#validate_augeas): Perform validation of a string using an Augeas lens
* [`validate_cmd`](#validate_cmd): Perform validation of a string with an external command.
* [`validate_domain_name`](#validate_domain_name): DEPRECATED.  Use the namespaced function [`stdlib::validate_domain_name`](#stdlibvalidate_domain_name) instead.
* [`validate_email_address`](#validate_email_address): DEPRECATED.  Use the namespaced function [`stdlib::validate_email_address`](#stdlibvalidate_email_address) instead.
* [`validate_legacy`](#validate_legacy): **Deprecated:** Validate a value against both the target_type (new).
* [`validate_x509_rsa_key_pair`](#validate_x509_rsa_key_pair): Validates a PEM-formatted X.509 certificate and RSA private key using
OpenSSL.
* [`values_at`](#values_at): Finds value inside an array based on location.
* [`zip`](#zip): Takes one element from first array and merges corresponding elements from second array.

### Data types

* [`Stdlib::Absolutepath`](#Stdlib--Absolutepath): A strict absolutepath type
* [`Stdlib::Base32`](#Stdlib--Base32): Type to match base32 String
* [`Stdlib::Base64`](#Stdlib--Base64): Type to match base64 String
* [`Stdlib::CreateResources`](#Stdlib--CreateResources): A type description used for the create_resources function
* [`Stdlib::Datasize`](#Stdlib--Datasize): Validate the size of data
* [`Stdlib::Dns::Zone`](#Stdlib--Dns--Zone): Validate a DNS zone name
* [`Stdlib::Email`](#Stdlib--Email): Validate an e-mail address
* [`Stdlib::Ensure::File`](#Stdlib--Ensure--File): Validate the value of the ensure parameter for a file
* [`Stdlib::Ensure::File::Directory`](#Stdlib--Ensure--File--Directory): Validate the ensure parameter of a "directory" file resource
* [`Stdlib::Ensure::File::File`](#Stdlib--Ensure--File--File): Validate the ensure parameter of a "file" file resource
* [`Stdlib::Ensure::File::Link`](#Stdlib--Ensure--File--Link): Validate the ensure parameter of a "link" file resource
* [`Stdlib::Ensure::Package`](#Stdlib--Ensure--Package): Validate the value of the ensure parameter for a package
* [`Stdlib::Ensure::Service`](#Stdlib--Ensure--Service): Validate the value of the ensure parameter of a service resource
* [`Stdlib::Filemode`](#Stdlib--Filemode): Validate a file mode
* [`Stdlib::Filesource`](#Stdlib--Filesource): Validate the source parameter on file types
* [`Stdlib::Fqdn`](#Stdlib--Fqdn): Validate a Fully Qualified Domain Name
* [`Stdlib::HTTPSUrl`](#Stdlib--HTTPSUrl): Validate a HTTPS URL
* [`Stdlib::HTTPUrl`](#Stdlib--HTTPUrl): Validate a HTTP(S) URL
* [`Stdlib::Host`](#Stdlib--Host): Validate a host (FQDN or IP address)
* [`Stdlib::Http::Method`](#Stdlib--Http--Method): Valid HTTP method verbs
* [`Stdlib::Http::Status`](#Stdlib--Http--Status): A valid HTTP status code per RFC9110
* [`Stdlib::HttpStatus`](#Stdlib--HttpStatus): Validate a HTTP status code
* [`Stdlib::IP::Address`](#Stdlib--IP--Address): Validate an IP address
* [`Stdlib::IP::Address::CIDR`](#Stdlib--IP--Address--CIDR): Validate an IP address with subnet
* [`Stdlib::IP::Address::Nosubnet`](#Stdlib--IP--Address--Nosubnet): Validate an IP address without subnet
* [`Stdlib::IP::Address::V4`](#Stdlib--IP--Address--V4): Validate an IPv4 address
* [`Stdlib::IP::Address::V4::CIDR`](#Stdlib--IP--Address--V4--CIDR): lint:ignore:140chars
* [`Stdlib::IP::Address::V4::Nosubnet`](#Stdlib--IP--Address--V4--Nosubnet): lint:ignore:140chars
* [`Stdlib::IP::Address::V6`](#Stdlib--IP--Address--V6): Validate an IPv6 address
* [`Stdlib::IP::Address::V6::Alternative`](#Stdlib--IP--Address--V6--Alternative): lint:ignore:140chars
* [`Stdlib::IP::Address::V6::CIDR`](#Stdlib--IP--Address--V6--CIDR): lint:ignore:140chars
* [`Stdlib::IP::Address::V6::Compressed`](#Stdlib--IP--Address--V6--Compressed): Validate a compressed IPv6 address
* [`Stdlib::IP::Address::V6::Full`](#Stdlib--IP--Address--V6--Full): Validate a full IPv6 address
* [`Stdlib::IP::Address::V6::Nosubnet`](#Stdlib--IP--Address--V6--Nosubnet): Validate an IPv6 address without subnet
* [`Stdlib::IP::Address::V6::Nosubnet::Alternative`](#Stdlib--IP--Address--V6--Nosubnet--Alternative): lint:ignore:140chars
* [`Stdlib::IP::Address::V6::Nosubnet::Compressed`](#Stdlib--IP--Address--V6--Nosubnet--Compressed): Validate compressed IPv6 address without subnet
* [`Stdlib::IP::Address::V6::Nosubnet::Full`](#Stdlib--IP--Address--V6--Nosubnet--Full): Validate full IPv6 address without subnet
* [`Stdlib::MAC`](#Stdlib--MAC): A type for a MAC address
* [`Stdlib::ObjectStore`](#Stdlib--ObjectStore): Validate an ObjectStore
* [`Stdlib::ObjectStore::GSUri`](#Stdlib--ObjectStore--GSUri): Validate a Google Cloud object store URI
* [`Stdlib::ObjectStore::S3Uri`](#Stdlib--ObjectStore--S3Uri): Validate an Amazon Web Services S3 object store URI
* [`Stdlib::Port`](#Stdlib--Port): Validate a port number
* [`Stdlib::Port::Dynamic`](#Stdlib--Port--Dynamic): Validate a dynamic port number
* [`Stdlib::Port::Ephemeral`](#Stdlib--Port--Ephemeral): Validate an ephemeral port number
* [`Stdlib::Port::Privileged`](#Stdlib--Port--Privileged): Validate a priviliged port number
* [`Stdlib::Port::Registered`](#Stdlib--Port--Registered): Validate a registered port number
* [`Stdlib::Port::Unprivileged`](#Stdlib--Port--Unprivileged): Validate an unprivileged port number
* [`Stdlib::Port::User`](#Stdlib--Port--User): Validate a port number usable by a user
* [`Stdlib::Syslogfacility`](#Stdlib--Syslogfacility): Validate a syslog facility
* [`Stdlib::Unixpath`](#Stdlib--Unixpath): Validate a UNIX path
* [`Stdlib::Windowspath`](#Stdlib--Windowspath): Validate a Windows path
* [`Stdlib::Yes_no`](#Stdlib--Yes_no): Validate a yes / no value

## Classes

### <a name="stdlib"></a>`stdlib`

Most of stdlib's features are automatically loaded by Puppet, but this class should be
declared in order to use the standardized run stages.

Declares all other classes in the stdlib module. Currently, this consists
of stdlib::stages and stdlib::manage.

### <a name="stdlib--manage"></a>`stdlib::manage`

Sometimes your systems require a single simple resource.
It can feel unnecessary to create a module for a single
resource.  There are a number of possible patterns to
generate trivial resource definitions.  This is an attempt
to create a single clear method for uncomplicated resources.
There is __limited__ support for `before`, `require`, `notify`,
and `subscribe`.

#### Examples

##### 

```puppet
class { 'stdlib::manage':
  'create_resources'      => {
    'file'                => {
      '/etc/motd.d/hello' => {
        'content'         => 'I say Hi',
        'notify'          => 'Service[sshd]',
      },
      '/etc/motd'         => {
        'ensure'          => 'file',
        'epp'             => {
          'template'      => 'profile/motd.epp',
        }
      },
      '/etc/information'  => {
        'ensure'          => 'file',
        'erb'             => {
          'template'      => 'profile/informaiton.erb',
        }
      }
    },
    'package'             => {
      'example'           => {
        'ensure'          => 'installed',
        'subscribe'       => ['Service[sshd]', 'Exec[something]'],
      }
    }
  }
}
```

##### 

```puppet
stdlib::manage::create_resources:
  file:
    '/etc/motd.d/hello':
      content: I say Hi
      notify: 'Service[sshd]'
    '/etc/motd':
      ensure: 'file'
      epp:
        template: 'profile/motd.epp'
        context: {}
    '/etc/information':
      ensure: 'file'
      erb:
        template: 'profile/information.erb'
  package:
    example:
      ensure: installed
      subscribe:
        - 'Service[sshd]'
        - 'Exec[something]'
```

#### Parameters

The following parameters are available in the `stdlib::manage` class:

* [`create_resources`](#-stdlib--manage--create_resources)

##### <a name="-stdlib--manage--create_resources"></a>`create_resources`

Data type: `Hash[String, Hash]`

A hash of resources to create
NOTE: functions, such as `template` or `epp`, are not directly evaluated
      but processed as Puppet code based on epp and erb hash keys.

Default value: `{}`

### <a name="stdlib--stages"></a>`stdlib::stages`

Declares various run-stages for deploying infrastructure,
language runtimes, and application layers.

The high level stages are (in order):
 * setup
 * main
 * runtime
 * setup_infra
 * deploy_infra
 * setup_app
 * deploy_app
 * deploy

#### Examples

##### 

```puppet
node default {
  include ::stdlib
  class { java: stage => 'runtime' }
}
```

## Resource types

### <a name="anchor"></a>`anchor`

> Note: this has been replaced by core puppet `contain()` method. Please see https://puppet.com/docs/puppet/latest/lang_containment.html for more information.

In Puppet 2.6, when a class declares another class, the resources in the
interior class are not contained by the exterior class. This interacts badly
with the pattern of composing complex modules from smaller classes, as it
makes it impossible for end users to specify order relationships between the
exterior class and other modules.

The anchor type lets you work around this. By sandwiching any interior
classes between two no-op resources that _are_ contained by the exterior
class, you can ensure that all resources in the module are contained.

```
class ntp {
  # These classes will have the correct order relationship with each
  # other. However, without anchors, they won't have any order
  # relationship to Class['ntp'].
  class { 'ntp::package': }
  -> class { 'ntp::config': }
  -> class { 'ntp::service': }

  # These two resources "anchor" the composed classes within the ntp
  # class.
  anchor { 'ntp::begin': } -> Class['ntp::package']
  Class['ntp::service']    -> anchor { 'ntp::end': }
}
```

This allows the end user of the ntp module to establish require and before
relationships with Class['ntp']:

```
class { 'ntp': } -> class { 'mcollective': }
class { 'mcollective': } -> class { 'ntp': }
```

#### Parameters

The following parameters are available in the `anchor` type.

* [`name`](#-anchor--name)

##### <a name="-anchor--name"></a>`name`

namevar

The name of the anchor resource.

### <a name="file_line"></a>`file_line`

The implementation matches the full line, including whitespace at the
beginning and end.  If the line is not contained in the given file, Puppet
will append the line to the end of the file to ensure the desired state.
Multiple resources may be declared to manage multiple lines in the same file.

* Ensure Example
```
file_line { 'sudo_rule':
  path => '/etc/sudoers',
  line => '%sudo ALL=(ALL) ALL',
}

file_line { 'sudo_rule_nopw':
  path => '/etc/sudoers',
  line => '%sudonopw ALL=(ALL) NOPASSWD: ALL',
}
```
In this example, Puppet will ensure both of the specified lines are
contained in the file /etc/sudoers.

* Match Example

```
file_line { 'bashrc_proxy':
  ensure => present,
  path   => '/etc/bashrc',
  line   => 'export HTTP_PROXY=http://squid.puppetlabs.vm:3128',
  match  => '^export HTTP_PROXY=',
}
```

In this code example match will look for a line beginning with export
followed by HTTP_PROXY and replace it with the value in line.

* Examples With `ensure => absent`:

This type has two behaviors when `ensure => absent` is set.

One possibility is to set `match => ...` and `match_for_absence => true`,
as in the following example:

```
file_line { 'bashrc_proxy':
  ensure            => absent,
  path              => '/etc/bashrc',
  match             => '^export HTTP_PROXY=',
  match_for_absence => true,
}
```

In this code example match will look for a line beginning with export
followed by HTTP_PROXY and delete it.  If multiple lines match, an
error will be raised unless the `multiple => true` parameter is set.

Note that the `line => ...` parameter would be accepted BUT IGNORED in
the above example.

The second way of using `ensure => absent` is to specify a `line => ...`,
and no match:

```
file_line { 'bashrc_proxy':
  ensure => absent,
  path   => '/etc/bashrc',
  line   => 'export HTTP_PROXY=http://squid.puppetlabs.vm:3128',
}
```

> *Note:*
When ensuring lines are absent this way, the default behavior
this time is to always remove all lines matching, and this behavior
can't be disabled.

* Encoding example:

```
file_line { "XScreenSaver":
  ensure   => present,
  path     => '/root/XScreenSaver',
  line     => "*lock: 10:00:00",
  match    => '^*lock:',
  encoding => "iso-8859-1",
}
```

Files with special characters that are not valid UTF-8 will give the
error message "invalid byte sequence in UTF-8".  In this case, determine
the correct file encoding and specify the correct encoding using the
encoding attribute, the value of which needs to be a valid Ruby character
encoding.

**Autorequires:** If Puppet is managing the file that will contain the line
being managed, the file_line resource will autorequire that file.

#### Properties

The following properties are available in the `file_line` type.

##### `ensure`

Valid values: `present`, `absent`

Manage the state of this type.

Default value: `present`

##### `line`

The line to be appended to the file or used to replace matches found by the match attribute.

#### Parameters

The following parameters are available in the `file_line` type.

* [`after`](#-file_line--after)
* [`append_on_no_match`](#-file_line--append_on_no_match)
* [`encoding`](#-file_line--encoding)
* [`match`](#-file_line--match)
* [`match_for_absence`](#-file_line--match_for_absence)
* [`multiple`](#-file_line--multiple)
* [`name`](#-file_line--name)
* [`path`](#-file_line--path)
* [`provider`](#-file_line--provider)
* [`replace`](#-file_line--replace)
* [`replace_all_matches_not_matching_line`](#-file_line--replace_all_matches_not_matching_line)

##### <a name="-file_line--after"></a>`after`

An optional value used to specify the line after which we will add any new lines. (Existing lines are added in place)
This is also takes a regex.

##### <a name="-file_line--append_on_no_match"></a>`append_on_no_match`

Valid values: `true`, `false`

If true, append line if match is not found. If false, do not append line if a match is not found

Default value: `true`

##### <a name="-file_line--encoding"></a>`encoding`

For files that are not UTF-8 encoded, specify encoding such as iso-8859-1

Default value: `UTF-8`

##### <a name="-file_line--match"></a>`match`

An optional ruby regular expression to run against existing lines in the file.
If a match is found, we replace that line rather than adding a new line.
A regex comparison is performed against the line value and if it does not
match an exception will be raised.

##### <a name="-file_line--match_for_absence"></a>`match_for_absence`

Valid values: `true`, `false`

An optional value to determine if match should be applied when ensure => absent.
If set to true and match is set, the line that matches match will be deleted.
If set to false (the default), match is ignored when ensure => absent.
When `ensure => present`, match_for_absence is ignored.

Default value: `false`

##### <a name="-file_line--multiple"></a>`multiple`

Valid values: `true`, `false`

An optional value to determine if match can change multiple lines.
If set to false, an exception will be raised if more than one line matches

##### <a name="-file_line--name"></a>`name`

namevar

An arbitrary name used as the identity of the resource.

##### <a name="-file_line--path"></a>`path`

The file Puppet will ensure contains the line specified by the line parameter.

##### <a name="-file_line--provider"></a>`provider`

The specific backend to use for this `file_line` resource. You will seldom need to specify this --- Puppet will usually
discover the appropriate provider for your platform.

##### <a name="-file_line--replace"></a>`replace`

Valid values: `true`, `false`

If true, replace line that matches. If false, do not write line if a match is found

Default value: `true`

##### <a name="-file_line--replace_all_matches_not_matching_line"></a>`replace_all_matches_not_matching_line`

Valid values: `true`, `false`

Configures the behavior of replacing all lines in a file which match the `match` parameter regular expression,
regardless of whether the specified line is already present in the file.

Default value: `false`

## Functions

### <a name="any2array"></a>`any2array`

Type: Ruby 3.x API

Empty argument lists are converted to an empty array. Arrays are left
untouched. Hashes are converted to arrays of alternating keys and values.

> *Note:*
  since Puppet 5.0.0 it is possible to create new data types for almost any
  datatype using the type system and the built-in
  [`Array.new`](https://puppet.com/docs/puppet/latest/function.html#conversion-to-array-and-tuple)
  function is used to create a new Array..

  ```
  $hsh = {'key' => 42, 'another-key' => 100}
  notice(Array($hsh))
  ```

Would notice `[['key', 42], ['another-key', 100]]`

The Array data type also has a special mode to "create an array if not already an array"

  ```
  notice(Array({'key' => 42, 'another-key' => 100}, true))
  ```

Would notice `[{'key' => 42, 'another-key' => 100}]`, as the `true` flag prevents the hash from being
transformed into an array.

#### `any2array()`

Empty argument lists are converted to an empty array. Arrays are left
untouched. Hashes are converted to arrays of alternating keys and values.

> *Note:*
  since Puppet 5.0.0 it is possible to create new data types for almost any
  datatype using the type system and the built-in
  [`Array.new`](https://puppet.com/docs/puppet/latest/function.html#conversion-to-array-and-tuple)
  function is used to create a new Array..

  ```
  $hsh = {'key' => 42, 'another-key' => 100}
  notice(Array($hsh))
  ```

Would notice `[['key', 42], ['another-key', 100]]`

The Array data type also has a special mode to "create an array if not already an array"

  ```
  notice(Array({'key' => 42, 'another-key' => 100}, true))
  ```

Would notice `[{'key' => 42, 'another-key' => 100}]`, as the `true` flag prevents the hash from being
transformed into an array.

Returns: `Array` The new array containing the given object

### <a name="any2bool"></a>`any2bool`

Type: Ruby 3.x API

In practise it does the following:
* Strings such as Y,y,1,T,t,TRUE,yes,'true' will return true
* Strings such as 0,F,f,N,n,FALSE,no,'false' will return false
* Booleans will just return their original value
* Number (or a string representation of a number) > 0 will return true, otherwise false
* undef will return false
* Anything else will return true

Also see the built-in [`Boolean.new`](https://puppet.com/docs/puppet/latest/function.html#conversion-to-boolean)
function.

#### `any2bool()`

In practise it does the following:
* Strings such as Y,y,1,T,t,TRUE,yes,'true' will return true
* Strings such as 0,F,f,N,n,FALSE,no,'false' will return false
* Booleans will just return their original value
* Number (or a string representation of a number) > 0 will return true, otherwise false
* undef will return false
* Anything else will return true

Also see the built-in [`Boolean.new`](https://puppet.com/docs/puppet/latest/function.html#conversion-to-boolean)
function.

Returns: `Boolean` The boolean value of the object that was given

### <a name="assert_private"></a>`assert_private`

Type: Ruby 3.x API

Calling the class or definition from outside the current module will fail.

#### `assert_private()`

Calling the class or definition from outside the current module will fail.

Returns: `Any` set the current class or definition as private.

### <a name="base64"></a>`base64`

Type: Ruby 3.x API

> **Note:*
    Since Puppet 4.8.0, the Binary data type can be used to produce base 64 encoded strings.
    See the `new()` function for the Binary and String types for documentation. Also see `binary_file()`
    function for reading a file with binary (non UTF-8) content.

#### Examples

##### Example usage

```puppet

Encode and decode a string

  $encodestring = base64('encode', 'thestring')
  $decodestring = base64('decode', 'dGhlc3RyaW5n')

Explicitly define encode/decode method: default, strict, urlsafe

  $method = 'default'
  $encodestring = base64('encode', 'thestring', $method)
  $decodestring = base64('decode', 'dGhlc3RyaW5n', $method)

Encode a string as if it was binary

 $encodestring = String(Binary('thestring', '%s'))

Decode a Binary assuming it is an UTF-8 String

 $decodestring = String(Binary("dGhlc3RyaW5n"), "%s")
```

#### `base64()`

> **Note:*
    Since Puppet 4.8.0, the Binary data type can be used to produce base 64 encoded strings.
    See the `new()` function for the Binary and String types for documentation. Also see `binary_file()`
    function for reading a file with binary (non UTF-8) content.

Returns: `String` The encoded/decoded

##### Examples

###### Example usage

```puppet

Encode and decode a string

  $encodestring = base64('encode', 'thestring')
  $decodestring = base64('decode', 'dGhlc3RyaW5n')

Explicitly define encode/decode method: default, strict, urlsafe

  $method = 'default'
  $encodestring = base64('encode', 'thestring', $method)
  $decodestring = base64('decode', 'dGhlc3RyaW5n', $method)

Encode a string as if it was binary

 $encodestring = String(Binary('thestring', '%s'))

Decode a Binary assuming it is an UTF-8 String

 $decodestring = String(Binary("dGhlc3RyaW5n"), "%s")
```

### <a name="basename"></a>`basename`

Type: Ruby 3.x API

Strips directory (and optional suffix) from a filename

#### `basename()`

The basename function.

Returns: `String` The stripped filename

### <a name="batch_escape"></a>`batch_escape`

Type: Ruby 4.x API

DEPRECATED.  Use the namespaced function [`stdlib::batch_escape`](#stdlibbatch_escape) instead.

#### `batch_escape(Any *$args)`

The batch_escape function.

Returns: `Any`

##### `*args`

Data type: `Any`



### <a name="bool2num"></a>`bool2num`

Type: Ruby 3.x API

Converts the values:
  ```
  false, f, 0, n, and no to 0
  true, t, 1, y, and yes to 1
  ```
Requires a single boolean or string as an input.

> *Note:*
  since Puppet 5.0.0 it is possible to create new data types for almost any
  datatype using the type system and the built-in
  [`Numeric.new`](https://puppet.com/docs/puppet/latest/function.html#conversion-to-numeric),
  [`Integer.new`](https://puppet.com/docs/puppet/latest/function.html#conversion-to-integer), and
  [`Float.new`](https://puppet.com/docs/puppet/latest/function.html#conversion-to-float)
  function are used to convert to numeric values.
  ```
  notice(Integer(false)) # Notices 0
  notice(Float(true))    # Notices 1.0
  ```

#### `bool2num()`

Converts the values:
  ```
  false, f, 0, n, and no to 0
  true, t, 1, y, and yes to 1
  ```
Requires a single boolean or string as an input.

> *Note:*
  since Puppet 5.0.0 it is possible to create new data types for almost any
  datatype using the type system and the built-in
  [`Numeric.new`](https://puppet.com/docs/puppet/latest/function.html#conversion-to-numeric),
  [`Integer.new`](https://puppet.com/docs/puppet/latest/function.html#conversion-to-integer), and
  [`Float.new`](https://puppet.com/docs/puppet/latest/function.html#conversion-to-float)
  function are used to convert to numeric values.
  ```
  notice(Integer(false)) # Notices 0
  notice(Float(true))    # Notices 1.0
  ```

Returns: `Integer` The converted value as a number

### <a name="bool2str"></a>`bool2str`

Type: Ruby 3.x API

The optional second and third arguments represent what true and false will be
converted to respectively. If only one argument is given, it will be
converted from a boolean to a string containing 'true' or 'false'.

**Examples of usage**

  ```
    bool2str(true)                    => 'true'
    bool2str(true, 'yes', 'no')       => 'yes'
    bool2str(false, 't', 'f')         => 'f'
  ```

Requires a single boolean as an input.

> *Note:*
  since Puppet 5.0.0 it is possible to create new data types for almost any
  datatype using the type system and the built-in
  [`String.new`](https://puppet.com/docs/puppet/latest/function.html#boolean-to-string)
  function is used to convert to String with many different format options.

  ```
    notice(String(false))         # Notices 'false'
    notice(String(true))          # Notices 'true'
    notice(String(false, '%y'))   # Notices 'yes'
    notice(String(true, '%y'))    # Notices 'no'
  ```

#### `bool2str()`

The optional second and third arguments represent what true and false will be
converted to respectively. If only one argument is given, it will be
converted from a boolean to a string containing 'true' or 'false'.

**Examples of usage**

  ```
    bool2str(true)                    => 'true'
    bool2str(true, 'yes', 'no')       => 'yes'
    bool2str(false, 't', 'f')         => 'f'
  ```

Requires a single boolean as an input.

> *Note:*
  since Puppet 5.0.0 it is possible to create new data types for almost any
  datatype using the type system and the built-in
  [`String.new`](https://puppet.com/docs/puppet/latest/function.html#boolean-to-string)
  function is used to convert to String with many different format options.

  ```
    notice(String(false))         # Notices 'false'
    notice(String(true))          # Notices 'true'
    notice(String(false, '%y'))   # Notices 'yes'
    notice(String(true, '%y'))    # Notices 'no'
  ```

Returns: `Any` The converted value to string of the given Boolean

### <a name="clamp"></a>`clamp`

Type: Ruby 3.x API

Strings are converted and compared numerically. Arrays of values are flattened
into a list for further handling.

> *Note:*
  From Puppet 6.0.0 this can be done with only core Puppet like this:
  `[$minval, $maxval, $value_to_clamp].sort[1]`

#### Examples

##### Example usage

```puppet

clamp('24', [575, 187])` returns 187.
clamp(16, 88, 661)` returns 88.
clamp([4, 3, '99'])` returns 4.
```

#### `clamp()`

Strings are converted and compared numerically. Arrays of values are flattened
into a list for further handling.

> *Note:*
  From Puppet 6.0.0 this can be done with only core Puppet like this:
  `[$minval, $maxval, $value_to_clamp].sort[1]`

Returns: `Array[Integer]` The sorted Array

##### Examples

###### Example usage

```puppet

clamp('24', [575, 187])` returns 187.
clamp(16, 88, 661)` returns 88.
clamp([4, 3, '99'])` returns 4.
```

### <a name="concat"></a>`concat`

Type: Ruby 3.x API

> *Note:*
  Since Puppet 4.0, you can use the `+`` operator for concatenation of arrays and
  merge of hashes, and the `<<`` operator for appending:

`['1','2','3'] + ['4','5','6'] + ['7','8','9']` returns `['1','2','3','4','5','6','7','8','9']`
`[1, 2, 3] << 4` returns `[1, 2, 3, 4]`
`[1, 2, 3] << [4, 5]` returns `[1, 2, 3, [4, 5]]`

#### Examples

##### Example usage

```puppet

concat(['1','2','3'],'4') returns ['1','2','3','4']
concat(['1','2','3'],'4',['5','6','7']) returns ['1','2','3','4','5','6','7']
```

#### `concat()`

> *Note:*
  Since Puppet 4.0, you can use the `+`` operator for concatenation of arrays and
  merge of hashes, and the `<<`` operator for appending:

`['1','2','3'] + ['4','5','6'] + ['7','8','9']` returns `['1','2','3','4','5','6','7','8','9']`
`[1, 2, 3] << 4` returns `[1, 2, 3, 4]`
`[1, 2, 3] << [4, 5]` returns `[1, 2, 3, [4, 5]]`

Returns: `Array` The single concatenated array

##### Examples

###### Example usage

```puppet

concat(['1','2','3'],'4') returns ['1','2','3','4']
concat(['1','2','3'],'4',['5','6','7']) returns ['1','2','3','4','5','6','7']
```

### <a name="convert_base"></a>`convert_base`

Type: Ruby 3.x API

convert_base(5, 2)` results in: `'101'`
convert_base('254', '16')` results in: `'fe'`

> *Note:*
  Since Puppet 4.5.0 this can be done with the built-in
  [`String.new`](https://puppet.com/docs/puppet/latest/function.html#integer-to-string)
  function and its many formatting options:

  `$binary_repr = String(5, '%b')` return `"101"`
  `$hex_repr = String(254, "%x")`  return `"fe"`
  `$hex_repr = String(254, "%#x")` return `"0xfe"`

  @return [String] The converted value as a S

#### Examples

##### Example usage

```puppet

```

#### `convert_base()`

convert_base(5, 2)` results in: `'101'`
convert_base('254', '16')` results in: `'fe'`

> *Note:*
  Since Puppet 4.5.0 this can be done with the built-in
  [`String.new`](https://puppet.com/docs/puppet/latest/function.html#integer-to-string)
  function and its many formatting options:

  `$binary_repr = String(5, '%b')` return `"101"`
  `$hex_repr = String(254, "%x")`  return `"fe"`
  `$hex_repr = String(254, "%#x")` return `"0xfe"`

  @return [String] The converted value as a S

Returns: `Any` converted value as a string

##### Examples

###### Example usage

```puppet

```

### <a name="count"></a>`count`

Type: Ruby 3.x API

Takes an array as first argument and an optional second argument. Counts the number of elements in array that is equal to the second argument.
If called with only an array, it counts the number of elements that are not nil/undef/empty-string.

> *Note:*
  equality is tested with a Ruby method and it is therefore subject to what Ruby considers
  to be equal. For strings this means that equality is case sensitive.

In Puppet core, counting can be done in general by using a combination of the core functions
filter() (since Puppet 4.0.0) and length() (since Puppet 5.5.0, before that in stdlib).

Example below shows counting values that are not undef.

  ```notice([42, "hello", undef].filter |$x| { $x =~ NotUndef }.length)```

Would notice the value 2.

#### `count()`

Takes an array as first argument and an optional second argument. Counts the number of elements in array that is equal to the second argument.
If called with only an array, it counts the number of elements that are not nil/undef/empty-string.

> *Note:*
  equality is tested with a Ruby method and it is therefore subject to what Ruby considers
  to be equal. For strings this means that equality is case sensitive.

In Puppet core, counting can be done in general by using a combination of the core functions
filter() (since Puppet 4.0.0) and length() (since Puppet 5.5.0, before that in stdlib).

Example below shows counting values that are not undef.

  ```notice([42, "hello", undef].filter |$x| { $x =~ NotUndef }.length)```

Would notice the value 2.

Returns: `Integer` The amount of elements counted within the array

### <a name="deep_merge"></a>`deep_merge`

Type: Ruby 3.x API

Recursively merges two or more hashes together and returns the resulting hash.

#### Examples

##### Example usage

```puppet

$hash1 = {'one' => 1, 'two' => 2, 'three' => { 'four' => 4 } }
$hash2 = {'two' => 'dos', 'three' => { 'five' => 5 } }
$merged_hash = deep_merge($hash1, $hash2)

The resulting hash is equivalent to:

$merged_hash = { 'one' => 1, 'two' => 'dos', 'three' => { 'four' => 4, 'five' => 5 } }

When there is a duplicate key that is a hash, they are recursively merged.
When there is a duplicate key that is not a hash, the key in the rightmost hash will "win."
```

#### `deep_merge()`

The deep_merge function.

Returns: `Hash` The merged

##### Examples

###### Example usage

```puppet

$hash1 = {'one' => 1, 'two' => 2, 'three' => { 'four' => 4 } }
$hash2 = {'two' => 'dos', 'three' => { 'five' => 5 } }
$merged_hash = deep_merge($hash1, $hash2)

The resulting hash is equivalent to:

$merged_hash = { 'one' => 1, 'two' => 'dos', 'three' => { 'four' => 4, 'five' => 5 } }

When there is a duplicate key that is a hash, they are recursively merged.
When there is a duplicate key that is not a hash, the key in the rightmost hash will "win."
```

### <a name="defined_with_params"></a>`defined_with_params`

Type: Ruby 3.x API

Returns `true` if a resource with the specified attributes has already been added
to the catalog, and `false` otherwise.

  ```
  user { 'dan':
    ensure => present,
  }

  if ! defined_with_params(User[dan], {'ensure' => 'present' }) {
    user { 'dan': ensure => present, }
  }
  ```

#### `defined_with_params()`

Returns `true` if a resource with the specified attributes has already been added
to the catalog, and `false` otherwise.

  ```
  user { 'dan':
    ensure => present,
  }

  if ! defined_with_params(User[dan], {'ensure' => 'present' }) {
    user { 'dan': ensure => present, }
  }
  ```

Returns: `Boolean` returns `true` or `false`

### <a name="delete"></a>`delete`

Type: Ruby 3.x API

> *Note:*
From Puppet 4.0.0 the minus (-) operator deletes values from arrays and keys from a hash
`{'a'=>1,'b'=>2,'c'=>3} - ['b','c'])`
>
A global delete from a string can be performed with the
[`regsubst`](https://puppet.com/docs/puppet/latest/function.html#regsubst) function:
`'abracadabra'.regsubst(/bra/, '', 'G')`

In general, the built-in [`filter`](https://puppet.com/docs/puppet/latest/function.html#filter)
function can filter out entries from arrays and hashes based on keys and/or values.

#### Examples

##### Example usage

```puppet

delete(['a','b','c','b'], 'b')
Would return: ['a','c']

delete({'a'=>1,'b'=>2,'c'=>3}, 'b')
Would return: {'a'=>1,'c'=>3}

delete({'a'=>1,'b'=>2,'c'=>3}, ['b','c'])
Would return: {'a'=>1}

delete('abracadabra', 'bra')
Would return: 'acada'

['a', 'b', 'c', 'b'] - 'b'
Would return: ['a', 'c']

{'a'=>1,'b'=>2,'c'=>3} - ['b','c'])
Would return: {'a' => '1'}

'abracadabra'.regsubst(/bra/, '', 'G')
Would return: 'acada'
```

#### `delete()`

> *Note:*
From Puppet 4.0.0 the minus (-) operator deletes values from arrays and keys from a hash
`{'a'=>1,'b'=>2,'c'=>3} - ['b','c'])`
>
A global delete from a string can be performed with the
[`regsubst`](https://puppet.com/docs/puppet/latest/function.html#regsubst) function:
`'abracadabra'.regsubst(/bra/, '', 'G')`

In general, the built-in [`filter`](https://puppet.com/docs/puppet/latest/function.html#filter)
function can filter out entries from arrays and hashes based on keys and/or values.

Returns: `String` The filtered String, if one was given.

##### Examples

###### Example usage

```puppet

delete(['a','b','c','b'], 'b')
Would return: ['a','c']

delete({'a'=>1,'b'=>2,'c'=>3}, 'b')
Would return: {'a'=>1,'c'=>3}

delete({'a'=>1,'b'=>2,'c'=>3}, ['b','c'])
Would return: {'a'=>1}

delete('abracadabra', 'bra')
Would return: 'acada'

['a', 'b', 'c', 'b'] - 'b'
Would return: ['a', 'c']

{'a'=>1,'b'=>2,'c'=>3} - ['b','c'])
Would return: {'a' => '1'}

'abracadabra'.regsubst(/bra/, '', 'G')
Would return: 'acada'
```

### <a name="delete_at"></a>`delete_at`

Type: Ruby 3.x API

For example
    ```delete_at(['a','b','c'], 1)```

Would return: `['a','c']`

> *Note:*
  Since Puppet 4 this can be done in general with the built-in
  [`filter`](https://puppet.com/docs/puppet/latest/function.html#filter) function:

  ```['a', 'b', 'c'].filter |$pos, $val | { $pos != 1 }```

Or if a delete is wanted from the beginning or end of the array, by using the slice operator [ ]:
  ```
  $array[0, -1] # the same as all the values
  $array[2, -1] # all but the first 2 elements
  $array[0, -3] # all but the last 2 elements
  $array[1, -2] # all but the first and last element
  ```

#### `delete_at()`

For example
    ```delete_at(['a','b','c'], 1)```

Would return: `['a','c']`

> *Note:*
  Since Puppet 4 this can be done in general with the built-in
  [`filter`](https://puppet.com/docs/puppet/latest/function.html#filter) function:

  ```['a', 'b', 'c'].filter |$pos, $val | { $pos != 1 }```

Or if a delete is wanted from the beginning or end of the array, by using the slice operator [ ]:
  ```
  $array[0, -1] # the same as all the values
  $array[2, -1] # all but the first 2 elements
  $array[0, -3] # all but the last 2 elements
  $array[1, -2] # all but the first and last element
  ```

Returns: `Array` The given array, now missing the tar

### <a name="delete_regex"></a>`delete_regex`

Type: Ruby 3.x API

Multiple regular expressions are assumed to be matched as an OR.

> *Note:*
Since Puppet 4 this can be done in general with the built-in
[`filter`](https://puppet.com/docs/puppet/latest/function.html#filter) function:
["aaa", "aba", "aca"].filter |$val| { $val !~ /b/ }
Would return: ['aaa', 'aca']

#### Examples

##### Example usage

```puppet

delete_regex(['a','b','c','b'], 'b')
Would return: ['a','c']

delete_regex(['a','b','c','b'], ['b', 'c'])
Would return: ['a']

delete_regex({'a'=>1,'b'=>2,'c'=>3}, 'b')
Would return: {'a'=>1,'c'=>3}

delete_regex({'a'=>1,'b'=>2,'c'=>3}, '^a$')
Would return: {'b'=>2,'c'=>3}
```

#### `delete_regex()`

Multiple regular expressions are assumed to be matched as an OR.

> *Note:*
Since Puppet 4 this can be done in general with the built-in
[`filter`](https://puppet.com/docs/puppet/latest/function.html#filter) function:
["aaa", "aba", "aca"].filter |$val| { $val !~ /b/ }
Would return: ['aaa', 'aca']

Returns: `Array` The given array now missing all targeted values.

##### Examples

###### Example usage

```puppet

delete_regex(['a','b','c','b'], 'b')
Would return: ['a','c']

delete_regex(['a','b','c','b'], ['b', 'c'])
Would return: ['a']

delete_regex({'a'=>1,'b'=>2,'c'=>3}, 'b')
Would return: {'a'=>1,'c'=>3}

delete_regex({'a'=>1,'b'=>2,'c'=>3}, '^a$')
Would return: {'b'=>2,'c'=>3}
```

### <a name="delete_undef_values"></a>`delete_undef_values`

Type: Ruby 3.x API

> *Note:*
Since Puppet 4.0.0 the equivalent can be performed with the built-in
[`filter`](https://puppet.com/docs/puppet/latest/function.html#filter) function:
$array.filter |$val| { $val =~ NotUndef }
$hash.filter |$key, $val| { $val =~ NotUndef }

#### Examples

##### Example usage

```puppet

$hash = delete_undef_values({a=>'A', b=>'', c=>undef, d => false})
Would return: {a => 'A', b => '', d => false}

While:
$array = delete_undef_values(['A','',undef,false])
Would return: ['A','',false]
```

#### `delete_undef_values()`

> *Note:*
Since Puppet 4.0.0 the equivalent can be performed with the built-in
[`filter`](https://puppet.com/docs/puppet/latest/function.html#filter) function:
$array.filter |$val| { $val =~ NotUndef }
$hash.filter |$key, $val| { $val =~ NotUndef }

Returns: `Array` The given array now issing of undefined values.

##### Examples

###### Example usage

```puppet

$hash = delete_undef_values({a=>'A', b=>'', c=>undef, d => false})
Would return: {a => 'A', b => '', d => false}

While:
$array = delete_undef_values(['A','',undef,false])
Would return: ['A','',false]
```

### <a name="delete_values"></a>`delete_values`

Type: Ruby 3.x API

> *Note:*
Since Puppet 4.0.0 the equivalent can be performed with the
built-in [`filter`](https://puppet.com/docs/puppet/latest/function.html#filter) function:
$array.filter |$val| { $val != 'B' }
$hash.filter |$key, $val| { $val != 'B' }

#### Examples

##### Example usage

```puppet

delete_values({'a'=>'A','b'=>'B','c'=>'C','B'=>'D'}, 'B')
Would return: {'a'=>'A','c'=>'C','B'=>'D'}
```

#### `delete_values()`

> *Note:*
Since Puppet 4.0.0 the equivalent can be performed with the
built-in [`filter`](https://puppet.com/docs/puppet/latest/function.html#filter) function:
$array.filter |$val| { $val != 'B' }
$hash.filter |$key, $val| { $val != 'B' }

Returns: `Hash` The given hash now missing all instances of the targeted value

##### Examples

###### Example usage

```puppet

delete_values({'a'=>'A','b'=>'B','c'=>'C','B'=>'D'}, 'B')
Would return: {'a'=>'A','c'=>'C','B'=>'D'}
```

### <a name="deprecation"></a>`deprecation`

Type: Ruby 4.x API

Function to print deprecation warnings, Logs a warning once for a given key.

#### `deprecation(String $key, String $message, Optional[Boolean] $use_strict_setting)`

The deprecation function.

Returns: `Any`

##### `key`

Data type: `String`

The uniqueness key.  This function logs once for any given key.

##### `message`

Data type: `String`

Is the message text including any positional information that is formatted by the user/caller of the function.

##### `use_strict_setting`

Data type: `Optional[Boolean]`

When `true`, (the default), the function is affected by the puppet setting 'strict', which can be set to :error
(outputs as an error message), :off (no message / error is displayed) and :warning
(default, outputs a warning).

### <a name="difference"></a>`difference`

Type: Ruby 3.x API

The returned array is a copy of the original array, removing any items that
also appear in the second array.

> *Note:*
Since Puppet 4 the minus (-) operator in the Puppet language does the same thing:
['a', 'b', 'c'] - ['b', 'c', 'd']
Would return: `['a']`

#### Examples

##### Example usage

```puppet

difference(["a","b","c"],["b","c","d"])
Would return: `["a"]`
```

#### `difference()`

The returned array is a copy of the original array, removing any items that
also appear in the second array.

> *Note:*
Since Puppet 4 the minus (-) operator in the Puppet language does the same thing:
['a', 'b', 'c'] - ['b', 'c', 'd']
Would return: `['a']`

Returns: `Array` The difference between the two given arrays

##### Examples

###### Example usage

```puppet

difference(["a","b","c"],["b","c","d"])
Would return: `["a"]`
```

### <a name="dirname"></a>`dirname`

Type: Ruby 3.x API

Returns the dirname of a path.

#### `dirname()`

The dirname function.

Returns: `String` the given path's dirname

### <a name="dos2unix"></a>`dos2unix`

Type: Ruby 3.x API

Takes a single string argument.

#### `dos2unix()`

Takes a single string argument.

Returns: `Any` The retrieved version

### <a name="enclose_ipv6"></a>`enclose_ipv6`

Type: Ruby 3.x API

Takes an array of ip addresses and encloses the ipv6 addresses with square brackets.

#### `enclose_ipv6()`

The enclose_ipv6 function.

Returns: `Any` encloses the ipv6 addresses with square brackets.

### <a name="ensure_packages"></a>`ensure_packages`

Type: Ruby 4.x API

DEPRECATED.  Use the namespaced function [`stdlib::ensure_packages`](#stdlibensure_packages) instead.

#### `ensure_packages(Any *$args)`

The ensure_packages function.

Returns: `Any`

##### `*args`

Data type: `Any`



### <a name="ensure_resource"></a>`ensure_resource`

Type: Ruby 3.x API

user { 'dan':
  ensure => present,
}

#### Examples

##### Example usage

```puppet

Creates the resource if it does not already exist:

  ensure_resource('user', 'dan', {'ensure' => 'present' })

If the resource already exists but does not match the specified parameters,
this function will attempt to recreate the resource leading to a duplicate
resource definition error.

An array of resources can also be passed in and each will be created with
the type and parameters specified if it doesn't already exist.

  ensure_resource('user', ['dan','alex'], {'ensure' => 'present'})
```

#### `ensure_resource()`

user { 'dan':
  ensure => present,
}

Returns: `Any` created or recreated the passed resource with the passed type and attributes

##### Examples

###### Example usage

```puppet

Creates the resource if it does not already exist:

  ensure_resource('user', 'dan', {'ensure' => 'present' })

If the resource already exists but does not match the specified parameters,
this function will attempt to recreate the resource leading to a duplicate
resource definition error.

An array of resources can also be passed in and each will be created with
the type and parameters specified if it doesn't already exist.

  ensure_resource('user', ['dan','alex'], {'ensure' => 'present'})
```

### <a name="ensure_resources"></a>`ensure_resources`

Type: Ruby 3.x API

An hash of resources should be passed in and each will be created with
  the type and parameters specified if it doesn't already exist.

  ensure_resources('user', {'dan' => { gid => 'mygroup', uid => '600' }, 'alex' => { gid => 'mygroup' }}, {'ensure' => 'present'})

  From Hiera Backend:

  userlist:
    dan:
      gid: 'mygroup'
   uid: '600'
    alex:
   gid: 'mygroup'

  Call:
  ensure_resources('user', hiera_hash('userlist'), {'ensure' => 'present'})

#### Examples

##### Example usage

```puppet

user { 'dan':
  gid => 'mygroup',
  ensure => present,
}
```

#### `ensure_resources()`

An hash of resources should be passed in and each will be created with
  the type and parameters specified if it doesn't already exist.

  ensure_resources('user', {'dan' => { gid => 'mygroup', uid => '600' }, 'alex' => { gid => 'mygroup' }}, {'ensure' => 'present'})

  From Hiera Backend:

  userlist:
    dan:
      gid: 'mygroup'
   uid: '600'
    alex:
   gid: 'mygroup'

  Call:
  ensure_resources('user', hiera_hash('userlist'), {'ensure' => 'present'})

Returns: `Any` created resources with the passed type and attributes

##### Examples

###### Example usage

```puppet

user { 'dan':
  gid => 'mygroup',
  ensure => present,
}
```

### <a name="fact"></a>`fact`

Type: Ruby 4.x API

Supports the use of dot-notation for referring to structured facts. If a fact requested
does not exist, returns Undef.

#### Examples

##### Example usage:

```puppet
fact('osfamily')
fact('os.architecture')
```

##### Array indexing:

```puppet
fact('mountpoints."/dev".options.1')
```

##### Fact containing a "." in the name:

```puppet
fact('vmware."VRA.version"')
```

#### `fact(String $fact_name)`

Supports the use of dot-notation for referring to structured facts. If a fact requested
does not exist, returns Undef.

Returns: `Any` All information retrieved on the given fact_name

##### Examples

###### Example usage:

```puppet
fact('osfamily')
fact('os.architecture')
```

###### Array indexing:

```puppet
fact('mountpoints."/dev".options.1')
```

###### Fact containing a "." in the name:

```puppet
fact('vmware."VRA.version"')
```

##### `fact_name`

Data type: `String`

The name of the fact to check

### <a name="fqdn_rand_string"></a>`fqdn_rand_string`

Type: Ruby 4.x API

DEPRECATED.  Use the namespaced function [`stdlib::fqdn_rand_string`](#stdlibfqdn_rand_string) instead.

#### `fqdn_rand_string(Any *$args)`

The fqdn_rand_string function.

Returns: `Any`

##### `*args`

Data type: `Any`



### <a name="fqdn_rotate"></a>`fqdn_rotate`

Type: Ruby 4.x API

DEPRECATED.  Use the namespaced function [`stdlib::fqdn_rotate`](#stdlibfqdn_rotate) instead.

#### `fqdn_rotate(Any *$args)`

The fqdn_rotate function.

Returns: `Any`

##### `*args`

Data type: `Any`



### <a name="fqdn_uuid"></a>`fqdn_uuid`

Type: Ruby 3.x API

Returns a [RFC 4122](https://tools.ietf.org/html/rfc4122) valid version 5 UUID based
on an FQDN string under the DNS namespace

#### Examples

##### Example Usage:

```puppet
fqdn_uuid('puppetlabs.com') # Returns '9c70320f-6815-5fc5-ab0f-debe68bf764c'
fqdn_uuid('google.com') # Returns '64ee70a4-8cc1-5d25-abf2-dea6c79a
```

#### `fqdn_uuid()`

The fqdn_uuid function.

Returns: `Any` Returns a [RFC 4122](https://tools.ietf.org/html/rfc4122) valid version 5 UUID

##### Examples

###### Example Usage:

```puppet
fqdn_uuid('puppetlabs.com') # Returns '9c70320f-6815-5fc5-ab0f-debe68bf764c'
fqdn_uuid('google.com') # Returns '64ee70a4-8cc1-5d25-abf2-dea6c79a
```

### <a name="get_module_path"></a>`get_module_path`

Type: Ruby 3.x API

> *Note:*
  that since Puppet 5.4.0 the  built-in
  [`module_directory`](https://puppet.com/docs/puppet/latest/function.html#module_directory)
  function in Puppet does the same thing and will return the path to the first found module
  if given multiple values or an array.

#### Examples

##### Example Usage:

```puppet
$module_path = get_module_path('stdlib')
```

#### `get_module_path()`

> *Note:*
  that since Puppet 5.4.0 the  built-in
  [`module_directory`](https://puppet.com/docs/puppet/latest/function.html#module_directory)
  function in Puppet does the same thing and will return the path to the first found module
  if given multiple values or an array.

Returns: `Any` Returns the absolute path of the specified module for the current
environment.

##### Examples

###### Example Usage:

```puppet
$module_path = get_module_path('stdlib')
```

### <a name="getparam"></a>`getparam`

Type: Ruby 3.x API

Takes a resource reference and name of the parameter and
returns value of resource's parameter. Note that user defined
resource types are evaluated lazily.

Would notice: 'the value we are getting in this example'

> **Note** that since Puppet 4.0.0 it is possible to get a parameter value by using its data type
and the [ ] operator. The example below is equivalent to a call to getparam():
  ```Example_resource['example_resource_instance']['param']``

#### Examples

##### Example Usage:

```puppet

# define a resource type with a parameter
define example_resource($param) {
}

# declare an instance of that type
example_resource { "example_resource_instance":
    param => "'the value we are getting in this example''"
}

# Because of order of evaluation, a second definition is needed
# that will be evaluated after the first resource has been declared
#
define example_get_param {
  # This will notice the value of the parameter
  notice(getparam(Example_resource["example_resource_instance"], "param"))
}

# Declare an instance of the second resource type - this will call notice
example_get_param { 'show_notify': }
```

#### `getparam()`

Takes a resource reference and name of the parameter and
returns value of resource's parameter. Note that user defined
resource types are evaluated lazily.

Would notice: 'the value we are getting in this example'

> **Note** that since Puppet 4.0.0 it is possible to get a parameter value by using its data type
and the [ ] operator. The example below is equivalent to a call to getparam():
  ```Example_resource['example_resource_instance']['param']``

Returns: `Any` value of a resource's parameter.

##### Examples

###### Example Usage:

```puppet

# define a resource type with a parameter
define example_resource($param) {
}

# declare an instance of that type
example_resource { "example_resource_instance":
    param => "'the value we are getting in this example''"
}

# Because of order of evaluation, a second definition is needed
# that will be evaluated after the first resource has been declared
#
define example_get_param {
  # This will notice the value of the parameter
  notice(getparam(Example_resource["example_resource_instance"], "param"))
}

# Declare an instance of the second resource type - this will call notice
example_get_param { 'show_notify': }
```

### <a name="glob"></a>`glob`

Type: Ruby 3.x API

Uses same patterns as Dir#glob.

#### Examples

##### Example Usage:

```puppet
$confs = glob(['/etc/**/*.conf', '/opt/**/*.conf'])
```

#### `glob()`

The glob function.

Returns: `Any` Returns an Array of file entries of a directory or an Array of directories.

##### Examples

###### Example Usage:

```puppet
$confs = glob(['/etc/**/*.conf', '/opt/**/*.conf'])
```

### <a name="grep"></a>`grep`

Type: Ruby 3.x API

> **Note:** that since Puppet 4.0.0, the built-in
[`filter`](https://puppet.com/docs/puppet/latest/function.html#filter) function does
the "same" - as any logic can be used to filter, as opposed to just regular expressions:
```['aaa', 'bbb', 'ccc', 'aaaddd']. filter |$x| { $x =~ 'aaa' }```

#### Examples

##### Example Usage:

```puppet
grep(['aaa','bbb','ccc','aaaddd'], 'aaa') # Returns ['aaa','aaaddd']
```

#### `grep()`

> **Note:** that since Puppet 4.0.0, the built-in
[`filter`](https://puppet.com/docs/puppet/latest/function.html#filter) function does
the "same" - as any logic can be used to filter, as opposed to just regular expressions:
```['aaa', 'bbb', 'ccc', 'aaaddd']. filter |$x| { $x =~ 'aaa' }```

Returns: `Any` array of elements that match the provided regular expression.

##### Examples

###### Example Usage:

```puppet
grep(['aaa','bbb','ccc','aaaddd'], 'aaa') # Returns ['aaa','aaaddd']
```

### <a name="has_interface_with"></a>`has_interface_with`

Type: Ruby 4.x API

DEPRECATED.  Use the namespaced function [`stdlib::has_interface_with`](#stdlibhas_interface_with) instead.

#### `has_interface_with(Any *$args)`

The has_interface_with function.

Returns: `Any`

##### `*args`

Data type: `Any`



### <a name="has_interface_with"></a>`has_interface_with`

Type: Ruby 3.x API

Valid kinds are `macaddress`, `netmask`, `ipaddress` and `network`.

#### Examples

##### **Usage**

```puppet
has_interface_with("macaddress", "x:x:x:x:x:x") # Returns `false`
has_interface_with("ipaddress", "127.0.0.1") # Returns `true`
```

##### If no "kind" is given, then the presence of the interface is checked:

```puppet
has_interface_with("lo") # Returns `true`
```

#### `has_interface_with()`

Valid kinds are `macaddress`, `netmask`, `ipaddress` and `network`.

Returns: `Any` boolean values `true` or `false`

##### Examples

###### **Usage**

```puppet
has_interface_with("macaddress", "x:x:x:x:x:x") # Returns `false`
has_interface_with("ipaddress", "127.0.0.1") # Returns `true`
```

###### If no "kind" is given, then the presence of the interface is checked:

```puppet
has_interface_with("lo") # Returns `true`
```

### <a name="has_ip_address"></a>`has_ip_address`

Type: Ruby 3.x API

This function iterates through the 'interfaces' fact and checks the
'ipaddress_IFACE' facts, performing a simple string comparison.

#### `has_ip_address()`

This function iterates through the 'interfaces' fact and checks the
'ipaddress_IFACE' facts, performing a simple string comparison.

Returns: `Boolean` `true` or `false`

### <a name="has_ip_network"></a>`has_ip_network`

Type: Ruby 3.x API

This function iterates through the 'interfaces' fact and checks the
'network_IFACE' facts, performing a simple string comparision.

#### `has_ip_network()`

This function iterates through the 'interfaces' fact and checks the
'network_IFACE' facts, performing a simple string comparision.

Returns: `Any` Boolean value, `true` if the client has an IP address within the requested network.

### <a name="intersection"></a>`intersection`

Type: Ruby 3.x API

This function returns an array of the intersection of two.

#### Examples

##### Example Usage:

```puppet
intersection(["a","b","c"],["b","c","d"])  # returns ["b","c"]
intersection(["a","b","c"],[1,2,3,4])      # returns [] (true, when evaluated as a Boolean)
```

#### `intersection()`

The intersection function.

Returns: `Any` an array of the intersection of two.

##### Examples

###### Example Usage:

```puppet
intersection(["a","b","c"],["b","c","d"])  # returns ["b","c"]
intersection(["a","b","c"],[1,2,3,4])      # returns [] (true, when evaluated as a Boolean)
```

### <a name="is_a"></a>`is_a`

Type: Ruby 4.x API

See the documentation for "The Puppet Type System" for more information about types.
See the `assert_type()` function for flexible ways to assert the type of a value.

#### Examples

##### Example Usage:

```puppet
# check a data type
  foo = 3
  $bar = [1,2,3]
  $baz = 'A string!'

  if $foo.is_a(Integer) {
    notify  { 'foo!': }
  }
  if $bar.is_a(Array) {
    notify { 'bar!': }
  }
  if $baz.is_a(String) {
    notify { 'baz!': }
  }
```

#### `is_a(Any $value, Type $type)`

See the documentation for "The Puppet Type System" for more information about types.
See the `assert_type()` function for flexible ways to assert the type of a value.

Returns: `Boolean` Return's `true` or `false`.

##### Examples

###### Example Usage:

```puppet
# check a data type
  foo = 3
  $bar = [1,2,3]
  $baz = 'A string!'

  if $foo.is_a(Integer) {
    notify  { 'foo!': }
  }
  if $bar.is_a(Array) {
    notify { 'bar!': }
  }
  if $baz.is_a(String) {
    notify { 'baz!': }
  }
```

##### `value`

Data type: `Any`

The value to be checked

##### `type`

Data type: `Type`

The expected type

### <a name="join_keys_to_values"></a>`join_keys_to_values`

Type: Ruby 3.x API

Keys are cast to strings. If values are arrays, multiple keys
are added for each element. The return value is an array in
which each element is one joined key/value pair.

> **Note:** Since Puppet 5.0.0 - for more detailed control over the formatting (including indentations and
line breaks, delimiters around arrays and hash entries, between key/values in hash entries, and individual
formatting of values in the array) - see the `new` function for `String` and its formatting
options for `Array` and `Hash`.

#### Examples

##### Example Usage:

```puppet
join_keys_to_values({'a'=>1,'b'=>2}, " is ") # Results in: ["a is 1","b is 2"]
join_keys_to_values({'a'=>1,'b'=>[2,3]}, " is ") # Results in: ["a is 1","b is 2","b is 3"]
```

#### `join_keys_to_values()`

Keys are cast to strings. If values are arrays, multiple keys
are added for each element. The return value is an array in
which each element is one joined key/value pair.

> **Note:** Since Puppet 5.0.0 - for more detailed control over the formatting (including indentations and
line breaks, delimiters around arrays and hash entries, between key/values in hash entries, and individual
formatting of values in the array) - see the `new` function for `String` and its formatting
options for `Array` and `Hash`.

Returns: `Hash` The joined hash

##### Examples

###### Example Usage:

```puppet
join_keys_to_values({'a'=>1,'b'=>2}, " is ") # Results in: ["a is 1","b is 2"]
join_keys_to_values({'a'=>1,'b'=>[2,3]}, " is ") # Results in: ["a is 1","b is 2","b is 3"]
```

### <a name="load_module_metadata"></a>`load_module_metadata`

Type: Ruby 3.x API

This function loads the metadata of a given module.

#### Examples

##### Example Usage:

```puppet
$metadata = load_module_metadata('archive')
notify { $metadata['author']: }
```

#### `load_module_metadata()`

The load_module_metadata function.

Returns: `Any` The modules metadata

##### Examples

###### Example Usage:

```puppet
$metadata = load_module_metadata('archive')
notify { $metadata['author']: }
```

### <a name="loadjson"></a>`loadjson`

Type: Ruby 3.x API

The first parameter can be a file path or a URL.
The second parameter is the default value. It will be returned if the file
was not found or could not be parsed.

#### Examples

##### Example Usage:

```puppet
$myhash = loadjson('/etc/puppet/data/myhash.json')
$myhash = loadjson('https://example.local/my_hash.json')
$myhash = loadjson('https://username:password@example.local/my_hash.json')
$myhash = loadjson('no-file.json', {'default' => 'val
```

#### `loadjson()`

The first parameter can be a file path or a URL.
The second parameter is the default value. It will be returned if the file
was not found or could not be parsed.

Returns: `Array|String|Hash` The data stored in the JSON file, the type depending on the type of data that was stored.

##### Examples

###### Example Usage:

```puppet
$myhash = loadjson('/etc/puppet/data/myhash.json')
$myhash = loadjson('https://example.local/my_hash.json')
$myhash = loadjson('https://username:password@example.local/my_hash.json')
$myhash = loadjson('no-file.json', {'default' => 'val
```

### <a name="loadyaml"></a>`loadyaml`

Type: Ruby 3.x API

The first parameter can be a file path or a URL.
The second parameter is the default value. It will be returned if the file
was not found or could not be parsed.

#### Examples

##### Example Usage:

```puppet
$myhash = loadyaml('/etc/puppet/data/myhash.yaml')
$myhash = loadyaml('https://example.local/my_hash.yaml')
$myhash = loadyaml('https://username:password@example.local/my_hash.yaml')
$myhash = loadyaml('no-file.yaml', {'default' => 'val
```

#### `loadyaml()`

The first parameter can be a file path or a URL.
The second parameter is the default value. It will be returned if the file
was not found or could not be parsed.

Returns: `Array|String|Hash` The data stored in the YAML file, the type depending on the type of data that was stored.

##### Examples

###### Example Usage:

```puppet
$myhash = loadyaml('/etc/puppet/data/myhash.yaml')
$myhash = loadyaml('https://example.local/my_hash.yaml')
$myhash = loadyaml('https://username:password@example.local/my_hash.yaml')
$myhash = loadyaml('no-file.yaml', {'default' => 'val
```

### <a name="member"></a>`member`

Type: Ruby 3.x API

The variable can be a string, fixnum, or array.

> **Note**: This function does not support nested arrays. If the first argument contains
nested arrays, it will not recurse through them.

> *Note:*
Since Puppet 4.0.0 the same can be performed in the Puppet language.
For single values the operator `in` can be used:
`'a' in ['a', 'b']  # true`
For arrays by using operator `-` to compute a diff:
`['d', 'b'] - ['a', 'b', 'c'] == []  # false because 'd' is not subtracted`
`['a', 'b'] - ['a', 'b', 'c'] == []  # true because both 'a' and 'b' are subtracted`

> **Note** that since Puppet 5.2.0, the general form to test the content of an array or
hash is to use the built-in [`any`](https://puppet.com/docs/puppet/latest/function.html#any)
and [`all`](https://puppet.com/docs/puppet/latest/function.html#all) functions.

#### Examples

##### **Usage**

```puppet
member(['a','b'], 'b') # Returns: true
member(['a', 'b', 'c'], ['a', 'b']) # Returns: true
member(['a','b'], 'c') # Returns: false
member(['a', 'b', 'c'], ['d', 'b']) # Returns: false
```

#### `member()`

The variable can be a string, fixnum, or array.

> **Note**: This function does not support nested arrays. If the first argument contains
nested arrays, it will not recurse through them.

> *Note:*
Since Puppet 4.0.0 the same can be performed in the Puppet language.
For single values the operator `in` can be used:
`'a' in ['a', 'b']  # true`
For arrays by using operator `-` to compute a diff:
`['d', 'b'] - ['a', 'b', 'c'] == []  # false because 'd' is not subtracted`
`['a', 'b'] - ['a', 'b', 'c'] == []  # true because both 'a' and 'b' are subtracted`

> **Note** that since Puppet 5.2.0, the general form to test the content of an array or
hash is to use the built-in [`any`](https://puppet.com/docs/puppet/latest/function.html#any)
and [`all`](https://puppet.com/docs/puppet/latest/function.html#all) functions.

Returns: `Any` Returns whether the given value was a member of the array

##### Examples

###### **Usage**

```puppet
member(['a','b'], 'b') # Returns: true
member(['a', 'b', 'c'], ['a', 'b']) # Returns: true
member(['a','b'], 'c') # Returns: false
member(['a', 'b', 'c'], ['d', 'b']) # Returns: false
```

### <a name="merge"></a>`merge`

Type: Ruby 4.x API

DEPRECATED.  Use the namespaced function [`stdlib::merge`](#stdlibmerge) instead.

#### `merge(Any *$args, Optional[Variant[Callable[2,2], Callable[3,3]]] &$block)`

The merge function.

Returns: `Any`

##### `*args`

Data type: `Any`



##### `&block`

Data type: `Optional[Variant[Callable[2,2], Callable[3,3]]]`



### <a name="merge"></a>`merge`

Type: Ruby 3.x API

When there is a duplicate key, the key in the rightmost hash will "win."

Note that since Puppet 4.0.0 the same merge can be achieved with the + operator.
  `$merged_hash = $hash1 + $h

#### Examples

##### **Usage**

```puppet
$hash1 = {'one' => 1, 'two', => 2}
$hash2 = {'two' => 'dos', 'three', => 'tres'}
$merged_hash = merge($hash1, $hash2) # $merged_hash =  {'one' => 1, 'two' => 'dos', 'three' => 'tres'}
```

#### `merge()`

When there is a duplicate key, the key in the rightmost hash will "win."

Note that since Puppet 4.0.0 the same merge can be achieved with the + operator.
  `$merged_hash = $hash1 + $h

Returns: `Hash` The merged hash

##### Examples

###### **Usage**

```puppet
$hash1 = {'one' => 1, 'two', => 2}
$hash2 = {'two' => 'dos', 'three', => 'tres'}
$merged_hash = merge($hash1, $hash2) # $merged_hash =  {'one' => 1, 'two' => 'dos', 'three' => 'tres'}
```

### <a name="num2bool"></a>`num2bool`

Type: Ruby 3.x API

> *Note:* that since Puppet 5.0.0 the same can be achieved with the Puppet Type System.
See the new() function in Puppet for the many available type conversions.

#### `num2bool()`

> *Note:* that since Puppet 5.0.0 the same can be achieved with the Puppet Type System.
See the new() function in Puppet for the many available type conversions.

Returns: `Boolean` Boolean(0) # false for any zero or negative number
Boolean(1) # true for any positive number

### <a name="os_version_gte"></a>`os_version_gte`

Type: Ruby 4.x API

DEPRECATED.  Use the namespaced function [`stdlib::os_version_gte`](#stdlibos_version_gte) instead.

#### `os_version_gte(Any *$args)`

The os_version_gte function.

Returns: `Any`

##### `*args`

Data type: `Any`



### <a name="parsehocon"></a>`parsehocon`

Type: Ruby 4.x API

DEPRECATED.  Use the namespaced function [`stdlib::parsehocon`](#stdlibparsehocon) instead.

#### `parsehocon(Any *$args)`

The parsehocon function.

Returns: `Any`

##### `*args`

Data type: `Any`



### <a name="parsejson"></a>`parsejson`

Type: Ruby 3.x API

> *Note:*
  The optional second argument can be used to pass a default value that will
  be returned if the parsing of the JSON string failed or if the JSON parse
  evaluated to nil.

#### `parsejson()`

> *Note:*
  The optional second argument can be used to pass a default value that will
  be returned if the parsing of the JSON string failed or if the JSON parse
  evaluated to nil.

Returns: `Any` convert JSON into Puppet structure

### <a name="parsepson"></a>`parsepson`

Type: Ruby 4.x API

For more information on PSON please see the following link:
https://puppet.com/docs/puppet/7/http_api/pson.html

#### Examples

##### How to parse pson

```puppet
$data = parsepson('{"a":"1","b":"2"}')
```

#### `parsepson(String[1] $pson_string, Optional[Any] $default)`

For more information on PSON please see the following link:
https://puppet.com/docs/puppet/7/http_api/pson.html

Returns: `Data`

##### Examples

###### How to parse pson

```puppet
$data = parsepson('{"a":"1","b":"2"}')
```

##### `pson_string`

Data type: `String[1]`

A valid PSON string

##### `default`

Data type: `Optional[Any]`

An optional default to return if parsing the pson_string fails

### <a name="parseyaml"></a>`parseyaml`

Type: Ruby 3.x API

> *Note:*
  The optional second argument can be used to pass a default value that will
  be returned if the parsing of YAML string have failed.

#### `parseyaml()`

> *Note:*
  The optional second argument can be used to pass a default value that will
  be returned if the parsing of YAML string have failed.

Returns: `Any` converted YAML into Puppet structure

### <a name="pick"></a>`pick`

Type: Ruby 3.x API

This function is similar to a coalesce function in SQL.

Typically, this function is used to check for a value in the Puppet
Dashboard/Enterprise Console, and failover to a default value like the following:

```$real_jenkins_version = pick($::jenkins_version, '1.449')```

> *Note:*
  The value of $real_jenkins_version will first look for a top-scope variable
  called 'jenkins_version' (note that parameters set in the Puppet Dashboard/
  Enterprise Console are brought into Puppet as top-scope variables), and,
  failing that, will use a default value of 1.449.

#### `pick()`

This function is similar to a coalesce function in SQL.

Typically, this function is used to check for a value in the Puppet
Dashboard/Enterprise Console, and failover to a default value like the following:

```$real_jenkins_version = pick($::jenkins_version, '1.449')```

> *Note:*
  The value of $real_jenkins_version will first look for a top-scope variable
  called 'jenkins_version' (note that parameters set in the Puppet Dashboard/
  Enterprise Console are brought into Puppet as top-scope variables), and,
  failing that, will use a default value of 1.449.

Returns: `Any` the first value in a list of values that is not undefined or an empty string.

### <a name="pick_default"></a>`pick_default`

Type: Ruby 3.x API

Typically, this function is used to check for a value in the Puppet
Dashboard/Enterprise Console, and failover to a default value like the
following:

  $real_jenkins_version = pick_default($::jenkins_version, '1.449')

> *Note:*
  The value of $real_jenkins_version will first look for a top-scope variable
  called 'jenkins_version' (note that parameters set in the Puppet Dashboard/
  Enterprise Console are brought into Puppet as top-scope variables), and,
  failing that, will use a default value of 1.449.

  Contrary to the pick() function, the pick_default does not fail if
  all arguments are empty. This allows pick_default to use an empty value as
  default.

#### `pick_default()`

Typically, this function is used to check for a value in the Puppet
Dashboard/Enterprise Console, and failover to a default value like the
following:

  $real_jenkins_version = pick_default($::jenkins_version, '1.449')

> *Note:*
  The value of $real_jenkins_version will first look for a top-scope variable
  called 'jenkins_version' (note that parameters set in the Puppet Dashboard/
  Enterprise Console are brought into Puppet as top-scope variables), and,
  failing that, will use a default value of 1.449.

  Contrary to the pick() function, the pick_default does not fail if
  all arguments are empty. This allows pick_default to use an empty value as
  default.

Returns: `Any` This function is similar to a coalesce function in SQL in that it will return
the first value in a list of values that is not undefined or an empty string
If no value is found, it will return the last argument.

### <a name="powershell_escape"></a>`powershell_escape`

Type: Ruby 4.x API

DEPRECATED.  Use the namespaced function [`stdlib::powershell_escape`](#stdlibpowershell_escape) instead.

#### `powershell_escape(Any *$args)`

The powershell_escape function.

Returns: `Any`

##### `*args`

Data type: `Any`



### <a name="prefix"></a>`prefix`

Type: Ruby 3.x API

> *Note:* since Puppet 4.0.0 the general way to modify values is in array is by using the map
function in Puppet. This example does the same as the example above:
['a', 'b', 'c'].map |$x| { "p${x}" }

#### Examples

##### **Usage**

```puppet

prefix(['a','b','c'], 'p')
Will return: ['pa','pb','pc']
```

#### `prefix()`

> *Note:* since Puppet 4.0.0 the general way to modify values is in array is by using the map
function in Puppet. This example does the same as the example above:
['a', 'b', 'c'].map |$x| { "p${x}" }

Returns: `Hash` or [Array] The passed values now contains the passed prefix

##### Examples

###### **Usage**

```puppet

prefix(['a','b','c'], 'p')
Will return: ['pa','pb','pc']
```

### <a name="pry"></a>`pry`

Type: Ruby 3.x API

This is useful for debugging manifest code at specific points during a compilation.

#### Examples

##### **Usage**

```puppet

`pry()`
```

#### `pry()`

This is useful for debugging manifest code at specific points during a compilation.

Returns: `Any` debugging information

##### Examples

###### **Usage**

```puppet

`pry()`
```

### <a name="pw_hash"></a>`pw_hash`

Type: Ruby 3.x API

The first argument to this function is the password to hash. If it is
undef or an empty string, this function returns undef.

The second argument to this function is which hash algorithm to use. It
will be converted into the appropriate crypt(3) hash specifier. Valid
hash types are:

|Hash type|Prefix|Note                 |
|---------|------|---------------------|
|MD5      |1     |                     |
|SHA-256  |5     |                     |
|SHA-512  |6     |Recommended          |
|bcrypt   |2b    |                     |
|bcrypt-a |2a    |bug compatible       |
|bcrypt-x |2x    |bug compatible       |
|bcrypt-y |2y    |historic alias for 2b|

The third argument to this function is the salt to use. For bcrypt-type hashes,
the first two characters of the salt represent a strength parameter, with a value
between 4 and 31 inclusive.

> *Note:*: this uses the Puppet Server's implementation of crypt(3). If your
  environment contains several different operating systems, ensure that they
  are compatible before using this function.

#### `pw_hash()`

The first argument to this function is the password to hash. If it is
undef or an empty string, this function returns undef.

The second argument to this function is which hash algorithm to use. It
will be converted into the appropriate crypt(3) hash specifier. Valid
hash types are:

|Hash type|Prefix|Note                 |
|---------|------|---------------------|
|MD5      |1     |                     |
|SHA-256  |5     |                     |
|SHA-512  |6     |Recommended          |
|bcrypt   |2b    |                     |
|bcrypt-a |2a    |bug compatible       |
|bcrypt-x |2x    |bug compatible       |
|bcrypt-y |2y    |historic alias for 2b|

The third argument to this function is the salt to use. For bcrypt-type hashes,
the first two characters of the salt represent a strength parameter, with a value
between 4 and 31 inclusive.

> *Note:*: this uses the Puppet Server's implementation of crypt(3). If your
  environment contains several different operating systems, ensure that they
  are compatible before using this function.

Returns: `String` Provides a crypt hash usable on most POSIX systems.

### <a name="range"></a>`range`

Type: Ruby 3.x API

NB Be explicit in including trailing zeros. Otherwise the underlying ruby function will fail.

> *Note:*
  Passing a third argument will cause the generated range to step by that
  interval, e.g.

The Puppet Language support Integer and Float ranges by using the type system. Those are suitable for
iterating a given number of times.

 Integer[0, 9].each |$x| { notice($x) } # notices 0, 1, 2, ... 9

#### Examples

##### **Usage**

```puppet
range("0", "9")
Will return: [0,1,2,3,4,5,6,7,8,9]

range("00", "09")
Will return: [0,1,2,3,4,5,6,7,8,9]
(Zero padded strings are converted to integers automatically)

range("a", "c")
Will return: ["a","b","c"]

range("host01", "host10")
Will return: ["host01", "host02", ..., "host09", "host10"]

range("0", "9", "2")
Will return: [0,2,4,6,8]
```

#### `range()`

NB Be explicit in including trailing zeros. Otherwise the underlying ruby function will fail.

> *Note:*
  Passing a third argument will cause the generated range to step by that
  interval, e.g.

The Puppet Language support Integer and Float ranges by using the type system. Those are suitable for
iterating a given number of times.

 Integer[0, 9].each |$x| { notice($x) } # notices 0, 1, 2, ... 9

Returns: `Any` the range is extrapolated as an array

##### Examples

###### **Usage**

```puppet
range("0", "9")
Will return: [0,1,2,3,4,5,6,7,8,9]

range("00", "09")
Will return: [0,1,2,3,4,5,6,7,8,9]
(Zero padded strings are converted to integers automatically)

range("a", "c")
Will return: ["a","b","c"]

range("host01", "host10")
Will return: ["host01", "host02", ..., "host09", "host10"]

range("0", "9", "2")
Will return: [0,2,4,6,8]
```

### <a name="regexpescape"></a>`regexpescape`

Type: Ruby 3.x API

Regexp escape a string or array of strings.
Requires either a single string or an array as an input.

#### `regexpescape()`

The regexpescape function.

Returns: `String` A string of characters with metacharacters converted to their escaped form.

### <a name="reject"></a>`reject`

Type: Ruby 3.x API

> *Note:*
Since Puppet 4.0.0 the same is in general done with the filter function. Here is the equivalence of the reject() function:
['aaa','bbb','ccc','aaaddd'].filter |$x| { $x !~ /a

#### Examples

##### **Usage**

```puppet

reject(['aaa','bbb','ccc','aaaddd'], 'aaa')

Would return: ['bbb','ccc']
```

#### `reject()`

> *Note:*
Since Puppet 4.0.0 the same is in general done with the filter function. Here is the equivalence of the reject() function:
['aaa','bbb','ccc','aaaddd'].filter |$x| { $x !~ /a

Returns: `Any` an array containing all the elements which doesn'' match the provided regular expression

##### Examples

###### **Usage**

```puppet

reject(['aaa','bbb','ccc','aaaddd'], 'aaa')

Would return: ['bbb','ccc']
```

### <a name="reverse"></a>`reverse`

Type: Ruby 3.x API

> *Note:* that the same can be done with the reverse_each() function in Puppet.

#### `reverse()`

> *Note:* that the same can be done with the reverse_each() function in Puppet.

Returns: `Any` reversed string or array

### <a name="seeded_rand"></a>`seeded_rand`

Type: Ruby 4.x API

DEPRECATED.  Use the namespaced function [`stdlib::seeded_rand`](#stdlibseeded_rand) instead.

#### `seeded_rand(Any *$args)`

The seeded_rand function.

Returns: `Any`

##### `*args`

Data type: `Any`



### <a name="seeded_rand_string"></a>`seeded_rand_string`

Type: Ruby 4.x API

DEPRECATED.  Use the namespaced function [`stdlib::seeded_rand_string`](#stdlibseeded_rand_string) instead.

#### `seeded_rand_string(Any *$args)`

The seeded_rand_string function.

Returns: `Any`

##### `*args`

Data type: `Any`



### <a name="shell_escape"></a>`shell_escape`

Type: Ruby 4.x API

DEPRECATED.  Use the namespaced function [`stdlib::shell_escape`](#stdlibshell_escape) instead.

#### `shell_escape(Any *$args)`

The shell_escape function.

Returns: `Any`

##### `*args`

Data type: `Any`



### <a name="shell_join"></a>`shell_join`

Type: Ruby 3.x API

Builds a command line string from the given array of strings.
Each array item is escaped for Bourne shell. All items are then joined together, with a single space in between.
This function behaves the same as ruby's Shellwords.shelljoin() function

#### `shell_join()`

Builds a command line string from the given array of strings.
Each array item is escaped for Bourne shell. All items are then joined together, with a single space in between.
This function behaves the same as ruby's Shellwords.shelljoin() function

Returns: `Any` a command line string

### <a name="shell_split"></a>`shell_split`

Type: Ruby 3.x API

This function behaves the same as ruby's Shellwords.shellsplit() function

#### `shell_split()`

This function behaves the same as ruby's Shellwords.shellsplit() function

Returns: `Any` array of tokens

### <a name="shuffle"></a>`shuffle`

Type: Ruby 3.x API

@summary
 Randomizes the order of a string or array elements.

#### `shuffle()`

@summary
 Randomizes the order of a string or array elements.

Returns: `Any` randomized string or array

### <a name="squeeze"></a>`squeeze`

Type: Ruby 3.x API

Returns a new string where runs of the same character that occur in this set are replaced by a single character.

#### `squeeze()`

The squeeze function.

Returns: `Any` a new string where runs of the same character that occur in this set are replaced by a single character.

### <a name="stdlib--batch_escape"></a>`stdlib::batch_escape`

Type: Ruby 4.x API

>* Note:* that the resulting string should be used unquoted and is not intended for use in double quotes nor in single
quotes.

#### `stdlib::batch_escape(Any $string)`

>* Note:* that the resulting string should be used unquoted and is not intended for use in double quotes nor in single
quotes.

Returns: `Any` An escaped string that can be safely used in a batch command line.

##### `string`

Data type: `Any`

The string to escape

### <a name="stdlib--crc32"></a>`stdlib::crc32`

Type: Ruby 4.x API

Run a CRC32 calculation against a given value.

#### Examples

##### Check a simple string value

```puppet
stdlib::crc32('my string') == '18fbd270'
```

##### Check a Sensitive datatype

```puppet
stdlib::crc32(sensitive('my string')) == '18fbd270'
```

##### Check a number

```puppet
stdlib::crc32(100.0) == 'a3fd429a'
stdlib::crc32(100.00000) == 'a3fd429a'
```

#### `stdlib::crc32(Variant[ScalarData, Sensitive[ScalarData], Binary, Sensitive[Binary]] $my_data)`

Run a CRC32 calculation against a given value.

Returns: `String` String

##### Examples

###### Check a simple string value

```puppet
stdlib::crc32('my string') == '18fbd270'
```

###### Check a Sensitive datatype

```puppet
stdlib::crc32(sensitive('my string')) == '18fbd270'
```

###### Check a number

```puppet
stdlib::crc32(100.0) == 'a3fd429a'
stdlib::crc32(100.00000) == 'a3fd429a'
```

##### `my_data`

Data type: `Variant[ScalarData, Sensitive[ScalarData], Binary, Sensitive[Binary]]`

The ScalarData to evaluate

### <a name="stdlib--deferrable_epp"></a>`stdlib::deferrable_epp`

Type: Puppet Language

This function returns either a rendered template or a deferred function to render at runtime.
If any of the values in the variables hash are deferred, then the template will be deferred.

Note: this function requires all parameters to be explicitly passed in. It cannot expect to
use facts, class variables, and other variables in scope. This is because when deferred, we
have to explicitly pass the entire scope to the client.

#### `stdlib::deferrable_epp(String $template, Hash $variables)`

This function returns either a rendered template or a deferred function to render at runtime.
If any of the values in the variables hash are deferred, then the template will be deferred.

Note: this function requires all parameters to be explicitly passed in. It cannot expect to
use facts, class variables, and other variables in scope. This is because when deferred, we
have to explicitly pass the entire scope to the client.

Returns: `Variant[String, Sensitive[String], Deferred]`

##### `template`

Data type: `String`



##### `variables`

Data type: `Hash`



### <a name="stdlib--end_with"></a>`stdlib::end_with`

Type: Ruby 4.x API

Returns true if str ends with one of the prefixes given. Each of the prefixes should be a String.

#### Examples

##### 

```puppet
'foobar'.stdlib::end_with('bar') => true
'foobar'.stdlib::end_with('foo') => false
'foobar'.stdlib::end_with(['foo', 'baz']) => false
```

#### `stdlib::end_with(String $test_string, Variant[String[1],Array[String[1], 1]] $suffixes)`

The stdlib::end_with function.

Returns: `Boolean` True or False

##### Examples

###### 

```puppet
'foobar'.stdlib::end_with('bar') => true
'foobar'.stdlib::end_with('foo') => false
'foobar'.stdlib::end_with(['foo', 'baz']) => false
```

##### `test_string`

Data type: `String`

The string to check

##### `suffixes`

Data type: `Variant[String[1],Array[String[1], 1]]`

The suffixes to check

### <a name="stdlib--ensure"></a>`stdlib::ensure`

Type: Puppet Language

function to cast ensure parameter to resource specific value

#### `stdlib::ensure(Variant[Boolean, Enum['present', 'absent']] $ensure, Optional[Enum['directory', 'link', 'mounted', 'service', 'file', 'package']] $resource = undef)`

The stdlib::ensure function.

Returns: `String`

##### `ensure`

Data type: `Variant[Boolean, Enum['present', 'absent']]`



##### `resource`

Data type: `Optional[Enum['directory', 'link', 'mounted', 'service', 'file', 'package']]`



### <a name="stdlib--ensure_packages"></a>`stdlib::ensure_packages`

Type: Ruby 4.x API

It optionally takes a hash as a second parameter that will be passed as the
third argument to the ensure_resource() function.

#### `stdlib::ensure_packages(Variant[String[1], Array[String[1]]] $packages, Optional[Hash] $default_attributes)`

The stdlib::ensure_packages function.

Returns: `Undef` Returns nothing.

##### `packages`

Data type: `Variant[String[1], Array[String[1]]]`

The packages to ensure are installed.

##### `default_attributes`

Data type: `Optional[Hash]`

Default attributes to be passed to the `ensure_resource()` function

#### `stdlib::ensure_packages(Hash[String[1], Any] $packages, Optional[Hash] $default_attributes)`

The stdlib::ensure_packages function.

Returns: `Undef` Returns nothing.

##### `packages`

Data type: `Hash[String[1], Any]`

The packages to ensure are installed. The keys are packages and values are the attributes specific to that package.

##### `default_attributes`

Data type: `Optional[Hash]`

Default attributes. Package specific attributes from the `packages` parameter will take precedence.

### <a name="stdlib--extname"></a>`stdlib::extname`

Type: Ruby 4.x API

If Path is a Dotfile, or starts with a Period, then the starting Dot is not
dealt with the Start of the Extension.

An empty String will also be returned, when the Period is the last Character
in Path.

#### Examples

##### Determining the Extension of a Filename

```puppet
stdlib::extname('test.rb')       => '.rb'
stdlib::extname('a/b/d/test.rb') => '.rb'
stdlib::extname('test')          => ''
stdlib::extname('.profile')      => ''
```

#### `stdlib::extname(String $filename)`

If Path is a Dotfile, or starts with a Period, then the starting Dot is not
dealt with the Start of the Extension.

An empty String will also be returned, when the Period is the last Character
in Path.

Returns: `String` The Extension starting from the last Period

##### Examples

###### Determining the Extension of a Filename

```puppet
stdlib::extname('test.rb')       => '.rb'
stdlib::extname('a/b/d/test.rb') => '.rb'
stdlib::extname('test')          => ''
stdlib::extname('.profile')      => ''
```

##### `filename`

Data type: `String`

The Filename

### <a name="stdlib--fqdn_rand_string"></a>`stdlib::fqdn_rand_string`

Type: Ruby 4.x API

Optionally, you can specify a character set for the function (defaults to alphanumeric).

#### Examples

##### Example Usage:

```puppet
stdlib::fqdn_rand_string(10)
stdlib::fqdn_rand_string(10, 'ABCDEF!@$%^')
stdlib::fqdn_rand_string(10, undef, 'custom seed')
```

#### `stdlib::fqdn_rand_string(Integer[1] $length, Optional[Optional[String]] $charset, Optional[Any] *$seed)`

Optionally, you can specify a character set for the function (defaults to alphanumeric).

Returns: `String`

##### Examples

###### Example Usage:

```puppet
stdlib::fqdn_rand_string(10)
stdlib::fqdn_rand_string(10, 'ABCDEF!@$%^')
stdlib::fqdn_rand_string(10, undef, 'custom seed')
```

##### `length`

Data type: `Integer[1]`

The length of the resulting string.

##### `charset`

Data type: `Optional[Optional[String]]`

The character set to use.

##### `*seed`

Data type: `Optional[Any]`

The seed for repeatable randomness.

### <a name="stdlib--fqdn_rotate"></a>`stdlib::fqdn_rotate`

Type: Ruby 4.x API

Rotates an array or string a random number of times, combining the `fqdn` fact and an optional seed for repeatable randomness.

#### `stdlib::fqdn_rotate(String $input, Optional[Variant[Integer,String]] *$seeds)`

The stdlib::fqdn_rotate function.

Returns: `String` Returns the rotated String

##### Examples

###### Rotating a String

```puppet
stdlib::fqdn_rotate('abcd')
```

###### Using a custom seed

```puppet
stdlib::fqdn_rotate('abcd', 'custom seed')
```

##### `input`

Data type: `String`

The String you want rotated a random number of times

##### `*seeds`

Data type: `Optional[Variant[Integer,String]]`

One of more values to use as a custom seed. These will be combined with the host's FQDN

#### `stdlib::fqdn_rotate(Array $input, Optional[Variant[Integer,String]] *$seeds)`

The stdlib::fqdn_rotate function.

Returns: `Array` Returns the rotated Array

##### Examples

###### Rotating an Array

```puppet
stdlib::fqdn_rotate(['a', 'b', 'c', 'd'])
```

###### Using custom seeds

```puppet
stdlib::fqdn_rotate([1, 2, 3], 'custom', 'seed', 1)
```

##### `input`

Data type: `Array`

The Array you want rotated a random number of times

##### `*seeds`

Data type: `Optional[Variant[Integer,String]]`

One of more values to use as a custom seed. These will be combined with the host's FQDN

### <a name="stdlib--has_function"></a>`stdlib::has_function`

Type: Ruby 4.x API

Determines whether the Puppet runtime has access to a function by the
name provided.

#### Examples

##### Using stdlib::has_function()

```puppet
stdlib::has_function('stdlib::has_function') # true
stdlib::has_function('not_a_function') # false
```

#### `stdlib::has_function(String[1] $function_name)`

Determines whether the Puppet runtime has access to a function by the
name provided.

Returns: `Boolean`

##### Examples

###### Using stdlib::has_function()

```puppet
stdlib::has_function('stdlib::has_function') # true
stdlib::has_function('not_a_function') # false
```

##### `function_name`

Data type: `String[1]`



### <a name="stdlib--has_interface_with"></a>`stdlib::has_interface_with`

Type: Ruby 4.x API

Can be called with one, or two arguments.

#### `stdlib::has_interface_with(String[1] $interface)`

The stdlib::has_interface_with function.

Returns: `Boolean` Returns `true` if `interface` exists and `false` otherwise

##### Examples

###### When called with a single argument, the presence of the interface is checked

```puppet
stdlib::has_interface_with('lo') # Returns `true`
```

##### `interface`

Data type: `String[1]`

The name of an interface

#### `stdlib::has_interface_with(Enum['macaddress','netmask','ipaddress','network','ip','mac'] $kind, String[1] $value)`

The stdlib::has_interface_with function.

Returns: `Boolean` Returns `true` if any of the interfaces in the `networking` fact has a `kind` attribute with the value `value`. Otherwise returns `false`

##### Examples

###### Checking if an interface exists with a given mac address

```puppet
stdlib::has_interface_with('macaddress', 'x:x:x:x:x:x') # Returns `false`
```

###### Checking if an interface exists with a given IP address

```puppet
stdlib::has_interface_with('ipaddress', '127.0.0.1') # Returns `true`
```

##### `kind`

Data type: `Enum['macaddress','netmask','ipaddress','network','ip','mac']`

A supported interface attribute

##### `value`

Data type: `String[1]`

The value of the attribute

### <a name="stdlib--ip_in_range"></a>`stdlib::ip_in_range`

Type: Ruby 4.x API

Returns true if the ipaddress is within the given CIDRs

#### Examples

##### ip_in_range(<IPv4 Address>, <IPv4 CIDR>)

```puppet
stdlib::ip_in_range('10.10.10.53', '10.10.10.0/24') => true
```

#### `stdlib::ip_in_range(String $ipaddress, Variant[String, Array] $range)`

The stdlib::ip_in_range function.

Returns: `Boolean` True or False

##### Examples

###### ip_in_range(<IPv4 Address>, <IPv4 CIDR>)

```puppet
stdlib::ip_in_range('10.10.10.53', '10.10.10.0/24') => true
```

##### `ipaddress`

Data type: `String`

The IP address to check

##### `range`

Data type: `Variant[String, Array]`

One CIDR or an array of CIDRs
defining the range(s) to check against

### <a name="stdlib--merge"></a>`stdlib::merge`

Type: Ruby 4.x API

When there is a duplicate key, the key in the rightmost hash will "win."

Note that since Puppet 4.0.0 the same merge can be achieved with the + operator.
 `$merged_hash = $hash1 + $hash2`

If stdlib::merge is given a single Iterable (Array, Hash, etc.) it will call a given block with
up to three parameters, and merge each resulting Hash into the accumulated result. All other types
of values returned from the block (typically undef) are skipped (not merged).

The codeblock can take 2 or three parameters:
* with two, it gets the current hash (as built to this point), and each value (for hash the value is a [key, value] tuple)
* with three, it gets the current hash (as built to this point), the key/index of each value, and then the value

If the iterable is empty, or no hash was returned from the given block, an empty hash is returned. In the given block, a call to `next()`
will skip that entry, and a call to `break()` will end the iteration.

The iterative `stdlib::merge()` has an advantage over doing the same with a general `reduce()` in that the constructed hash
does not have to be copied in each iteration and thus will perform much better with large inputs.

#### Examples

##### Using stdlib::merge()

```puppet
$hash1 = {'one' => 1, 'two', => 2}
$hash2 = {'two' => 'dos', 'three', => 'tres'}
$merged_hash = stdlib::merge($hash1, $hash2) # $merged_hash =  {'one' => 1, 'two' => 'dos', 'three' => 'tres'}
```

##### counting occurrences of strings in an array

```puppet
['a', 'b', 'c', 'c', 'd', 'b'].stdlib::merge | $hsh, $v | { { $v => $hsh[$v].lest || { 0 } + 1 } } # results in { a => 1, b => 2, c => 2, d => 1 }
```

##### skipping values for entries that are longer than 1 char

```puppet
['a', 'b', 'c', 'c', 'd', 'b', 'blah', 'blah'].stdlib::merge | $hsh, $v | { if $v =~ String[1,1] { { $v => $hsh[$v].lest || { 0 } + 1 } } } # results in { a => 1, b => 2, c => 2, d => 1 }
```

#### `stdlib::merge(Variant[Hash[Scalar,Any], Undef, String[0,0]] *$args)`

The stdlib::merge function.

Returns: `Hash[Scalar,Any]` The merged hash

##### `*args`

Data type: `Variant[Hash[Scalar,Any], Undef, String[0,0]]`

Repeated Param - The hashes that are to be merged

#### `stdlib::merge(Iterable *$args, Callable[3,3] &$block)`

The stdlib::merge function.

Returns: `Hash` The merged hash

##### `*args`

Data type: `Iterable`

Repeated Param - The hashes that are to be merged

##### `&block`

Data type: `Callable[3,3]`

A block placed on the repeatable param `args`

#### `stdlib::merge(Iterable *$args, Callable[2,2] &$block)`

The stdlib::merge function.

Returns: `Hash` The merged hash

##### `*args`

Data type: `Iterable`

Repeated Param - The hashes that are to be merged

##### `&block`

Data type: `Callable[2,2]`

A block placed on the repeatable param `args`

### <a name="stdlib--nested_values"></a>`stdlib::nested_values`

Type: Ruby 4.x API

Get list of nested values from given hash
This function will return list of nested Hash values and returns list of values in form of Array

#### Examples

##### Example Usage:

```puppet
$hash = {
  "key1" => "value1",
  "key2" => { "key2.1" => "value2.1"},
  "key3" => "value3"
}
$data = $hash.stdlib::nested_values
#Output : ["value1", "value2.1", "value3"]
```

#### `stdlib::nested_values(Hash $hash)`

The stdlib::nested_values function.

Returns: `Array` All the values found in the input hash included those deeply nested.

##### Examples

###### Example Usage:

```puppet
$hash = {
  "key1" => "value1",
  "key2" => { "key2.1" => "value2.1"},
  "key3" => "value3"
}
$data = $hash.stdlib::nested_values
#Output : ["value1", "value2.1", "value3"]
```

##### `hash`

Data type: `Hash`

A (nested) hash

### <a name="stdlib--os_version_gte"></a>`stdlib::os_version_gte`

Type: Ruby 4.x API

> *Note:*
Only the major version is taken into account.

#### Examples

##### Example usage:#

```puppet
if stdlib::os_version_gte('Debian', '9') { }
if stdlib::os_version_gte('Ubuntu', '18.04') { }
```

#### `stdlib::os_version_gte(String[1] $os, String[1] $version)`

> *Note:*
Only the major version is taken into account.

Returns: `Boolean` `true` or `false

##### Examples

###### Example usage:#

```puppet
if stdlib::os_version_gte('Debian', '9') { }
if stdlib::os_version_gte('Ubuntu', '18.04') { }
```

##### `os`

Data type: `String[1]`

operating system

##### `version`

Data type: `String[1]`



### <a name="stdlib--parsehocon"></a>`stdlib::parsehocon`

Type: Ruby 4.x API

This function accepts HOCON as a string and converts it into the correct
Puppet structure

#### Examples

##### How to parse hocon

```puppet
$data = stdlib::parsehocon("{any valid hocon: string}")
```

#### `stdlib::parsehocon(String $hocon_string, Optional[Any] $default)`

The stdlib::parsehocon function.

Returns: `Data`

##### Examples

###### How to parse hocon

```puppet
$data = stdlib::parsehocon("{any valid hocon: string}")
```

##### `hocon_string`

Data type: `String`

A valid HOCON string

##### `default`

Data type: `Optional[Any]`

An optional default to return if parsing hocon_string fails

### <a name="stdlib--powershell_escape"></a>`stdlib::powershell_escape`

Type: Ruby 4.x API

>* Note:* that the resulting string should be used unquoted and is not intended for use in double quotes nor in single
quotes.

#### `stdlib::powershell_escape(Any $string)`

>* Note:* that the resulting string should be used unquoted and is not intended for use in double quotes nor in single
quotes.

Returns: `Any` An escaped string that can be safely used in a PowerShell command line.

##### `string`

Data type: `Any`

The string to escape

### <a name="stdlib--seeded_rand"></a>`stdlib::seeded_rand`

Type: Ruby 4.x API

Generates a random whole number greater than or equal to 0 and less than max, using the value of seed for repeatable randomness.

#### `stdlib::seeded_rand(Integer[1] $max, String $seed)`

The stdlib::seeded_rand function.

Returns: `Integer` A random number greater than or equal to 0 and less than max

##### `max`

Data type: `Integer[1]`

The maximum value.

##### `seed`

Data type: `String`

The seed used for repeatable randomness.

### <a name="stdlib--seeded_rand_string"></a>`stdlib::seeded_rand_string`

Type: Ruby 4.x API

Generates a consistent random string of specific length based on provided seed.

#### Examples

##### Generate a consistently random string of length 8 with a seed:

```puppet
stdlib::seeded_rand_string(8, "${module_name}::redis_password")
```

##### Generate a random string from a specific set of characters:

```puppet
stdlib::seeded_rand_string(5, '', 'abcdef')
```

#### `stdlib::seeded_rand_string(Integer[1] $length, String $seed, Optional[String[2]] $charset)`

The stdlib::seeded_rand_string function.

Returns: `String` Random string.

##### Examples

###### Generate a consistently random string of length 8 with a seed:

```puppet
stdlib::seeded_rand_string(8, "${module_name}::redis_password")
```

###### Generate a random string from a specific set of characters:

```puppet
stdlib::seeded_rand_string(5, '', 'abcdef')
```

##### `length`

Data type: `Integer[1]`

Length of string to be generated.

##### `seed`

Data type: `String`

Seed string.

##### `charset`

Data type: `Optional[String[2]]`

String that contains characters to use for the random string.

### <a name="stdlib--sha256"></a>`stdlib::sha256`

Type: Ruby 4.x API

Run a SHA256 calculation against a given value.

#### Examples

##### Check a simple string value

```puppet
stdlib::sha256('my string') == '2f7e2089add0288a309abd71ffcc3b3567e2d4215e20e6ed3b74d6042f7ef8e5'
```

##### Check a Sensitive datatype

```puppet
stdlib::sha256(sensitive('my string')) == '2f7e2089add0288a309abd71ffcc3b3567e2d4215e20e6ed3b74d6042f7ef8e5'
```

##### Check a number

```puppet
stdlib::sha256(100.0) == '43b87f618caab482ebe4976c92bcd6ad308b48055f1c27b4c574f3e31d7683e0'
stdlib::sha256(100.00000) == '43b87f618caab482ebe4976c92bcd6ad308b48055f1c27b4c574f3e31d7683e0'
```

#### `stdlib::sha256(Variant[ScalarData, Sensitive[ScalarData], Binary, Sensitive[Binary]] $my_data)`

Run a SHA256 calculation against a given value.

Returns: `String` String

##### Examples

###### Check a simple string value

```puppet
stdlib::sha256('my string') == '2f7e2089add0288a309abd71ffcc3b3567e2d4215e20e6ed3b74d6042f7ef8e5'
```

###### Check a Sensitive datatype

```puppet
stdlib::sha256(sensitive('my string')) == '2f7e2089add0288a309abd71ffcc3b3567e2d4215e20e6ed3b74d6042f7ef8e5'
```

###### Check a number

```puppet
stdlib::sha256(100.0) == '43b87f618caab482ebe4976c92bcd6ad308b48055f1c27b4c574f3e31d7683e0'
stdlib::sha256(100.00000) == '43b87f618caab482ebe4976c92bcd6ad308b48055f1c27b4c574f3e31d7683e0'
```

##### `my_data`

Data type: `Variant[ScalarData, Sensitive[ScalarData], Binary, Sensitive[Binary]]`

The ScalarData to evaluate

### <a name="stdlib--shell_escape"></a>`stdlib::shell_escape`

Type: Ruby 4.x API

>* Note:* that the resulting string should be used unquoted and is not intended for use in double quotes nor in single
quotes.

This function behaves the same as ruby's Shellwords.shellescape() function.

#### `stdlib::shell_escape(Any $string)`

>* Note:* that the resulting string should be used unquoted and is not intended for use in double quotes nor in single
quotes.

This function behaves the same as ruby's Shellwords.shellescape() function.

Returns: `Any` An escaped string that can be safely used in a Bourne shell command line.

##### `string`

Data type: `Any`

The string to escape

### <a name="stdlib--sort_by"></a>`stdlib::sort_by`

Type: Ruby 4.x API

Sort an Array, Hash or String by mapping values through a given block.

#### Examples

##### Sort local devices according to their used space.

```puppet
$facts['mountpoints'].stdlib::sort_by |$m| { $m.dig(1, 'used_bytes') }
```

#### `stdlib::sort_by(Array $ary, Callable[1,1] &$block)`

The stdlib::sort_by function.

Returns: `Array` Returns an ordered copy of ary.

##### `ary`

Data type: `Array`

The Array to sort.

##### `&block`

Data type: `Callable[1,1]`

The block for transforming elements of ary.

#### `stdlib::sort_by(String $str, Callable[1,1] &$block)`

The stdlib::sort_by function.

Returns: `String` Returns an ordered copy of str.

##### `str`

Data type: `String`

The String to sort.

##### `&block`

Data type: `Callable[1,1]`

The block for transforming elements of str.

#### `stdlib::sort_by(Hash $hsh, Variant[Callable[1,1], Callable[2,2]] &$block)`

The stdlib::sort_by function.

Returns: `Hash` Returns an ordered copy of hsh.

##### `hsh`

Data type: `Hash`

The Hash to sort.

##### `&block`

Data type: `Variant[Callable[1,1], Callable[2,2]]`

The block for transforming elements of hsh.
The block may have arity of one or two.

### <a name="stdlib--start_with"></a>`stdlib::start_with`

Type: Ruby 4.x API

Returns true if str starts with one of the prefixes given. Each of the prefixes should be a String.

#### Examples

##### 

```puppet
'foobar'.stdlib::start_with('foo') => true
'foobar'.stdlib::start_with('bar') => false
'foObar'.stdlib::start_with(['bar', 'baz']) => false
```

#### `stdlib::start_with(String $test_string, Variant[String[1],Array[String[1], 1]] $prefixes)`

The stdlib::start_with function.

Returns: `Boolean` True or False

##### Examples

###### 

```puppet
'foobar'.stdlib::start_with('foo') => true
'foobar'.stdlib::start_with('bar') => false
'foObar'.stdlib::start_with(['bar', 'baz']) => false
```

##### `test_string`

Data type: `String`

The string to check

##### `prefixes`

Data type: `Variant[String[1],Array[String[1], 1]]`

The prefixes to check.

### <a name="stdlib--str2resource"></a>`stdlib::str2resource`

Type: Ruby 4.x API

This attempts to convert a string like 'File[/foo]' into the
puppet resource `File['/foo']` as detected by the catalog.

Things like 'File[/foo, /bar]' are not supported as a
title might contain things like ',' or ' '.  There is
no clear value seperator to use.

This function can depend on the parse order of your
manifests/modules as it inspects the catalog thus far.

#### Examples

##### 

```puppet
stdlib::str2resource('File[/foo]') => File[/foo]
```

#### `stdlib::str2resource(String $res_string)`

This attempts to convert a string like 'File[/foo]' into the
puppet resource `File['/foo']` as detected by the catalog.

Things like 'File[/foo, /bar]' are not supported as a
title might contain things like ',' or ' '.  There is
no clear value seperator to use.

This function can depend on the parse order of your
manifests/modules as it inspects the catalog thus far.

Returns: `Any` Puppet::Resource

##### Examples

###### 

```puppet
stdlib::str2resource('File[/foo]') => File[/foo]
```

##### `res_string`

Data type: `String`

The string to lookup as a resource

### <a name="stdlib--time"></a>`stdlib::time`

Type: Puppet Language

It is provided for compatability, but users should use the native time related functions directly.

#### `stdlib::time(Optional[String] $_timezone = undef)`

It is provided for compatability, but users should use the native time related functions directly.

Returns: `Integer`

##### `_timezone`

Data type: `Optional[String]`

This parameter doesn't do anything, but exists for compatability reasons

### <a name="stdlib--to_json"></a>`stdlib::to_json`

Type: Ruby 4.x API

Convert a data structure and output to JSON

#### Examples

##### Output JSON to a file

```puppet
file { '/tmp/my.json':
  ensure  => file,
  content => stdlib::to_json($myhash),
}
```

#### `stdlib::to_json(Any $data)`

Convert a data structure and output to JSON

Returns: `String` Converted data to JSON

##### Examples

###### Output JSON to a file

```puppet
file { '/tmp/my.json':
  ensure  => file,
  content => stdlib::to_json($myhash),
}
```

##### `data`

Data type: `Any`

Data structure which needs to be converted into JSON

### <a name="stdlib--to_json_pretty"></a>`stdlib::to_json_pretty`

Type: Ruby 4.x API

Convert data structure and output to pretty JSON

#### Examples

##### **Usage**

```puppet
* how to output pretty JSON to file
  file { '/tmp/my.json':
    ensure  => file,
    content => stdlib::to_json_pretty($myhash),
  }

* how to output pretty JSON skipping over keys with undef values
  file { '/tmp/my.json':
    ensure  => file,
    content => stdlib::to_json_pretty({
      param_one => 'value',
      param_two => undef,
    }, true),
  }

* how to output pretty JSON using tabs for indentation
  file { '/tmp/my.json':
    ensure  => file,
    content => stdlib::to_json_pretty({
      param_one => 'value',
      param_two => {
        param_more => 42,
      },
    }, nil, {indent => '    '}),
  }
```

#### `stdlib::to_json_pretty(Variant[Hash, Array] $data, Optional[Optional[Boolean]] $skip_undef, Optional[Struct[{
indent       => Optional[String],
space        => Optional[String],
space_before => Optional[String],
object_nl    => Optional[String],
array_nl     => Optional[String],
allow_nan    => Optional[Boolean],
max_nesting  => Optional[Integer[-1,default]],
}]] $opts)`

The stdlib::to_json_pretty function.

Returns: `Any` converted data to pretty json

##### Examples

###### **Usage**

```puppet
* how to output pretty JSON to file
  file { '/tmp/my.json':
    ensure  => file,
    content => stdlib::to_json_pretty($myhash),
  }

* how to output pretty JSON skipping over keys with undef values
  file { '/tmp/my.json':
    ensure  => file,
    content => stdlib::to_json_pretty({
      param_one => 'value',
      param_two => undef,
    }, true),
  }

* how to output pretty JSON using tabs for indentation
  file { '/tmp/my.json':
    ensure  => file,
    content => stdlib::to_json_pretty({
      param_one => 'value',
      param_two => {
        param_more => 42,
      },
    }, nil, {indent => '    '}),
  }
```

##### `data`

Data type: `Variant[Hash, Array]`

data structure which needs to be converted to pretty json

##### `skip_undef`

Data type: `Optional[Optional[Boolean]]`

value `true` or `false`

##### `opts`

Data type:

```puppet
Optional[Struct[{
indent       => Optional[String],
space        => Optional[String],
space_before => Optional[String],
object_nl    => Optional[String],
array_nl     => Optional[String],
allow_nan    => Optional[Boolean],
max_nesting  => Optional[Integer[-1,default]],
}]]
```

hash-map of settings passed to JSON.pretty_generate, see
https://ruby-doc.org/stdlib-2.0.0/libdoc/json/rdoc/JSON.html#method-i-generate.
Note that `max_nesting` doesn't take the value `false`; use `-1` instead.

### <a name="stdlib--to_python"></a>`stdlib::to_python`

Type: Ruby 4.x API

Convert an object into a String containing its Python representation

#### Examples

##### how to output Python

```puppet
# output Python to a file
$listen = '0.0.0.0'
$port = 8000
file { '/opt/acme/etc/settings.py':
  content => inline_epp(@("SETTINGS")),
    LISTEN = <%= stdlib::to_python($listen) %>
    PORT = <%= stdlib::to_python($mailserver) %>
    | SETTINGS
}
```

#### `stdlib::to_python(Any $object)`

The stdlib::to_python function.

Returns: `String` The String representation of the object

##### Examples

###### how to output Python

```puppet
# output Python to a file
$listen = '0.0.0.0'
$port = 8000
file { '/opt/acme/etc/settings.py':
  content => inline_epp(@("SETTINGS")),
    LISTEN = <%= stdlib::to_python($listen) %>
    PORT = <%= stdlib::to_python($mailserver) %>
    | SETTINGS
}
```

##### `object`

Data type: `Any`

The object to be converted

### <a name="stdlib--to_ruby"></a>`stdlib::to_ruby`

Type: Ruby 4.x API

Convert an object into a String containing its Ruby representation

#### Examples

##### how to output Ruby

```puppet
# output Ruby to a file
$listen = '0.0.0.0'
$port = 8000
file { '/opt/acme/etc/settings.rb':
  content => inline_epp(@("SETTINGS")),
    LISTEN = <%= stdlib::to_ruby($listen) %>
    PORT = <%= stdlib::to_ruby($mailserver) %>
    | SETTINGS
}
```

#### `stdlib::to_ruby(Any $object)`

The stdlib::to_ruby function.

Returns: `String` The String representation of the object

##### Examples

###### how to output Ruby

```puppet
# output Ruby to a file
$listen = '0.0.0.0'
$port = 8000
file { '/opt/acme/etc/settings.rb':
  content => inline_epp(@("SETTINGS")),
    LISTEN = <%= stdlib::to_ruby($listen) %>
    PORT = <%= stdlib::to_ruby($mailserver) %>
    | SETTINGS
}
```

##### `object`

Data type: `Any`

The object to be converted

### <a name="stdlib--to_toml"></a>`stdlib::to_toml`

Type: Ruby 4.x API

Convert a data structure and output to TOML.

#### Examples

##### How to output TOML to a file

```puppet
file { '/tmp/config.toml':
  ensure  => file,
  content => stdlib::to_toml($myhash),
}
```

#### `stdlib::to_toml(Hash $data)`

The stdlib::to_toml function.

Returns: `String` Converted data as TOML string

##### Examples

###### How to output TOML to a file

```puppet
file { '/tmp/config.toml':
  ensure  => file,
  content => stdlib::to_toml($myhash),
}
```

##### `data`

Data type: `Hash`

Data structure which needs to be converted into TOML

### <a name="stdlib--to_yaml"></a>`stdlib::to_yaml`

Type: Ruby 4.x API

Convert a data structure and output it as YAML

#### Examples

##### Output YAML to a file

```puppet
file { '/tmp/my.yaml':
  ensure  => file,
  content => stdlib::to_yaml($myhash),
}
```

##### Use options to control the output format

```puppet
file { '/tmp/my.yaml':
  ensure  => file,
  content => stdlib::to_yaml($myhash, {indentation => 4})
}
```

#### `stdlib::to_yaml(Any $data, Optional[Hash] $options)`

Convert a data structure and output it as YAML

Returns: `String` The YAML document

##### Examples

###### Output YAML to a file

```puppet
file { '/tmp/my.yaml':
  ensure  => file,
  content => stdlib::to_yaml($myhash),
}
```

###### Use options to control the output format

```puppet
file { '/tmp/my.yaml':
  ensure  => file,
  content => stdlib::to_yaml($myhash, {indentation => 4})
}
```

##### `data`

Data type: `Any`

The data you want to convert to YAML

##### `options`

Data type: `Optional[Hash]`

A hash of options that will be passed to Ruby's Psych library. Note, this could change between Puppet versions, but at time of writing these are `line_width`, `indentation`, and `canonical`.

### <a name="stdlib--type_of"></a>`stdlib::type_of`

Type: Ruby 4.x API

See the documentation for "The Puppet Type System" for more information about types.
See the `assert_type()` function for flexible ways to assert the type of a value.

The built-in type() function in puppet is generally preferred over this function
this function is provided for backwards compatibility.

#### Examples

##### how to compare values' types

```puppet
# compare the types of two values
if stdlib::type_of($first_value) != stdlib::type_of($second_value) { fail("first_value and second_value are different types") }
```

##### how to compare against an abstract type

```puppet
unless stdlib::type_of($first_value) <= Numeric { fail("first_value must be Numeric") }
unless stdlib::type_of{$first_value) <= Collection[1] { fail("first_value must be an Array or Hash, and contain at least one element") }
```

#### `stdlib::type_of(Any $value)`

See the documentation for "The Puppet Type System" for more information about types.
See the `assert_type()` function for flexible ways to assert the type of a value.

The built-in type() function in puppet is generally preferred over this function
this function is provided for backwards compatibility.

Returns: `String` the type of the passed value

##### Examples

###### how to compare values' types

```puppet
# compare the types of two values
if stdlib::type_of($first_value) != stdlib::type_of($second_value) { fail("first_value and second_value are different types") }
```

###### how to compare against an abstract type

```puppet
unless stdlib::type_of($first_value) <= Numeric { fail("first_value must be Numeric") }
unless stdlib::type_of{$first_value) <= Collection[1] { fail("first_value must be an Array or Hash, and contain at least one element") }
```

##### `value`

Data type: `Any`



### <a name="stdlib--validate_domain_name"></a>`stdlib::validate_domain_name`

Type: Ruby 4.x API

Validate that all values passed are syntactically correct domain names.
Fail compilation if any value fails this check.

#### Examples

##### Passing examples

```puppet
$my_domain_name = 'server.domain.tld'
stdlib::validate_domain_name($my_domain_name)
stdlib::validate_domain_name('domain.tld', 'puppet.com', $my_domain_name)
stdlib::validate_domain_name('www.example.2com')
```

##### Failing examples (causing compilation to abort)

```puppet
stdlib::validate_domain_name(1)
stdlib::validate_domain_name(true)
stdlib::validate_domain_name('invalid domain')
stdlib::validate_domain_name('-foo.example.com')
```

#### `stdlib::validate_domain_name(Variant[Stdlib::Fqdn, Stdlib::Dns::Zone] *$values)`

The stdlib::validate_domain_name function.

Returns: `Undef` passes when the given values are syntactically correct domain names or raise an error when they are not and fails compilation

##### Examples

###### Passing examples

```puppet
$my_domain_name = 'server.domain.tld'
stdlib::validate_domain_name($my_domain_name)
stdlib::validate_domain_name('domain.tld', 'puppet.com', $my_domain_name)
stdlib::validate_domain_name('www.example.2com')
```

###### Failing examples (causing compilation to abort)

```puppet
stdlib::validate_domain_name(1)
stdlib::validate_domain_name(true)
stdlib::validate_domain_name('invalid domain')
stdlib::validate_domain_name('-foo.example.com')
```

##### `*values`

Data type: `Variant[Stdlib::Fqdn, Stdlib::Dns::Zone]`

A domain name or an array of domain names to check

### <a name="stdlib--validate_email_address"></a>`stdlib::validate_email_address`

Type: Ruby 4.x API

Validate that all values passed are valid email addresses.
Fail compilation if any value fails this check.

#### Examples

##### Passing examples

```puppet
$my_email = "waldo@gmail.com"
stdlib::validate_email_address($my_email)
stdlib::validate_email_address("bob@gmail.com", "alice@gmail.com", $my_email)
```

##### Failing examples (causing compilation to abort)

```puppet
$some_array = [ 'bad_email@/d/efdf.com' ]
stdlib::validate_email_address($some_array)
```

#### `stdlib::validate_email_address(Stdlib::Email *$values)`

The stdlib::validate_email_address function.

Returns: `Undef` Fail compilation if any value fails this check.

##### Examples

###### Passing examples

```puppet
$my_email = "waldo@gmail.com"
stdlib::validate_email_address($my_email)
stdlib::validate_email_address("bob@gmail.com", "alice@gmail.com", $my_email)
```

###### Failing examples (causing compilation to abort)

```puppet
$some_array = [ 'bad_email@/d/efdf.com' ]
stdlib::validate_email_address($some_array)
```

##### `*values`

Data type: `Stdlib::Email`

An e-mail address or an array of e-mail addresses to check

### <a name="stdlib--xml_encode"></a>`stdlib::xml_encode`

Type: Ruby 4.x API

This function can encode strings such that they can be used directly in XML files.
It supports encoding for both XML text (CharData) or attribute values (AttValue).

#### Examples

##### Creating an XML file from a template

```puppet
file { '/path/to/config.xml':
  ensure  => file,
  content => epp(
    'mymodule/config.xml.epp',
    {
      password => $password.stdlib::xml_encode,
    },
  ),
}
```

#### `stdlib::xml_encode(String $str, Optional[Enum['text','attr']] $type)`

This function can encode strings such that they can be used directly in XML files.
It supports encoding for both XML text (CharData) or attribute values (AttValue).

Returns: `String` Returns the encoded CharData or AttValue string suitable for use in XML

##### Examples

###### Creating an XML file from a template

```puppet
file { '/path/to/config.xml':
  ensure  => file,
  content => epp(
    'mymodule/config.xml.epp',
    {
      password => $password.stdlib::xml_encode,
    },
  ),
}
```

##### `str`

Data type: `String`

The string to encode

##### `type`

Data type: `Optional[Enum['text','attr']]`

Whether to encode for text or an attribute

### <a name="str2bool"></a>`str2bool`

Type: Ruby 3.x API

> *Note:* that since Puppet 5.0.0 the Boolean data type can convert strings to a Boolean value.
See the function new() in Puppet for details what the Boolean data type supports.

#### `str2bool()`

> *Note:* that since Puppet 5.0.0 the Boolean data type can convert strings to a Boolean value.
See the function new() in Puppet for details what the Boolean data type supports.

Returns: `Any` This attempt to convert to boolean strings that contain things like: Y,y, 1, T,t, TRUE,true to 'true' and strings that contain things
like: 0, F,f, N,n, false, FALSE, no to 'false'.

### <a name="str2saltedpbkdf2"></a>`str2saltedpbkdf2`

Type: Ruby 3.x API

Convert a string into a salted SHA512 PBKDF2 password hash like requred for OS X / macOS 10.8+.
Note, however, that Apple changes what's required periodically and this may not work for the latest
version of macOS. If that is the case you should get a helpful error message when Puppet tries to set
the pasword using the parameters you provide to the user resource.

#### Examples

##### Plain text password and salt

```puppet
$pw_info = str2saltedpbkdf2('Pa55w0rd', 'Use a s@lt h3r3 th@t is 32 byt3s', 50000)
user { 'jdoe':
  ensure     => present,
  iterations => $pw_info['interations'],
  password   => $pw_info['password_hex'],
  salt       => $pw_info['salt_hex'],
}
```

##### Sensitive password and salt

```puppet
$pw = Sensitive.new('Pa55w0rd')
$salt = Sensitive.new('Use a s@lt h3r3 th@t is 32 byt3s')
$pw_info = Sensitive.new(str2saltedpbkdf2($pw, $salt, 50000))
user { 'jdoe':
  ensure     => present,
  iterations => unwrap($pw_info)['interations'],
  password   => unwrap($pw_info)['password_hex'],
  salt       => unwrap($pw_info)['salt_hex'],
}
```

#### `str2saltedpbkdf2()`

Convert a string into a salted SHA512 PBKDF2 password hash like requred for OS X / macOS 10.8+.
Note, however, that Apple changes what's required periodically and this may not work for the latest
version of macOS. If that is the case you should get a helpful error message when Puppet tries to set
the pasword using the parameters you provide to the user resource.

Returns: `Hash` Provides a hash containing the hex version of the password, the hex version of the salt, and iterations.

##### Examples

###### Plain text password and salt

```puppet
$pw_info = str2saltedpbkdf2('Pa55w0rd', 'Use a s@lt h3r3 th@t is 32 byt3s', 50000)
user { 'jdoe':
  ensure     => present,
  iterations => $pw_info['interations'],
  password   => $pw_info['password_hex'],
  salt       => $pw_info['salt_hex'],
}
```

###### Sensitive password and salt

```puppet
$pw = Sensitive.new('Pa55w0rd')
$salt = Sensitive.new('Use a s@lt h3r3 th@t is 32 byt3s')
$pw_info = Sensitive.new(str2saltedpbkdf2($pw, $salt, 50000))
user { 'jdoe':
  ensure     => present,
  iterations => unwrap($pw_info)['interations'],
  password   => unwrap($pw_info)['password_hex'],
  salt       => unwrap($pw_info)['salt_hex'],
}
```

### <a name="str2saltedsha512"></a>`str2saltedsha512`

Type: Ruby 3.x API

Given any simple string, you will get a hex version
of a salted-SHA512 password hash that can be inserted into your Puppet
manifests as a valid password attribute.

#### `str2saltedsha512()`

Given any simple string, you will get a hex version
of a salted-SHA512 password hash that can be inserted into your Puppet
manifests as a valid password attribute.

Returns: `Any` converted string as a hex version of a salted-SHA512 password hash

### <a name="suffix"></a>`suffix`

Type: Ruby 3.x API

> *Note:* that since Puppet 4.0.0 the general way to modify values is in array is by using the map
function in Puppet. This example does the same as the example above:

```['a', 'b', 'c'].map |$x| { "${x}p" }```

#### Examples

##### **Usage**

```puppet

suffix(['a','b','c'], 'p')
Will return: ['ap','bp','cp']
```

#### `suffix()`

> *Note:* that since Puppet 4.0.0 the general way to modify values is in array is by using the map
function in Puppet. This example does the same as the example above:

```['a', 'b', 'c'].map |$x| { "${x}p" }```

Returns: `Any` Array or Hash with updated elements containing the passed suffix

##### Examples

###### **Usage**

```puppet

suffix(['a','b','c'], 'p')
Will return: ['ap','bp','cp']
```

### <a name="swapcase"></a>`swapcase`

Type: Ruby 3.x API

This function will swap the existing case of a string.

#### Examples

##### **Usage**

```puppet

swapcase("aBcD")
Would result in: "AbCd"
```

#### `swapcase()`

The swapcase function.

Returns: `Any` string with uppercase alphabetic characters converted to lowercase and lowercase characters converted to uppercase

##### Examples

###### **Usage**

```puppet

swapcase("aBcD")
Would result in: "AbCd"
```

### <a name="time"></a>`time`

Type: Ruby 4.x API

DEPRECATED.  Use the native Puppet fuctionality instead of this function. eg `Integer(Timestamp().strftime('%s'))`

#### `time(Any *$args)`

The time function.

Returns: `Any`

##### `*args`

Data type: `Any`



### <a name="to_bytes"></a>`to_bytes`

Type: Ruby 3.x API

Takes a single string value as an argument.
These conversions reflect a layperson's understanding of
1 MB = 1024 KB, when in fact 1 MB = 1000 KB, and 1 MiB = 1024 KiB.

#### `to_bytes()`

Takes a single string value as an argument.
These conversions reflect a layperson's understanding of
1 MB = 1024 KB, when in fact 1 MB = 1000 KB, and 1 MiB = 1024 KiB.

Returns: `Any` converted value into bytes

### <a name="to_json"></a>`to_json`

Type: Ruby 4.x API

DEPRECATED.  Use the namespaced function [`stdlib::to_json`](#stdlibto_json) instead.

#### `to_json(Any *$args)`

The to_json function.

Returns: `Any`

##### `*args`

Data type: `Any`



### <a name="to_json_pretty"></a>`to_json_pretty`

Type: Ruby 4.x API

DEPRECATED.  Use the namespaced function [`stdlib::to_json_pretty`](#stdlibto_json_pretty) instead.

#### `to_json_pretty(Any *$args)`

The to_json_pretty function.

Returns: `Any`

##### `*args`

Data type: `Any`



### <a name="to_python"></a>`to_python`

Type: Ruby 4.x API

DEPRECATED.  Use the namespaced function [`stdlib::to_python`](#stdlibto_python) instead.

#### `to_python(Any *$args)`

The to_python function.

Returns: `Any`

##### `*args`

Data type: `Any`



### <a name="to_ruby"></a>`to_ruby`

Type: Ruby 4.x API

DEPRECATED.  Use the namespaced function [`stdlib::to_ruby`](#stdlibto_ruby) instead.

#### `to_ruby(Any *$args)`

The to_ruby function.

Returns: `Any`

##### `*args`

Data type: `Any`



### <a name="to_toml"></a>`to_toml`

Type: Ruby 4.x API

DEPRECATED.  Use the namespaced function [`stdlib::to_toml`](#stdlibto_toml) instead.

#### `to_toml(Any *$args)`

The to_toml function.

Returns: `Any`

##### `*args`

Data type: `Any`



### <a name="to_yaml"></a>`to_yaml`

Type: Ruby 4.x API

DEPRECATED.  Use the namespaced function [`stdlib::to_yaml`](#stdlibto_yaml) instead.

#### `to_yaml(Any *$args)`

The to_yaml function.

Returns: `Any`

##### `*args`

Data type: `Any`



### <a name="type_of"></a>`type_of`

Type: Ruby 4.x API

DEPRECATED.  Use the namespaced function [`stdlib::type_of`](#stdlibtype_of) instead.

#### `type_of(Any *$args)`

The type_of function.

Returns: `Any`

##### `*args`

Data type: `Any`



### <a name="union"></a>`union`

Type: Ruby 3.x API

This function returns a union of two or more arrays.

#### Examples

##### **Usage**

```puppet

union(["a","b","c"],["b","c","d"])
Would return: ["a","b","c","d"]
```

#### `union()`

The union function.

Returns: `Any` a unionized array of two or more arrays

##### Examples

###### **Usage**

```puppet

union(["a","b","c"],["b","c","d"])
Would return: ["a","b","c","d"]
```

### <a name="unix2dos"></a>`unix2dos`

Type: Ruby 3.x API

Takes a single string argument.

#### `unix2dos()`

Takes a single string argument.

Returns: `Any` the DOS version of the given string.

### <a name="uriescape"></a>`uriescape`

Type: Ruby 3.x API

> **Note:**  **Deprecated:** Starting Puppet 8, our Ruby version has upgraded to 3.2.
Therefore, its no longer possible to call URI.escape as it was deprecated by 2.7 and removed completely by 3+.
This function should be removed once Puppet 7 is no longer supported.

#### `uriescape()`

> **Note:**  **Deprecated:** Starting Puppet 8, our Ruby version has upgraded to 3.2.
Therefore, its no longer possible to call URI.escape as it was deprecated by 2.7 and removed completely by 3+.
This function should be removed once Puppet 7 is no longer supported.

Returns: `String` a string that contains the converted value

### <a name="validate_augeas"></a>`validate_augeas`

Type: Ruby 3.x API

The first argument of this function should be a string to
test, and the second argument should be the name of the Augeas lens to use.
If Augeas fails to parse the string with the lens, the compilation will
abort with a parse error.

A third argument can be specified, listing paths which should
not be found in the file. The `$file` variable points to the location
of the temporary file being tested in the Augeas tree.

#### Examples

##### **Usage**

```puppet

If you want to make sure your passwd content never contains
a user `foo`, you could write:

  validate_augeas($passwdcontent, 'Passwd.lns', ['$file/foo'])

If you wanted to ensure that no users used the '/bin/barsh' shell,
you could use:

  validate_augeas($passwdcontent, 'Passwd.lns', ['$file/*[shell="/bin/barsh"]']

If a fourth argument is specified, this will be the error message raised and
seen by the user.

A helpful error message can be returned like this:

  validate_augeas($sudoerscontent, 'Sudoers.lns', [], 'Failed to validate sudoers content with Augeas')
```

#### `validate_augeas()`

The first argument of this function should be a string to
test, and the second argument should be the name of the Augeas lens to use.
If Augeas fails to parse the string with the lens, the compilation will
abort with a parse error.

A third argument can be specified, listing paths which should
not be found in the file. The `$file` variable points to the location
of the temporary file being tested in the Augeas tree.

Returns: `Any` validate string using an Augeas lens

##### Examples

###### **Usage**

```puppet

If you want to make sure your passwd content never contains
a user `foo`, you could write:

  validate_augeas($passwdcontent, 'Passwd.lns', ['$file/foo'])

If you wanted to ensure that no users used the '/bin/barsh' shell,
you could use:

  validate_augeas($passwdcontent, 'Passwd.lns', ['$file/*[shell="/bin/barsh"]']

If a fourth argument is specified, this will be the error message raised and
seen by the user.

A helpful error message can be returned like this:

  validate_augeas($sudoerscontent, 'Sudoers.lns', [], 'Failed to validate sudoers content with Augeas')
```

### <a name="validate_cmd"></a>`validate_cmd`

Type: Ruby 3.x API

The first argument of this function should be a string to
test, and the second argument should be a path to a test command
taking a % as a placeholder for the file path (will default to the end).
If the command, launched against a tempfile containing the passed string,
returns a non-null value, compilation will abort with a parse error.
If a third argument is specified, this will be the error message raised and
seen by the user.

A helpful error message can be returned like this:

#### Examples

##### **Usage**

```puppet

Defaults to end of path
  validate_cmd($sudoerscontent, '/usr/sbin/visudo -c -f', 'Visudo failed to validate sudoers content')

% as file location
  validate_cmd($haproxycontent, '/usr/sbin/haproxy -f % -c', 'Haproxy failed to validate config content')
```

#### `validate_cmd()`

The first argument of this function should be a string to
test, and the second argument should be a path to a test command
taking a % as a placeholder for the file path (will default to the end).
If the command, launched against a tempfile containing the passed string,
returns a non-null value, compilation will abort with a parse error.
If a third argument is specified, this will be the error message raised and
seen by the user.

A helpful error message can be returned like this:

Returns: `Any` validate of a string with an external command

##### Examples

###### **Usage**

```puppet

Defaults to end of path
  validate_cmd($sudoerscontent, '/usr/sbin/visudo -c -f', 'Visudo failed to validate sudoers content')

% as file location
  validate_cmd($haproxycontent, '/usr/sbin/haproxy -f % -c', 'Haproxy failed to validate config content')
```

### <a name="validate_domain_name"></a>`validate_domain_name`

Type: Ruby 4.x API

DEPRECATED.  Use the namespaced function [`stdlib::validate_domain_name`](#stdlibvalidate_domain_name) instead.

#### `validate_domain_name(Any *$args)`

The validate_domain_name function.

Returns: `Any`

##### `*args`

Data type: `Any`



### <a name="validate_email_address"></a>`validate_email_address`

Type: Ruby 4.x API

DEPRECATED.  Use the namespaced function [`stdlib::validate_email_address`](#stdlibvalidate_email_address) instead.

#### `validate_email_address(Any *$args)`

The validate_email_address function.

Returns: `Any`

##### `*args`

Data type: `Any`



### <a name="validate_legacy"></a>`validate_legacy`

Type: Ruby 4.x API

**Deprecated:** Validate a value against both the target_type (new).

#### `validate_legacy(Any $scope, Type $target_type, String $function_name, Any $value, Any *$args)`

The function checks a value against both the target_type (new).

Returns: `Any` A boolean value (`true` or `false`) returned from the called function.

##### `scope`

Data type: `Any`

The main value that will be passed to the method

##### `target_type`

Data type: `Type`



##### `function_name`

Data type: `String`

Unused

##### `value`

Data type: `Any`



##### `*args`

Data type: `Any`

Any additional values that are to be passed to the method

#### `validate_legacy(Any $scope, String $type_string, String $function_name, Any $value, Any *$args)`

The validate_legacy function.

Returns: `Any` Legacy validation method

##### `scope`

Data type: `Any`

The main value that will be passed to the method

##### `type_string`

Data type: `String`



##### `function_name`

Data type: `String`

Unused

##### `value`

Data type: `Any`



##### `*args`

Data type: `Any`

Any additional values that are to be passed to the method

### <a name="validate_x509_rsa_key_pair"></a>`validate_x509_rsa_key_pair`

Type: Ruby 3.x API

Verifies that the certficate's signature was created from the
supplied key.

```validate_x509_rsa_key_pair($cert, $key)```

#### `validate_x509_rsa_key_pair()`

Verifies that the certficate's signature was created from the
supplied key.

```validate_x509_rsa_key_pair($cert, $key)```

Returns: `Any` Fail compilation if any value fails this check.

### <a name="values_at"></a>`values_at`

Type: Ruby 3.x API

The first argument is the array you want to analyze, and the second element can
be a combination of:

* A single numeric index
* A range in the form of 'start-stop' (eg. 4-9)
* An array combining the above

> *Note:*
Since Puppet 4.0.0 it is possible to slice an array with index and count directly in the language.
A negative value is taken to be "from the end" of the array:

`['a', 'b', 'c', 'd'][1, 2]`   results in `['b', 'c']`
`['a', 'b', 'c', 'd'][2, -1]`  results in `['c', 'd']`
`['a', 'b', 'c', 'd'][1, -2]`  results in `['b', 'c']`

#### Examples

##### **Usage**

```puppet

values_at(['a','b','c'], 2)
Would return ['c']

values_at(['a','b','c'], ["0-1"])
Would return ['a','b']

values_at(['a','b','c','d','e'], [0, "2-3"])
Would return ['a','c','d']
```

#### `values_at()`

The first argument is the array you want to analyze, and the second element can
be a combination of:

* A single numeric index
* A range in the form of 'start-stop' (eg. 4-9)
* An array combining the above

> *Note:*
Since Puppet 4.0.0 it is possible to slice an array with index and count directly in the language.
A negative value is taken to be "from the end" of the array:

`['a', 'b', 'c', 'd'][1, 2]`   results in `['b', 'c']`
`['a', 'b', 'c', 'd'][2, -1]`  results in `['c', 'd']`
`['a', 'b', 'c', 'd'][1, -2]`  results in `['b', 'c']`

Returns: `Any` an array of values identified by location

##### Examples

###### **Usage**

```puppet

values_at(['a','b','c'], 2)
Would return ['c']

values_at(['a','b','c'], ["0-1"])
Would return ['a','b']

values_at(['a','b','c','d','e'], [0, "2-3"])
Would return ['a','c','d']
```

### <a name="zip"></a>`zip`

Type: Ruby 3.x API

Takes one element from first array and merges corresponding elements from second array.

#### Examples

##### 

```puppet
zip(['1','2','3'],['4','5','6'])
Would result in: ["1", "4"], ["2", "5"], ["3", "6"]
```

#### `zip()`

The zip function.

Returns: `Any` This generates a sequence of n-element arrays, where n is one more than the count of arguments.

##### Examples

###### 

```puppet
zip(['1','2','3'],['4','5','6'])
Would result in: ["1", "4"], ["2", "5"], ["3", "6"]
```

## Data types

### <a name="Stdlib--Absolutepath"></a>`Stdlib::Absolutepath`

A strict absolutepath type

Alias of `Variant[Stdlib::Windowspath, Stdlib::Unixpath]`

### <a name="Stdlib--Base32"></a>`Stdlib::Base32`

Type to match base32 String

Alias of `Pattern[/\A[a-z2-7]+={,6}\z/, /\A[A-Z2-7]+={,6}\z/]`

### <a name="Stdlib--Base64"></a>`Stdlib::Base64`

Type to match base64 String

Alias of `Pattern[/\A[a-zA-Z0-9\/\+]+={,2}\z/]`

### <a name="Stdlib--CreateResources"></a>`Stdlib::CreateResources`

A type description used for the create_resources function

#### Examples

##### As a class parameter

```puppet
class myclass (
  Stdlib::CreateResources $myresources = {},
) {
  # Using create_resources
  create_resources('myresource', $myresources)

  # Using iteration
  $myresources.each |$myresource_name, $myresource_attrs| {
    myresource { $myresource_name:
      * => $myresource_attrs,
    }
  }
}
```

Alias of `Hash[String[1], Hash[String[1], Any]]`

### <a name="Stdlib--Datasize"></a>`Stdlib::Datasize`

Validate the size of data

Alias of `Pattern[/^\d+(?i:[kmgt]b?|b)$/]`

### <a name="Stdlib--Dns--Zone"></a>`Stdlib::Dns::Zone`

Validate a DNS zone name

Alias of `Pattern[/\A((([a-zA-Z0-9]|[a-zA-Z0-9][a-zA-Z0-9-]*[a-zA-Z0-9])\.)+|\.)\z/]`

### <a name="Stdlib--Email"></a>`Stdlib::Email`

https://html.spec.whatwg.org/multipage/input.html#valid-e-mail-address
lint:ignore:140chars

Alias of `Pattern[/\A[a-zA-Z0-9.!#$%&'*+\/=?^_`{|}~-]+@[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?(?:\.[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?)*\z/]`

### <a name="Stdlib--Ensure--File"></a>`Stdlib::Ensure::File`

Validate the value of the ensure parameter for a file

Alias of `Enum['present', 'file', 'directory', 'link', 'absent']`

### <a name="Stdlib--Ensure--File--Directory"></a>`Stdlib::Ensure::File::Directory`

Validate the ensure parameter of a "directory" file resource

Alias of `Enum['directory', 'absent']`

### <a name="Stdlib--Ensure--File--File"></a>`Stdlib::Ensure::File::File`

Validate the ensure parameter of a "file" file resource

Alias of `Enum['file', 'absent']`

### <a name="Stdlib--Ensure--File--Link"></a>`Stdlib::Ensure::File::Link`

Validate the ensure parameter of a "link" file resource

Alias of `Enum['link', 'absent']`

### <a name="Stdlib--Ensure--Package"></a>`Stdlib::Ensure::Package`

Validate the value of the ensure parameter for a package

Alias of `Variant[Enum['present', 'absent', 'purged', 'disabled', 'installed', 'latest'], String[1]]`

### <a name="Stdlib--Ensure--Service"></a>`Stdlib::Ensure::Service`

Validate the value of the ensure parameter of a service resource

Alias of `Enum['stopped', 'running']`

### <a name="Stdlib--Filemode"></a>`Stdlib::Filemode`

See `man chmod.1` for the regular expression for symbolic mode
lint:ignore:140chars

Alias of `Pattern[/\A(([0-7]{1,4})|(([ugoa]*([-+=]([rwxXst]*|[ugo]))+|[-+=][0-7]+)(,([ugoa]*([-+=]([rwxXst]*|[ugo]))+|[-+=][0-7]+))*))\z/]`

### <a name="Stdlib--Filesource"></a>`Stdlib::Filesource`

Validate the source parameter on file types

Alias of

```puppet
Variant[Stdlib::Absolutepath, Stdlib::HTTPUrl, Pattern[
    /\Afile:\/\/\/([^\n\/\0]+(\/)?)+\z/,
    /\Apuppet:\/\/(([\w-]+\.?)+)?\/([^\n\/\0]+(\/)?)+\z/,
  ]]
```

### <a name="Stdlib--Fqdn"></a>`Stdlib::Fqdn`

Validate a Fully Qualified Domain Name

Alias of `Pattern[/\A(([a-zA-Z0-9]|[a-zA-Z0-9][a-zA-Z0-9\-]*[a-zA-Z0-9])\.)*([A-Za-z0-9]|[A-Za-z0-9][A-Za-z0-9\-]*[A-Za-z0-9])\z/]`

### <a name="Stdlib--HTTPSUrl"></a>`Stdlib::HTTPSUrl`

Validate a HTTPS URL

Alias of `Pattern[/(?i:\Ahttps:\/\/.*\z)/]`

### <a name="Stdlib--HTTPUrl"></a>`Stdlib::HTTPUrl`

Validate a HTTP(S) URL

Alias of `Pattern[/(?i:\Ahttps?:\/\/.*\z)/]`

### <a name="Stdlib--Host"></a>`Stdlib::Host`

Validate a host (FQDN or IP address)

Alias of `Variant[Stdlib::Fqdn, Stdlib::IP::Address]`

### <a name="Stdlib--Http--Method"></a>`Stdlib::Http::Method`

Valid HTTP method verbs

* **See also**
  * https://www.iana.org/assignments/http-methods/http-methods.xhtml

Alias of `Enum['ACL', 'BASELINE-CONTROL', 'BIND', 'CHECKIN', 'CHECKOUT', 'CONNECT', 'COPY', 'DELETE', 'GET', 'HEAD', 'LABEL', 'LINK', 'LOCK', 'MERGE', 'MKACTIVITY', 'MKCALENDAR', 'MKCOL', 'MKREDIRECTREF', 'MKWORKSPACE', 'MOVE', 'OPTIONS', 'ORDERPATCH', 'PATCH', 'POST', 'PRI', 'PROPFIND', 'PROPPATCH', 'PUT', 'REBIND', 'REPORT', 'SEARCH', 'TRACE', 'UNBIND', 'UNCHECKOUT', 'UNLINK', 'UNLOCK', 'UPDATE', 'UPDATEREDIRECTREF', 'VERSION-CONTROL']`

### <a name="Stdlib--Http--Status"></a>`Stdlib::Http::Status`

A valid HTTP status code per RFC9110

* **See also**
  * https://httpwg.org/specs/rfc9110.html#overview.of.status.codes

Alias of `Integer[100, 599]`

### <a name="Stdlib--HttpStatus"></a>`Stdlib::HttpStatus`

Validate a HTTP status code

* **DEPRECATED** Use Stdlib::Http::Status

* **See also**
  * Stdlib::Http::Status

Alias of `Stdlib::Http::Status`

### <a name="Stdlib--IP--Address"></a>`Stdlib::IP::Address`

Validate an IP address

Alias of `Variant[Stdlib::IP::Address::V4, Stdlib::IP::Address::V6]`

### <a name="Stdlib--IP--Address--CIDR"></a>`Stdlib::IP::Address::CIDR`

Validate an IP address with subnet

Alias of `Variant[Stdlib::IP::Address::V4::CIDR, Stdlib::IP::Address::V6::CIDR]`

### <a name="Stdlib--IP--Address--Nosubnet"></a>`Stdlib::IP::Address::Nosubnet`

Validate an IP address without subnet

Alias of `Variant[Stdlib::IP::Address::V4::Nosubnet, Stdlib::IP::Address::V6::Nosubnet]`

### <a name="Stdlib--IP--Address--V4"></a>`Stdlib::IP::Address::V4`

Validate an IPv4 address

Alias of `Variant[Stdlib::IP::Address::V4::CIDR, Stdlib::IP::Address::V4::Nosubnet]`

### <a name="Stdlib--IP--Address--V4--CIDR"></a>`Stdlib::IP::Address::V4::CIDR`

lint:ignore:140chars

Alias of `Pattern[/\A([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}\/([0-9]|[12][0-9]|3[0-2])\z/]`

### <a name="Stdlib--IP--Address--V4--Nosubnet"></a>`Stdlib::IP::Address::V4::Nosubnet`

lint:ignore:140chars

Alias of `Pattern[/\A([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}\z/]`

### <a name="Stdlib--IP--Address--V6"></a>`Stdlib::IP::Address::V6`

Validate an IPv6 address

Alias of `Variant[Stdlib::IP::Address::V6::Full, Stdlib::IP::Address::V6::Compressed, Stdlib::IP::Address::V6::Alternative, Stdlib::IP::Address::V6::Nosubnet]`

### <a name="Stdlib--IP--Address--V6--Alternative"></a>`Stdlib::IP::Address::V6::Alternative`

lint:ignore:140chars

Alias of `Pattern[/\A([[:xdigit:]]{1,4}:){6}([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}(\/(1([01][0-9]|2[0-8])|[1-9][0-9]|[0-9]))?\z/, /\A([[:xdigit:]]{1,4}:){5}:([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}(\/(1([01][0-9]|2[0-8])|[1-9][0-9]|[0-9]))?\z/, /\A([[:xdigit:]]{1,4}:){4}(:[[:xdigit:]]{1,4}){0,1}:([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}(\/(1([01][0-9]|2[0-8])|[1-9][0-9]|[0-9]))?\z/, /\A([[:xdigit:]]{1,4}:){3}(:[[:xdigit:]]{1,4}){0,2}:([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}(\/(1([01][0-9]|2[0-8])|[1-9][0-9]|[0-9]))?\z/, /\A([[:xdigit:]]{1,4}:){2}(:[[:xdigit:]]{1,4}){0,3}:([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}(\/(1([01][0-9]|2[0-8])|[1-9][0-9]|[0-9]))?\z/, /\A([[:xdigit:]]{1,4}:){1}(:[[:xdigit:]]{1,4}){0,4}:([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}(\/(1([01][0-9]|2[0-8])|[1-9][0-9]|[0-9]))?\z/, /\A:(:[[:xdigit:]]{1,4}){0,5}:([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}(\/(1([01][0-9]|2[0-8])|[1-9][0-9]|[0-9]))?\z/]`

### <a name="Stdlib--IP--Address--V6--CIDR"></a>`Stdlib::IP::Address::V6::CIDR`

lint:ignore:140chars

Alias of `Pattern[/\A((([0-9A-Fa-f]{1,4}:){7}([0-9A-Fa-f]{1,4}|:))|(([0-9A-Fa-f]{1,4}:){6}(:[0-9A-Fa-f]{1,4}|((25[0-5]|2[0-4]d|1dd|[1-9]?d)(.(25[0-5]|2[0-4]d|1dd|[1-9]?d)){3})|:))|(([0-9A-Fa-f]{1,4}:){5}(((:[0-9A-Fa-f]{1,4}){1,2})|:((25[0-5]|2[0-4]d|1dd|[1-9]?d)(.(25[0-5]|2[0-4]d|1dd|[1-9]?d)){3})|:))|(([0-9A-Fa-f]{1,4}:){4}(((:[0-9A-Fa-f]{1,4}){1,3})|((:[0-9A-Fa-f]{1,4})?:((25[0-5]|2[0-4]d|1dd|[1-9]?d)(.(25[0-5]|2[0-4]d|1dd|[1-9]?d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){3}(((:[0-9A-Fa-f]{1,4}){1,4})|((:[0-9A-Fa-f]{1,4}){0,2}:((25[0-5]|2[0-4]d|1dd|[1-9]?d)(.(25[0-5]|2[0-4]d|1dd|[1-9]?d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){2}(((:[0-9A-Fa-f]{1,4}){1,5})|((:[0-9A-Fa-f]{1,4}){0,3}:((25[0-5]|2[0-4]d|1dd|[1-9]?d)(.(25[0-5]|2[0-4]d|1dd|[1-9]?d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){1}(((:[0-9A-Fa-f]{1,4}){1,6})|((:[0-9A-Fa-f]{1,4}){0,4}:((25[0-5]|2[0-4]d|1dd|[1-9]?d)(.(25[0-5]|2[0-4]d|1dd|[1-9]?d)){3}))|:))|(:(((:[0-9A-Fa-f]{1,4}){1,7})|((:[0-9A-Fa-f]{1,4}){0,5}:((25[0-5]|2[0-4]d|1dd|[1-9]?d)(.(25[0-5]|2[0-4]d|1dd|[1-9]?d)){3}))|:)))(%.+)?s*\/([0-9]|[1-9][0-9]|1[0-1][0-9]|12[0-8])?\z/]`

### <a name="Stdlib--IP--Address--V6--Compressed"></a>`Stdlib::IP::Address::V6::Compressed`

Validate a compressed IPv6 address

Alias of `Pattern[/\A:(:|(:[[:xdigit:]]{1,4}){1,7})(\/(1([01][0-9]|2[0-8])|[1-9][0-9]|[0-9]))?\z/, /\A([[:xdigit:]]{1,4}:){1}(:|(:[[:xdigit:]]{1,4}){1,6})(\/(1([01][0-9]|2[0-8])|[1-9][0-9]|[0-9]))?\z/, /\A([[:xdigit:]]{1,4}:){2}(:|(:[[:xdigit:]]{1,4}){1,5})(\/(1([01][0-9]|2[0-8])|[1-9][0-9]|[0-9]))?\z/, /\A([[:xdigit:]]{1,4}:){3}(:|(:[[:xdigit:]]{1,4}){1,4})(\/(1([01][0-9]|2[0-8])|[1-9][0-9]|[0-9]))?\z/, /\A([[:xdigit:]]{1,4}:){4}(:|(:[[:xdigit:]]{1,4}){1,3})(\/(1([01][0-9]|2[0-8])|[1-9][0-9]|[0-9]))?\z/, /\A([[:xdigit:]]{1,4}:){5}(:|(:[[:xdigit:]]{1,4}){1,2})(\/(1([01][0-9]|2[0-8])|[1-9][0-9]|[0-9]))?\z/, /\A([[:xdigit:]]{1,4}:){6}(:|(:[[:xdigit:]]{1,4}){1,1})(\/(1([01][0-9]|2[0-8])|[1-9][0-9]|[0-9]))?\z/, /\A([[:xdigit:]]{1,4}:){7}:(\/(1([01][0-9]|2[0-8])|[1-9][0-9]|[0-9]))?\z/]`

### <a name="Stdlib--IP--Address--V6--Full"></a>`Stdlib::IP::Address::V6::Full`

Validate a full IPv6 address

Alias of `Pattern[/\A[[:xdigit:]]{1,4}(:[[:xdigit:]]{1,4}){7}(\/(1([01][0-9]|2[0-8])|[1-9][0-9]|[0-9]))?\z/]`

### <a name="Stdlib--IP--Address--V6--Nosubnet"></a>`Stdlib::IP::Address::V6::Nosubnet`

Validate an IPv6 address without subnet

Alias of `Variant[Stdlib::IP::Address::V6::Nosubnet::Full, Stdlib::IP::Address::V6::Nosubnet::Compressed, Stdlib::IP::Address::V6::Nosubnet::Alternative]`

### <a name="Stdlib--IP--Address--V6--Nosubnet--Alternative"></a>`Stdlib::IP::Address::V6::Nosubnet::Alternative`

lint:ignore:140chars

Alias of `Pattern[/\A([[:xdigit:]]{1,4}:){6}([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}\z/, /\A([[:xdigit:]]{1,4}:){5}:([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}\z/, /\A([[:xdigit:]]{1,4}:){4}(:[[:xdigit:]]{1,4}){0,1}:([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}\z/, /\A([[:xdigit:]]{1,4}:){3}(:[[:xdigit:]]{1,4}){0,2}:([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}\z/, /\A([[:xdigit:]]{1,4}:){2}(:[[:xdigit:]]{1,4}){0,3}:([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}\z/, /\A([[:xdigit:]]{1,4}:){1}(:[[:xdigit:]]{1,4}){0,4}:([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}\z/, /\A:(:[[:xdigit:]]{1,4}){0,5}:([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}\z/]`

### <a name="Stdlib--IP--Address--V6--Nosubnet--Compressed"></a>`Stdlib::IP::Address::V6::Nosubnet::Compressed`

Validate compressed IPv6 address without subnet

Alias of `Pattern[/\A:(:|(:[[:xdigit:]]{1,4}){1,7})\z/, /\A([[:xdigit:]]{1,4}:){1}(:|(:[[:xdigit:]]{1,4}){1,6})\z/, /\A([[:xdigit:]]{1,4}:){2}(:|(:[[:xdigit:]]{1,4}){1,5})\z/, /\A([[:xdigit:]]{1,4}:){3}(:|(:[[:xdigit:]]{1,4}){1,4})\z/, /\A([[:xdigit:]]{1,4}:){4}(:|(:[[:xdigit:]]{1,4}){1,3})\z/, /\A([[:xdigit:]]{1,4}:){5}(:|(:[[:xdigit:]]{1,4}){1,2})\z/, /\A([[:xdigit:]]{1,4}:){6}(:|(:[[:xdigit:]]{1,4}){1,1})\z/, /\A([[:xdigit:]]{1,4}:){7}:\z/]`

### <a name="Stdlib--IP--Address--V6--Nosubnet--Full"></a>`Stdlib::IP::Address::V6::Nosubnet::Full`

Validate full IPv6 address without subnet

Alias of `Pattern[/\A[[:xdigit:]]{1,4}(:[[:xdigit:]]{1,4}){7}\z/]`

### <a name="Stdlib--MAC"></a>`Stdlib::MAC`

A type for a MAC address

Alias of `Pattern[/\A([0-9A-Fa-f]{2}[:-]){5}([0-9A-Fa-f]{2})\z/, /\A([0-9A-Fa-f]{2}[:-]){19}([0-9A-Fa-f]{2})\z/]`

### <a name="Stdlib--ObjectStore"></a>`Stdlib::ObjectStore`

Validate an ObjectStore

Alias of `Variant[Stdlib::ObjectStore::GSUri, Stdlib::ObjectStore::S3Uri]`

### <a name="Stdlib--ObjectStore--GSUri"></a>`Stdlib::ObjectStore::GSUri`

Validate a Google Cloud object store URI

Alias of `Pattern[/\Ags:\/\/.*\z/]`

### <a name="Stdlib--ObjectStore--S3Uri"></a>`Stdlib::ObjectStore::S3Uri`

Validate an Amazon Web Services S3 object store URI

Alias of `Pattern[/\As3:\/\/.*\z/]`

### <a name="Stdlib--Port"></a>`Stdlib::Port`

Validate a port number

Alias of `Integer[0, 65535]`

### <a name="Stdlib--Port--Dynamic"></a>`Stdlib::Port::Dynamic`

Validate a dynamic port number

Alias of `Integer[49152, 65535]`

### <a name="Stdlib--Port--Ephemeral"></a>`Stdlib::Port::Ephemeral`

Validate an ephemeral port number

Alias of `Stdlib::Port::Dynamic`

### <a name="Stdlib--Port--Privileged"></a>`Stdlib::Port::Privileged`

Validate a priviliged port number

Alias of `Integer[1, 1023]`

### <a name="Stdlib--Port--Registered"></a>`Stdlib::Port::Registered`

Validate a registered port number

Alias of `Stdlib::Port::User`

### <a name="Stdlib--Port--Unprivileged"></a>`Stdlib::Port::Unprivileged`

Validate an unprivileged port number

Alias of `Integer[1024, 65535]`

### <a name="Stdlib--Port--User"></a>`Stdlib::Port::User`

Validate a port number usable by a user

Alias of `Integer[1024, 49151]`

### <a name="Stdlib--Syslogfacility"></a>`Stdlib::Syslogfacility`

Validate a syslog facility

Alias of `Enum['kern', 'user', 'mail', 'daemon', 'auth', 'syslog', 'lpr', 'news', 'uucp', 'cron', 'authpriv', 'ftp', 'ntp', 'security', 'console', 'solaris-cron', 'local0', 'local1', 'local2', 'local3', 'local4', 'local5', 'local6', 'local7']`

### <a name="Stdlib--Unixpath"></a>`Stdlib::Unixpath`

this regex rejects any path component that does not start with "/" or is NUL

Alias of `Pattern[/\A\/([^\n\/\0]+\/*)*\z/]`

### <a name="Stdlib--Windowspath"></a>`Stdlib::Windowspath`

Validate a Windows path

Alias of `Pattern[/\A(([a-zA-Z]:[\\\/])|([\\\/][\\\/][^\\\/]+[\\\/][^\\\/]+)|([\\\/][\\\/]\?[\\\/][^\\\/]+)).*\z/]`

### <a name="Stdlib--Yes_no"></a>`Stdlib::Yes_no`

Validate a yes / no value

Alias of `Pattern[/\A(?i:(yes|no))\z/]`

