#!/opt/puppetlabs/puppet/bin/ruby
# frozen_string_literal: true

require_relative '../files/enterprise_task_helper.rb'
require 'open3'
require 'yaml'

class GetPackageVersion < EnterpriseTaskHelper
  def task(package:, **_kwargs)
    command = ['/opt/puppetlabs/bin/puppet', 'resource', '--to_yaml', 'package', package]
    output, stderr, status = Open3.capture3(*command)

    raise(EnterpriseTaskHelper::Error.new("Failed '#{command.join(' ')}' call.", 'puppetlabs.get-package-version/puppet-resource-error', { output: output, err: stderr, status: status.exitstatus })) if !status.success?

    package_info_hash = YAML.safe_load(output.strip)
    version = package_info_hash.dig('package', package, 'ensure')

    raise EnterpriseTaskHelper::Error.new("#{package} is not installed", 'puppetlabs.get-package-version/puppet-config-error', output: output) if version == 'purged'

    { version: version }
  end
end

GetPackageVersion.run if __FILE__ == $PROGRAM_NAME
