# Clear the cached catalogs prior to configuring services.
#
# In split installations, this prevents the upgrade on a node from being rolled
# back by a cached catalog if the local agent runs after puppet-infra configure
# but before PE is completely upgraded on the other nodes. In this situation,
# the agent run would fail and attempt to fall back to a cached catalog.
#
class pe_install::upgrade::clear_cached_catalogs(
  Boolean $clear_cache = $pe_install::is_upgrade,
) {
  if $clear_cache {
    file { $::settings::client_datadir:
      ensure  => absent,
      recurse => true,
      purge   => true,
      backup  => false,
    }
  }
}
