# Class for setting cross-class global overrides. See README.md for more
# details.
class pe_postgresql::globals (
  $ensure               = undef,

  $client_package_name  = undef,
  $server_package_name  = undef,
  $contrib_package_name = undef,
  $devel_package_name   = undef,
  $java_package_name    = undef,
  $perl_package_name    = undef,
  $plperl_package_name  = undef,
  $python_package_name  = undef,
  $postgis_package_name = undef,

  $service_name         = undef,
  $service_provider     = undef,
  $service_status       = undef,
  $default_database     = undef,

  $initdb_path          = undef,
  $createdb_path        = undef,
  $psql_path            = undef,
  $pg_hba_conf_path     = undef,
  $postgresql_conf_path = undef,

  $pg_hba_conf_defaults = undef,

  $datadir              = undef,
  $confdir              = undef,
  $bindir               = undef,
  $xlogdir              = undef,

  $user                 = undef,
  $group                = undef,

  $version              = undef,
  $postgis_version      = undef,

  $needs_initdb         = undef,

  $encoding             = undef,
  $locale               = undef,
  Optional[Boolean] $data_checksums = undef,
  $ctype                = undef,
  $collate              = undef,

  $manage_pg_hba_conf   = undef,

  $manage_package_repo  = undef
) {
  # We are determining this here, because it is needed by the package repo
  # class.
  #
  # This differs from the upstream postgresql module. Because we use this for
  # PE, and we only use one version in PE at any given time, we set this to
  # the default version used in PE. In reality, this value doesn't really get
  # used, as we set the version parameter is almost all cases. The one exception
  # is the puppet_enterprise::postgresql::client class when it is applied on
  # a non-database node. But the version set here doesn't actually matter
  # for that purpose, since we're just installing the particular client
  # package we explicitly specify in that case.
  $default_version = '11'
  $globals_version = pe_pick($version, $default_version, 'unknown')
  if($globals_version == 'unknown') {
    fail('No preferred version defined or automatically detected.')
  }

  # This is also not used in PE, so rather than use what's in the 
  # upstream postgresql module, just set it to something.
  $default_postgis_version = '2.5'
  $globals_postgis_version = pe_pick($postgis_version, $default_postgis_version)

  # Setup of the repo only makes sense globally, so we are doing this here.
  if($manage_package_repo) {
    # Workaround the lack of RHEL7 repositories for now.
    if ! ($facts['os']['name'] == 'RedHat' and $facts['os']['release']['full'] =~ /^7/) {
      class { 'pe_postgresql::repo':
        ensure  => $ensure,
        version => $globals_version
      }
    }
  }
}
