Puppet::Functions.create_function(:'pe_repo::is_dev_build') do
  dispatch :is_dev_build do
    param 'Optional[String]', :agent_version
    param 'Optional[String]', :pe_build_version
  end

  def is_dev_build(agent_version, pe_build_version)
    return false if agent_version.nil? || pe_build_version.nil?

    agent_is_dev = agent_version.count('.') >= 3
    pe_build_is_dev = pe_build_version.include?('-')

    agent_is_dev || pe_build_is_dev
  end
end
