# frozen_string_literal: true

require 'pathname'

# Returns an array containing all of the filenames except for "." and ".." in the given directory.
Puppet::Functions.create_function(:'dir::children', Puppet::Functions::InternalFunction) do
  # @param dirname Absolute path or Puppet module name.
  # @return Array of files in the given directory.
  # @example List filenames from an absolute path.
  #   dir::children('/home/user/subdir/')
  # @example List filenames from a Puppet file path.
  #   dir::children('puppet_agent')
  dispatch :children do
    scope_param
    required_param 'String', :dirname
    return_type 'Array'
  end

  def children(scope, dirname)
    # https://tickets.puppetlabs.com/browse/PE-29862
    raise Puppet::Error, "dir::children is currently not supported in PE plans"
  end
end