# frozen_string_literal: true

# THIS IS A PE SPECIFIC IMPLEMENTATION OF FILE::EXISTS: THIS IMPLEMENTATION WILL OVERRIDE THE ONE
# THAT COMES WITH A BOLT INSTALLATION
#
# Open-source bolt implementation:
# https://github.com/puppetlabs/bolt/blob/master/bolt-modules/file/lib/puppet/functions/file/exists.rb
#
# file::exists for plans-in-PE will return an error since it is not needed in the current iteration
# of plans in PE.
Puppet::Functions.create_function(:'file::exists', Puppet::Functions::InternalFunction) do
  dispatch :exists do
    scope_param
    required_param 'String', :filename
    return_type 'Boolean'
  end

  def exists(scope, filename)
    raise Puppet::Error, "file::exists is currently not supported in PE plans"
  end
end
