# puppet infrastructure enable

## MAN PAGE

```
USAGE: puppet infrastructure enable [--token-file <token_path>]
[--print-config]
[-y | --yes]
[--topology <topology>]
[--skip-agent-config]
[--force]
[--pcp-brokers <uris>]
[--infra-pcp-brokers <uris>]
[--puppetdb-termini <uris>]
[--classifier-termini <uris>]
[--agent-server-urls <uris>]
[--infra-agent-server-urls <uris>]
replica <replica_certname>

After a node has been fully provisioned, it needs to be enabled.

DESCRIPTION:
Enables a provisioned replica to take over from a master during a failover. It
does this by updating classification so that all components of your PE
installation will know to contact the replica in the case of a failure.
The enable interview asks you to describe your installation:
  - mono - All PE services run on the primary master and all agents connect to
    that master.
  - mono-with-compile - All PE services run on the primary master but agents
    connect to compile masters via a load balancer. PE infrastructure nodes will
    still check in with the primary master and fail over to the replica.
You can also specify topology with the --topology flag.
If mono-with-compile is selected, the load balancer hostname and port must be
provided, either during the interview or with the --agent-server-urls and
--pcp-brokers flags.
You'll have the opportunity to review and confirm changes before they're made.

REQUIREMENTS:
  - A provisioned replica to enable.
  - A valid token that has permission to run the Puppet agent with orchestrator.
    You can generate a token with `puppet access login`.
This command must be invoked on the primary master.

OPTIONS:
  --agent-server-urls <URIS>        Hostnames and ports of your Puppet masters
                                    to run your Puppet agents against, in the
                                    order they should be tried. Sets the puppet
                                    agent `server_list` setting on all agents.
                                    In a compile master topology, should be the
                                    hostname and port of the load balancer.
                                    Format: --agent-server-urls hostname:port,hostname:port
  --pcp-brokers <URIS>              Hostnames and ports of the PCP brokers
                                    agents should connect to in the order they
                                    should be tried. Used to create the
                                    `broker_ws_uris` on all agents.  In a compile
                                    master topology, should be the hostname and port
                                    of the pcp load balancer.
                                    Format: --pcp-brokers hostname:port,hostname:port
  -—classifier-termini <URIS>       Hostnames and ports of your Node Classifiers
  -—infra-agent-server-urls <URIS>  Hostnames and ports your Puppet Masters to run your
                                    Puppet Infrastructure Agents against
  --infra-pcp-brokers <URIS>        Hostnames and ports of your PCP Brokers for
                                    PE infrastructure
  -—puppetdb-termini <URIS>         Hostnames and ports of your PuppetDBs
  --print-config                    Print the current configuration.
  --token-file                      Specifies path to an RBAC token to use for
                                    authentication. Defaults to ~/.puppetlabs/token.
  --topology <TOPOLOGY>             The topology of your Puppet Enterprise
                                    installation: mono or mono-with-compile.
  --skip-agent-config               Do not change agent settings when enabling replica.
                                    Agent failover settings must be configured by the user.
  -yes, -y                          Answer yes to all confirmations.
  --force                           Skip all pre-enable validation. Skipping checks will
                                    mean that prerequisite services may not be configured or
                                    running and some enable steps may fail or need to be
                                    manually run.
  --render-as <FORMAT>              The rendering format to use.
  --verbose                         Whether to log verbosely.
  --debug                           Whether to log debug information.
  --trace                           Displays stack traces.
  --help, -h                        Displays man page.
```

## Examples
### Normal usage
```
> puppet infrastructure enable replica HOSTNAME

Back up the current node classifier hierarchy before enabling a primary master replica, because the enabling process modifies the hierarchy.

Describe your PE setup:

A. Monolithic with a single master
B. Monolithic with compile masters

Which describes your setup? [A/b]
> <user input>
```

Next lists current known configuration.
(don’t show current config if this is the first replica and nothing is configured)
```
Current configuration:
agent-server-urls
infra-agent-server-urls
infra-pcp-brokers
pcp-brokers
puppetdb-termini
classifier-termini
```

If choice b and no --agent-server-urls, output:

```
What server(s) should agents connect to?
```

Next, if a or b, output:

```
New configuration when the primary master replica is enabled:
agent-server-urls
infra-agent-server-urls
infra-pcp-brokers
pcp-brokers
puppetdb-termini
classifier-termini

Run Puppet on infrastructure nodes to apply the new configuration? [Y/n]
```

if Y, output:

**TODO** validate there is no other output
```
\#{replica\_certname} has been enabled for your Puppet Enterprise
infrastructure. Agent configuration is now managed with Puppet, and will
be updated the next time each agent runs to enable replica failover.
If you wish to immediately run Puppet on all your agents, you can do so
with this command:
    puppet job run --no-enforce-environment --query 'nodes {deactivated is null}'
```

If n, output:

```
No configuration changes were made. The primary master replica hasn’t been enabled.

When you are ready to proceed, enter `puppet infrastructure enable replica HOSTNAME`
—agent-server-urls hostname:port/prefix,hostname:port/prefix
—infra-agent-server-urls hostname:port/prefix,hostname:port/prefix
—pcp-brokers hostname:port/prefix,hostname:port/prefix
—infra-pcp-brokers hostname:port/prefix,hostname:port/prefix
—puppetdb-termini hostname:port/prefix,hostname:port/prefix
—classifier-termini hostname:port/prefix,hostname:port/prefix`
```

Ex to indicate a single monolithic install, run on infra nodes, no output:
```
> puppet infrastructure enable replica HOSTNAME --yes --topology=mono
```

Ex of not all flags specified:
```
> puppet infrastructure enable replica HOSTNAME —agent-server-urls —puppetdb-termini

New configuration when the primary master replica is enabled:
agent-server-urls (show new value specified in flag)
infra-agent-server-urls (show values that were already there)
pcp-brokers (show values that were already there)
puppetdb-termini (show new value specified in flag)
classifier-termini (show values that were already there)

Run Puppet on infrastructure nodes to apply the new configuration? [Y/n]
```

Ex of not all flags specified and run on infra nodes now:
```
> puppet infrastructure enable replica HOSTNAME —agent-server-urls —puppetdb-termini --run-infra
```

User must specify all flags. If they only If 2 and no --agent-server-urls, output:
```
What server(s) should agents connect to?

If 1 or 2, output:

New configuration when the primary master replica is enabled:
agent-server-urls
infra-agent-server-urls
pcp-brokers
puppetdb-termini
classifier-termini

Run Puppet on infrastructure nodes to apply the new configuration? [Y/n]
```

if Y, output:

```
#{replica_certname} has been enabled for your Puppet Enterprise
infrastructure. Agent configuration is now managed with Puppet, and will
be updated the next time each agent runs to enable replica failover.
If you wish to immediately run Puppet on all your agents, you can do so
with this command:
    puppet job run --no-enforce-environment --query 'nodes {deactivated is null}'
```

If n, output:

```
No configuration changes were made. The primary master replica hasn’t been enabled.

When you are ready to proceed, enter `puppet infrastructure enable replica HOSTNAME`
—agent-server-urls hostname:port/prefix,hostname:port/prefix
—infra-agent-server-urls hostname:port/prefix,hostname:port/prefix
—pcp-brokers hostname:port/prefix,hostname:port/prefix
—puppetdb-termini hostname:port/prefix,hostname:port/prefix
—classifier-termini hostname:port/prefix,hostname:port/prefix`
```

Ex to indicate a single monolithic install, run on infra nodes, no output:
```
> puppet infrastructure enable replica HOSTNAME --yes --topology=mono
```

enter some, tell them which ones are missing and prompt to enter all.>


Ex of looking at current config without running (if you started the process yesterday and want to continue today but don’t remember where you left off):
```
> puppet infrastructure enable replica HOSTNAME --print-config

Current configuration:
—agent-server-urls
—infra-agent-server-urls
—pcp-brokers
—puppetdb-termini
—classifier-termini
```

### Errors
Error - while running puppet
```
An error occurred while running Puppet. See the report at <link> for more details.
```

## Designed, but not implemented features
### Flags

```
--silent, -s Run in non-interactive mode.
```

Discussed, but not implemented.

### Errors
Error using --silent flag alone or with --mono-only or --mono-compilemaster:
Not implemented because the --silent flag was not implemented.

```
> puppet infrastructure enable replica HOSTNAME --silent
The --silent flag must be used in combination with at least one of the following flags:
—agent-server-urls hostname:port/prefix,hostname:port/prefix
—infra-agent-server-urls hostname:port/prefix,hostname:port/prefix
—pcp-brokers hostname:port/prefix,hostname:port/prefix
—puppetdb-termini hostname:port/prefix,hostname:port/prefix
—classifier-termini hostname:port/prefix,hostname:port/prefix
--run-infra

If you are unsure which flags to use, enter `puppet infrastructure enable replica HOSTNAME` for guidance.
```
