# Wrapper class to determine if pe_databases has been installed,
# and whether it came from user code or PE profile code
class puppet_enterprise::pe_databases() {
  if $settings::storeconfigs {
    # User version
    $has_pe_databases = puppet_enterprise::class_previously_included('Pe_databases')
    # PE version
    $has_vendor_pe_databases = puppet_enterprise::class_previously_included('Pe_databases', 'pe_databases_vendor_version')

    # There are two situations where we include the class here:
      # If it has not been applied previously by us or the user
      # If we have previously applied it and the class is not already part of this catalog compilation
    if (!$has_vendor_pe_databases and !$has_pe_databases) or ($has_vendor_pe_databases and !defined(Class['pe_databases'])) {
      class {'pe_databases':
        tag => ['pe_databases_vendor_version'],
      }
    }
  }
}
