#pragma once
// The purpose of this include is to trick HorseWhisperer to use
// boost::nowide::cout wherever it normally uses std::cout.

#include <boost/nowide/iostream.hpp>

namespace HorseWhisperer {
  // define HorseWhisperer::std namespace
  namespace std {
    // delegate to the global std namespace
    using namespace ::std;
    // hide the ::std::cout definition with an alias of boost::nowide::cout
    auto& cout = boost::nowide::cout;
  }
}

#include <horsewhisperer/horsewhisperer.h>
